/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.time;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

@Extension(name="extract", namespace="time", description="description", parameters={@Parameter(name="start.time", description="The batch time period for which the window should hold events.", type={DataType.INT, DataType.LONG, DataType.TIME}), @Parameter(name="unit", description="This specifies an offset in milliseconds in order to start the window at a time different to the standard time.", type={DataType.STRING})}, returnAttributes={@ReturnAttribute(description="Returned type will be defined by the cast.to string constant value.", type={DataType.INT})}, examples={@Example(syntax="define window cseEventWindow (symbol string, price float, volume int) timeBatch(20) output all events;\n@info(name = 'query0')\nfrom cseEventStream\ninsert into cseEventWindow;\n@info(name = 'query1')\nfrom cseEventWindow\nselect symbol, sum(price) as price\ninsert all events into outputStream ;", description="This will processing events arrived every 20 milliseconds as a batch and out put all events.")})
public class ExtractAttributesFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.INT;
    private boolean useDefaultDateFormat = false;
    private String dateFormat = null;
    private Calendar cal = Calendar.getInstance();
    private String unit = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init(ExpressionExecutor[] expressionExecutors, ConfigReader configReader, ExecutionPlanContext executionPlanContext) {
        if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG && this.attributeExpressionExecutors.length == 2) {
            this.useDefaultDateFormat = true;
            this.dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        if (this.attributeExpressionExecutors.length == 3) {
            if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:extract(unit,dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[0].getReturnType().toString());
            }
            if (this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:extract(unit,dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[1].getReturnType().toString());
            }
            if (this.attributeExpressionExecutors[2].getReturnType() != Attribute.Type.STRING) {
                throw new ExecutionPlanValidationException("Invalid parameter type found for the third argument of time:extract(unit,dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[2].getReturnType().toString());
            }
            if (!(this.attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new OperationNotSupportedException("unit value has to be a constant");
            this.unit = ((String)((ConstantExpressionExecutor)this.attributeExpressionExecutors[0]).getValue()).toUpperCase();
            return;
        } else {
            if (this.attributeExpressionExecutors.length != 2) throw new ExecutionPlanValidationException("Invalid no of arguments passed to time:extract() function, required 2 or 3, but found " + this.attributeExpressionExecutors.length);
            if (this.useDefaultDateFormat) {
                if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:extract(unit,dateValue) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:extract(unit,dateValue) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[1].getReturnType().toString());
                }
            } else {
                if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:extract(timestampInMilliseconds,unit) function, required " + Attribute.Type.LONG + " but found " + this.attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:extract(timestampInMilliseconds,unit) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[1].getReturnType().toString());
                }
            }
            if (!(this.attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) throw new OperationNotSupportedException("unit value has to be a constant");
            this.unit = ((String)((ConstantExpressionExecutor)this.attributeExpressionExecutors[1]).getValue()).toUpperCase();
        }
    }

    protected Object execute(Object[] data) {
        String source = null;
        if (data.length == 3 || this.useDefaultDateFormat) {
            try {
                if (data[1] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to time:extract(unit,dateValue,dateFormat) function. Second argument cannot be null");
                }
                if (!this.useDefaultDateFormat) {
                    if (data[2] == null) {
                        throw new ExecutionPlanRuntimeException("Invalid input given to time:extract(unit,dateValue,dateFormat) function. Third argument cannot be null");
                    }
                    this.dateFormat = (String)data[2];
                }
                source = (String)data[1];
                FastDateFormat userSpecificFormat = FastDateFormat.getInstance(this.dateFormat);
                Date userSpecifiedDate = userSpecificFormat.parse(source);
                this.cal.setTime(userSpecifiedDate);
            }
            catch (ParseException e) {
                String errorMsg = "Provided format " + this.dateFormat + " does not match with the timestamp " + source + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
            catch (ClassCastException e) {
                String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
        }
        if (data[0] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to time:extract(timestampInMilliseconds,unit) function. First argument cannot be null");
        }
        try {
            long millis = (Long)data[0];
            this.cal.setTimeInMillis(millis);
        }
        catch (ClassCastException e) {
            String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
            throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
        }
        int returnValue = 0;
        if (this.unit.equals("YEAR")) {
            returnValue = this.cal.get(1);
        } else if (this.unit.equals("MONTH")) {
            returnValue = this.cal.get(2) + 1;
        } else if (this.unit.equals("SECOND")) {
            returnValue = this.cal.get(13);
        } else if (this.unit.equals("MINUTE")) {
            returnValue = this.cal.get(12);
        } else if (this.unit.equals("HOUR")) {
            returnValue = this.cal.get(11);
        } else if (this.unit.equals("DAY")) {
            returnValue = this.cal.get(5);
        } else if (this.unit.equals("WEEK")) {
            returnValue = this.cal.get(3);
        } else if (this.unit.equals("QUARTER")) {
            returnValue = this.cal.get(2) / 3 + 1;
        }
        return returnValue;
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return new HashMap<String, Object>();
    }

    public void restoreState(Map<String, Object> map) {
    }
}

