/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class ExtractDayOfWeekFunctionExtension
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(ExtractDayOfWeekFunctionExtension.class);
    private Attribute.Type returnType = Attribute.Type.STRING;

    protected void init(ExpressionExecutor[] expressionExecutors, ConfigReader configReader, ExecutionPlanContext executionPlanContext) {
        if (this.attributeExpressionExecutors.length > 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to time:dayOfWeek(dateValue,dateFormat) function, required 2, but found " + this.attributeExpressionExecutors.length);
        }
        if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:dayOfWeek(dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[0].getReturnType().toString());
        }
        if (this.attributeExpressionExecutors.length > 0 && this.attributeExpressionExecutors.length > 1 && this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:dayOfWeek(dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + this.attributeExpressionExecutors[1].getReturnType().toString());
        }
    }

    protected Object execute(Object[] data) {
        String userFormat;
        if (data[0] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to time:dayOfWeek(dateValue,dateFormat) function. First argument cannot be null");
        }
        if (data.length > 1) {
            if (data[1] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to time:dayOfWeek(dateValue,dateFormat) function. Second argument cannot be null");
            }
            userFormat = (String)data[1];
        } else {
            userFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        String source = null;
        try {
            source = (String)data[0];
            FastDateFormat userSpecificFormat = FastDateFormat.getInstance(userFormat);
            Date userSpecifiedDate = userSpecificFormat.parse(source);
            return this.getDayOfWeek(userSpecifiedDate);
        }
        catch (ParseException e) {
            String errorMsg = "Provided format " + userFormat + " does not match with the timestamp " + source + e.getMessage();
            throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
        }
        catch (ClassCastException e) {
            String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
            throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
        }
    }

    protected Object execute(Object data) {
        if (data == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to time:dayOfWeek(dateValue,dateFormat) function. First argument cannot be null");
        }
        String userFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        try {
            String source = (String)data;
            String[] inputData = source.split(" ");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date date = format.parse(inputData[0]);
                return this.getDayOfWeek(date);
            }
            catch (ParseException e) {
                String errorMsg = "Provided format " + userFormat + " does not match with the timestamp " + source + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
        }
        catch (ClassCastException e) {
            String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
            throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return new HashMap<String, Object>();
    }

    public void restoreState(Map<String, Object> map) {
    }

    private String getDayOfWeek(Date date) {
        SimpleDateFormat dateFormatDayOfWeek = new SimpleDateFormat("EEEE");
        return dateFormatDayOfWeek.format(date);
    }
}

