/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.time;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

public class UniqueExternalTimeBatchWindowProcessor
extends WindowProcessor
implements SchedulingProcessor,
FindableProcessor {
    private Map<Object, StreamEvent> currentEvents = new LinkedHashMap<Object, StreamEvent>();
    private Map<Object, StreamEvent> expiredEvents = null;
    private volatile StreamEvent resetEvent = null;
    private VariableExpressionExecutor timestampExpressionExecutor;
    private long timeToKeep;
    private long endTime = -1L;
    private long startTime = 0L;
    private boolean isStartTimeEnabled = false;
    private long schedulerTimeout = 0L;
    private Scheduler scheduler;
    private long lastScheduledTime;
    private long lastCurrentEventTime;
    private boolean flushed = false;
    private boolean storeExpiredEvents = false;
    private VariableExpressionExecutor variableExpressionExecutor;
    private boolean replaceTimestampWithBatchEndTime = false;
    private boolean outputExpectsExpiredEvents = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init(ExpressionExecutor[] expressionExecutors, ConfigReader configReader, boolean b, ExecutionPlanContext executionPlanContext) {
        if (this.outputExpectsExpiredEvents) {
            this.expiredEvents = new LinkedHashMap<Object, StreamEvent>();
            this.storeExpiredEvents = true;
        }
        if (this.attributeExpressionExecutors.length < 3 || this.attributeExpressionExecutors.length > 6) throw new ExecutionPlanValidationException("ExternalTimeBatch window should only have three to six parameters (<variable> uniqueAttribute, <long> timestamp, <int|long|time> windowTime, <long> startTime, <int|long|time> timeout, <bool> replaceTimestampWithBatchEndTime), but found " + this.attributeExpressionExecutors.length + " input attributes");
        if (!(this.attributeExpressionExecutors[0] instanceof VariableExpressionExecutor)) {
            throw new ExecutionPlanValidationException("ExternalTime window's 1st parameter uniqueAttribute should be a variable, but found " + this.attributeExpressionExecutors[0].getClass());
        }
        this.variableExpressionExecutor = (VariableExpressionExecutor)this.attributeExpressionExecutors[0];
        if (!(this.attributeExpressionExecutors[1] instanceof VariableExpressionExecutor)) {
            throw new ExecutionPlanValidationException("ExternalTime window's 2nd parameter timestamp should be a variable, but found " + this.attributeExpressionExecutors[1].getClass());
        }
        if (this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.LONG) {
            throw new ExecutionPlanValidationException("ExternalTime window's 2nd parameter timestamp should be type long, but found " + this.attributeExpressionExecutors[1].getReturnType());
        }
        this.timestampExpressionExecutor = (VariableExpressionExecutor)this.attributeExpressionExecutors[1];
        if (this.attributeExpressionExecutors[2].getReturnType() == Attribute.Type.INT) {
            this.timeToKeep = ((Integer)((ConstantExpressionExecutor)this.attributeExpressionExecutors[2]).getValue()).intValue();
        } else {
            if (this.attributeExpressionExecutors[2].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("ExternalTimeBatch window's 3rd parameter windowTime should be either int or long, but found " + this.attributeExpressionExecutors[2].getReturnType());
            this.timeToKeep = (Long)((ConstantExpressionExecutor)this.attributeExpressionExecutors[2]).getValue();
        }
        if (this.attributeExpressionExecutors.length >= 4) {
            this.isStartTimeEnabled = true;
            if (this.attributeExpressionExecutors[3].getReturnType() == Attribute.Type.INT) {
                this.startTime = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)this.attributeExpressionExecutors[3]).getValue()));
            } else {
                if (this.attributeExpressionExecutors[3].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("ExternalTimeBatch window's 4th parameter startTime should be either int or long, but found " + this.attributeExpressionExecutors[3].getReturnType());
                this.startTime = Long.parseLong(String.valueOf(((ConstantExpressionExecutor)this.attributeExpressionExecutors[3]).getValue()));
            }
        }
        if (this.attributeExpressionExecutors.length >= 5) {
            if (this.attributeExpressionExecutors[4].getReturnType() == Attribute.Type.INT) {
                this.schedulerTimeout = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)this.attributeExpressionExecutors[4]).getValue()));
            } else {
                if (this.attributeExpressionExecutors[4].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("ExternalTimeBatch window's 5th parameter timeout should be either int or long, but found " + this.attributeExpressionExecutors[4].getReturnType());
                this.schedulerTimeout = Long.parseLong(String.valueOf(((ConstantExpressionExecutor)this.attributeExpressionExecutors[4]).getValue()));
            }
        }
        if (this.attributeExpressionExecutors.length == 6) {
            if (this.attributeExpressionExecutors[5].getReturnType() != Attribute.Type.BOOL) throw new ExecutionPlanValidationException("ExternalTimeBatch window's 6th parameter replaceTimestampWithBatchEndTime should be bool, but found " + this.attributeExpressionExecutors[5].getReturnType());
            this.replaceTimestampWithBatchEndTime = Boolean.parseBoolean(String.valueOf(((ConstantExpressionExecutor)this.attributeExpressionExecutors[5]).getValue()));
        }
        if (this.schedulerTimeout <= 0L || this.expiredEvents != null) return;
        this.expiredEvents = new LinkedHashMap<Object, StreamEvent>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        if (streamEventChunk.getFirst() == null) {
            return;
        }
        ArrayList<ComplexEventChunk<StreamEvent>> complexEventChunks = new ArrayList<ComplexEventChunk<StreamEvent>>();
        UniqueExternalTimeBatchWindowProcessor uniqueExternalTimeBatchWindowProcessor = this;
        synchronized (uniqueExternalTimeBatchWindowProcessor) {
            void var6_7;
            this.initTiming((StreamEvent)streamEventChunk.getFirst());
            StreamEvent streamEvent = (StreamEvent)streamEventChunk.getFirst();
            while (var6_7 != null) {
                void currStreamEvent = var6_7;
                StreamEvent streamEvent2 = var6_7.getNext();
                if (currStreamEvent.getType() == ComplexEvent.Type.TIMER) {
                    if (this.lastScheduledTime > currStreamEvent.getTimestamp()) continue;
                    if (!this.flushed) {
                        this.flushToOutputChunk(streamEventCloner, complexEventChunks, this.lastCurrentEventTime, true);
                        this.flushed = true;
                    } else if (this.currentEvents.size() > 0) {
                        this.appendToOutputChunk(streamEventCloner, complexEventChunks, this.lastCurrentEventTime, true);
                    }
                    this.lastScheduledTime = this.executionPlanContext.getTimestampGenerator().currentTime() + this.schedulerTimeout;
                    this.scheduler.notifyAt(this.lastScheduledTime);
                    continue;
                }
                if (currStreamEvent.getType() != ComplexEvent.Type.CURRENT) continue;
                long currentEventTime = (Long)this.timestampExpressionExecutor.execute((ComplexEvent)currStreamEvent);
                if (this.lastCurrentEventTime < currentEventTime) {
                    this.lastCurrentEventTime = currentEventTime;
                }
                if (currentEventTime < this.endTime) {
                    this.cloneAppend(streamEventCloner, (StreamEvent)currStreamEvent);
                    continue;
                }
                if (this.flushed) {
                    this.appendToOutputChunk(streamEventCloner, complexEventChunks, this.lastCurrentEventTime, false);
                    this.flushed = false;
                } else {
                    this.flushToOutputChunk(streamEventCloner, complexEventChunks, this.lastCurrentEventTime, false);
                }
                this.endTime = this.findEndTime(this.lastCurrentEventTime, this.startTime, this.timeToKeep);
                this.cloneAppend(streamEventCloner, (StreamEvent)currStreamEvent);
                if (this.schedulerTimeout <= 0L) continue;
                this.lastScheduledTime = this.executionPlanContext.getTimestampGenerator().currentTime() + this.schedulerTimeout;
                this.scheduler.notifyAt(this.lastScheduledTime);
            }
        }
        for (ComplexEventChunk complexEventChunk : complexEventChunks) {
            nextProcessor.process(complexEventChunk);
        }
    }

    private void initTiming(StreamEvent firstStreamEvent) {
        if (this.endTime < 0L) {
            if (this.isStartTimeEnabled) {
                this.endTime = this.findEndTime((Long)this.timestampExpressionExecutor.execute((ComplexEvent)firstStreamEvent), this.startTime, this.timeToKeep);
            } else {
                this.startTime = (Long)this.timestampExpressionExecutor.execute((ComplexEvent)firstStreamEvent);
                this.endTime = this.startTime + this.timeToKeep;
            }
            if (this.schedulerTimeout > 0L) {
                this.lastScheduledTime = this.executionPlanContext.getTimestampGenerator().currentTime() + this.schedulerTimeout;
                this.scheduler.notifyAt(this.lastScheduledTime);
            }
        }
    }

    private void flushToOutputChunk(StreamEventCloner streamEventCloner, List<ComplexEventChunk<StreamEvent>> complexEventChunks, long currentTime, boolean preserveCurrentEvents) {
        ComplexEventChunk newEventChunk = new ComplexEventChunk(true);
        if (this.outputExpectsExpiredEvents && this.expiredEvents.size() > 0) {
            for (StreamEvent streamEvent : this.expiredEvents.values()) {
                streamEvent.setTimestamp(currentTime);
                newEventChunk.add((ComplexEvent)streamEvent);
            }
        }
        if (this.expiredEvents != null) {
            this.expiredEvents.clear();
        }
        if (this.currentEvents.size() > 0) {
            this.resetEvent.setTimestamp(currentTime);
            newEventChunk.add((ComplexEvent)this.resetEvent);
            this.resetEvent = null;
            for (Map.Entry entry : this.currentEvents.entrySet()) {
                if (preserveCurrentEvents || this.storeExpiredEvents) {
                    StreamEvent toExpireEvent = streamEventCloner.copyStreamEvent((StreamEvent)entry.getValue());
                    toExpireEvent.setType(ComplexEvent.Type.EXPIRED);
                    this.expiredEvents.put(entry.getKey(), toExpireEvent);
                }
                newEventChunk.add((ComplexEvent)entry.getValue());
            }
        }
        this.currentEvents.clear();
        if (newEventChunk.getFirst() != null) {
            complexEventChunks.add((ComplexEventChunk<StreamEvent>)newEventChunk);
        }
    }

    private void appendToOutputChunk(StreamEventCloner streamEventCloner, List<ComplexEventChunk<StreamEvent>> complexEventChunks, long currentTime, boolean preserveCurrentEvents) {
        ComplexEventChunk newEventChunk = new ComplexEventChunk(true);
        LinkedHashMap<Object, StreamEvent> sentEvents = new LinkedHashMap<Object, StreamEvent>();
        if (this.currentEvents.size() > 0) {
            if (this.expiredEvents.size() > 0) {
                for (Map.Entry<Object, StreamEvent> expiredEventEntry : this.expiredEvents.entrySet()) {
                    if (this.outputExpectsExpiredEvents) {
                        StreamEvent toExpireEvent = streamEventCloner.copyStreamEvent(expiredEventEntry.getValue());
                        toExpireEvent.setTimestamp(currentTime);
                        newEventChunk.add((ComplexEvent)toExpireEvent);
                    }
                    StreamEvent toSendEvent = streamEventCloner.copyStreamEvent(expiredEventEntry.getValue());
                    toSendEvent.setType(ComplexEvent.Type.CURRENT);
                    sentEvents.put(expiredEventEntry.getKey(), toSendEvent);
                }
            }
            StreamEvent toResetEvent = streamEventCloner.copyStreamEvent(this.resetEvent);
            toResetEvent.setTimestamp(currentTime);
            newEventChunk.add((ComplexEvent)toResetEvent);
            for (Map.Entry<Object, StreamEvent> currentEventEntry : this.currentEvents.entrySet()) {
                if (preserveCurrentEvents || this.storeExpiredEvents) {
                    StreamEvent toExpireEvent = streamEventCloner.copyStreamEvent(currentEventEntry.getValue());
                    toExpireEvent.setType(ComplexEvent.Type.EXPIRED);
                    this.expiredEvents.put(currentEventEntry.getKey(), toExpireEvent);
                }
                sentEvents.put(currentEventEntry.getKey(), currentEventEntry.getValue());
            }
            for (StreamEvent sentEventEntry : sentEvents.values()) {
                newEventChunk.add((ComplexEvent)sentEventEntry);
            }
        }
        this.currentEvents.clear();
        if (newEventChunk.getFirst() != null) {
            complexEventChunks.add((ComplexEventChunk<StreamEvent>)newEventChunk);
        }
    }

    private long findEndTime(long currentTime, long startTime, long timeToKeep) {
        long elapsedTimeSinceLastEmit = (currentTime - startTime) % timeToKeep;
        return currentTime + (timeToKeep - elapsedTimeSinceLastEmit);
    }

    private void cloneAppend(StreamEventCloner streamEventCloner, StreamEvent currStreamEvent) {
        StreamEvent clonedStreamEvent = streamEventCloner.copyStreamEvent(currStreamEvent);
        if (this.replaceTimestampWithBatchEndTime) {
            clonedStreamEvent.setAttribute((Object)this.endTime, this.timestampExpressionExecutor.getPosition());
        }
        this.currentEvents.put(this.variableExpressionExecutor.execute((ComplexEvent)clonedStreamEvent), clonedStreamEvent);
        if (this.resetEvent == null) {
            this.resetEvent = streamEventCloner.copyStreamEvent(currStreamEvent);
            this.resetEvent.setType(ComplexEvent.Type.RESET);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> map) {
    }

    public void restoreState(Object[] state) {
        this.currentEvents = (Map)state[0];
        if (state[1] != null) {
            this.expiredEvents = (Map)state[1];
        } else {
            if (this.outputExpectsExpiredEvents) {
                this.expiredEvents = new LinkedHashMap<Object, StreamEvent>();
            }
            if (this.schedulerTimeout > 0L) {
                this.expiredEvents = new LinkedHashMap<Object, StreamEvent>();
            }
        }
        this.resetEvent = (StreamEvent)state[2];
        this.endTime = (Long)state[3];
        this.startTime = (Long)state[4];
        this.lastScheduledTime = (Long)state[5];
        this.lastCurrentEventTime = (Long)state[6];
        this.flushed = (Boolean)state[7];
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public StreamEvent find(StateEvent stateEvent, CompiledCondition compiledCondition) {
        return null;
    }

    public CompiledCondition compileCondition(Expression expression, MatchingMetaInfoHolder matchingMetaInfoHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> list, Map<String, Table> map, String s) {
        return null;
    }
}

