/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.config;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.config.CarbonConfigProvider;
import org.wso2.carbon.kernel.config.model.CarbonConfiguration;
import org.wso2.carbon.kernel.internal.utils.Utils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class YAMLBasedConfigProvider
implements CarbonConfigProvider {
    private static final Logger logger = LoggerFactory.getLogger(YAMLBasedConfigProvider.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CarbonConfiguration getCarbonConfiguration() {
        org.wso2.carbon.kernel.utils.Utils.checkSecurity();
        String configFileLocation = Utils.getCarbonYAMLLocation();
        try (FileInputStream inputStream = new FileInputStream(configFileLocation);){
            String yamlFileString;
            Scanner scanner = new Scanner((InputStream)inputStream, StandardCharsets.UTF_8.name());
            Object object = null;
            try {
                yamlFileString = scanner.useDelimiter("\\A").next();
                yamlFileString = org.wso2.carbon.kernel.utils.Utils.substituteVariables(yamlFileString);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (object != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            Yaml yaml = new Yaml();
            yaml.setBeanAccess(BeanAccess.FIELD);
            object = yaml.loadAs(yamlFileString, CarbonConfiguration.class);
            return object;
        }
        catch (IOException e) {
            String errorMessage = "Failed populate CarbonConfiguration from " + configFileLocation;
            logger.error(errorMessage, e);
            throw new RuntimeException(errorMessage);
        }
    }
}

