/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.deployment;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.deployment.Deployer;
import org.wso2.carbon.kernel.deployment.DeploymentService;
import org.wso2.carbon.kernel.deployment.exception.DeployerRegistrationException;
import org.wso2.carbon.kernel.deployment.exception.DeploymentEngineException;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.internal.deployment.CarbonDeploymentService;
import org.wso2.carbon.kernel.internal.deployment.DeploymentEngine;
import org.wso2.carbon.kernel.internal.deployment.OSGiServiceHolder;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;

@Component(name="org.wso2.carbon.kernel.internal.deployment.DeploymentEngineListenerComponent", immediate=true, property={"capability-name=org.wso2.carbon.kernel.deployment.Deployer", "component-key=carbon-deployment-service"})
public class DeploymentEngineListenerComponent
implements RequiredCapabilityListener {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentEngineListenerComponent.class);
    private DeploymentEngine deploymentEngine = new DeploymentEngine();
    private ServiceRegistration serviceRegistration;

    @Activate
    public void start(BundleContext bundleContext) throws Exception {
    }

    @Deactivate
    public void stop() throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    @Reference(name="carbon.deployer.service", service=Deployer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterDeployer")
    protected void registerDeployer(Deployer deployer) {
        try {
            this.deploymentEngine.registerDeployer(deployer);
        }
        catch (DeployerRegistrationException e) {
            logger.error("Error while adding deployer to the deployment engine", e);
        }
    }

    protected void unregisterDeployer(Deployer deployer) {
        try {
            this.deploymentEngine.unregisterDeployer(deployer);
        }
        catch (DeploymentEngineException e) {
            logger.error("Error while removing deployer from deployment engine", e);
        }
    }

    @Override
    public void onAllRequiredCapabilitiesAvailable() {
        try {
            String carbonRepositoryLocation = DataHolder.getInstance().getCarbonRuntime().getConfiguration().getDeploymentConfig().getRepositoryLocation();
            logger.debug("Starting Carbon Deployment Engine");
            this.deploymentEngine.start(carbonRepositoryLocation);
            OSGiServiceHolder.getInstance().setCarbonDeploymentEngine(this.deploymentEngine);
            CarbonDeploymentService deploymentService = new CarbonDeploymentService(this.deploymentEngine);
            BundleContext bundleContext = DataHolder.getInstance().getBundleContext();
            this.serviceRegistration = bundleContext.registerService(DeploymentService.class.getName(), (Object)deploymentService, null);
            logger.debug("Carbon Deployment Engine is successfully started");
        }
        catch (DeploymentEngineException e) {
            String msg = "Could not initialize carbon deployment engine";
            logger.error(msg, e);
        }
    }
}

