/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.utils.Utils;

public class LoggingConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(LoggingConfiguration.class);
    private static LoggingConfiguration instance = new LoggingConfiguration();

    private LoggingConfiguration() {
    }

    public static LoggingConfiguration getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ManagedService managedService) throws IllegalStateException, FileNotFoundException {
        if (managedService == null) {
            throw new IllegalStateException("Configuration admin service is not available.");
        }
        File configDir = Utils.getCarbonConfigHome().toFile();
        if (!configDir.exists()) {
            return;
        }
        File loggingConfigFile = new File(configDir, "log4j2.xml");
        if (loggingConfigFile.exists() && loggingConfigFile.isFile()) {
            Hashtable<String, String> prop = new Hashtable<String, String>();
            LoggingConfiguration loggingConfiguration = this;
            synchronized (loggingConfiguration) {
                prop.put("org.ops4j.pax.logging.log4j2.config.file", loggingConfigFile.getAbsolutePath());
                try {
                    managedService.updated(prop);
                }
                catch (ConfigurationException e) {
                    logger.error("Fail to read Log4J2 configurations from file [" + loggingConfigFile.getAbsolutePath() + "]", e);
                }
            }
        }
        throw new FileNotFoundException("Log4J2 configuration file is not found at : " + configDir.getAbsolutePath());
        logger.debug("Logging configuration registration completed using config file : {}", (Object)loggingConfigFile.getAbsolutePath());
    }

    public void unregister(ManagedService managedService) {
        try {
            managedService.updated(new Hashtable());
            if (logger.isDebugEnabled()) {
                logger.debug("Logging configuration updated to default");
            }
        }
        catch (ConfigurationException e) {
            logger.error("Error while trying to update Logging Configuration Service with default configuration", e);
        }
    }
}

