/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.config.model.CarbonConfiguration;
import org.wso2.carbon.kernel.internal.CarbonStartupHandler;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.internal.startupresolver.MultiCounter;
import org.wso2.carbon.kernel.startupresolver.CapabilityProvider;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.kernel.utils.manifest.ManifestElement;
import org.wso2.carbon.kernel.utils.manifest.ManifestElementParserException;

@Component(name="org.wso2.carbon.kernel.internal.startupresolver.RequireCapabilityCoordinator", immediate=true)
public class RequireCapabilityCoordinator {
    private static final Logger logger = LoggerFactory.getLogger(RequireCapabilityCoordinator.class);
    private static final String PROVIDE_CAPABILITY = "Provide-Capability";
    private static final String CAPABILITY_NAME = "capability-name";
    private static final String COMPONENT_KEY = "component-key";
    private static final String OSGI_SERVICE_HEADER_ELEMENT = "osgi.service";
    private static final String DEPENDENT_COMPONENT_KEY = "dependent-component-key";
    private static final String OBJECT_CLASS = "objectClass";
    private static final String CAPABILITY_NAME_SPLIT_CHAR = ",";
    private MultiCounter<String> capabilityListenerCounter = new MultiCounter();
    private MultiCounter<String> capabilityProviderCounter = new MultiCounter();
    private Map<String, List<String>> capabilityComponentKeyMap = new HashMap<String, List<String>>();
    private Map<String, RequiredCapabilityListener> componentKeyCapabilityListenerMap = new ConcurrentHashMap<String, RequiredCapabilityListener>();
    private MultiCounter<String> componentKeyCapabilityCounter = new MultiCounter();
    private ServiceTracker<Object, Object> capabilityServiceTracker;
    private Timer capabilityListenerTimer = new Timer();
    private Timer pendingCapabilityTimer = new Timer();

    @Activate
    public void start(BundleContext bundleContext) throws Exception {
        try {
            this.processManifestHeaders(Arrays.asList(bundleContext.getBundles()));
            if (this.capabilityListenerCounter.getKeysWithNonZeroCount().size() == 0) {
                this.capabilityComponentKeyMap = null;
                return;
            }
            this.openCapabilityServiceTracker();
            this.scheduleCapabilityListenerTimer();
            this.schedulePendingCapabilityTimerTask();
        }
        catch (Throwable e) {
            logger.error("Failed to initialize startup resolver. ", e);
        }
    }

    private void schedulePendingCapabilityTimerTask() {
        CarbonConfiguration carbonConfiguration = DataHolder.getInstance().getCarbonRuntime().getConfiguration();
        long pendingCapabilityTimerDelay = carbonConfiguration.getStartupResolverConfig().getPendingCapabilityTimer().getDelay();
        long pendingCapabilityTimerPeriod = carbonConfiguration.getStartupResolverConfig().getPendingCapabilityTimer().getPeriod();
        this.pendingCapabilityTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                List providerListWithNonZeroCount;
                if (RequireCapabilityCoordinator.this.capabilityListenerCounter.getKeysWithNonZeroCount().size() == 0 && RequireCapabilityCoordinator.this.componentKeyCapabilityListenerMap.size() == 0 && RequireCapabilityCoordinator.this.capabilityProviderCounter.getKeysWithNonZeroCount().size() == 0) {
                    logger.debug("All the RequiredCapabilityListeners are notified, therefore cancelling the pendingCapabilityTimer");
                    RequireCapabilityCoordinator.this.pendingCapabilityTimer.cancel();
                    return;
                }
                List listerListWithNonZeroCount = RequireCapabilityCoordinator.this.capabilityListenerCounter.getKeysWithNonZeroCount();
                if (listerListWithNonZeroCount.size() != 0) {
                    listerListWithNonZeroCount.stream().forEach(componentKey -> logger.warn("Waiting on pending RequiredCapabilityListener registration for component-key: {}", componentKey));
                }
                if ((providerListWithNonZeroCount = RequireCapabilityCoordinator.this.capabilityProviderCounter.getKeysWithNonZeroCount()).size() != 0) {
                    providerListWithNonZeroCount.stream().forEach(capability -> logger.warn("Waiting on pending CapabilityProvider registration for capability: {}", capability));
                }
                RequireCapabilityCoordinator.this.componentKeyCapabilityListenerMap.keySet().stream().filter(componentKey -> RequireCapabilityCoordinator.this.getPendingCapabilityProviderCount(componentKey) == 0 && RequireCapabilityCoordinator.this.componentKeyCapabilityCounter.get(componentKey) != 0).map(componentKey -> RequireCapabilityCoordinator.this.capabilityComponentKeyMap.keySet().stream().filter(capability -> ((List)RequireCapabilityCoordinator.this.capabilityComponentKeyMap.get(capability)).contains(componentKey)).collect(Collectors.toList())).forEach(capabilityList -> capabilityList.forEach(capability -> logger.warn("Waiting on pending capability registration. Capability: {}", capability)));
            }
        }, pendingCapabilityTimerDelay, pendingCapabilityTimerPeriod);
    }

    private void scheduleCapabilityListenerTimer() {
        CarbonConfiguration carbonConfiguration = DataHolder.getInstance().getCarbonRuntime().getConfiguration();
        long capabilityListenerTimerDelay = carbonConfiguration.getStartupResolverConfig().getCapabilityListenerTimer().getDelay();
        long capabilityListenerTimerPeriod = carbonConfiguration.getStartupResolverConfig().getCapabilityListenerTimer().getPeriod();
        this.capabilityListenerTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (RequireCapabilityCoordinator.this.capabilityListenerCounter.getKeysWithNonZeroCount().size() == 0 && RequireCapabilityCoordinator.this.componentKeyCapabilityListenerMap.size() == 0 && RequireCapabilityCoordinator.this.capabilityProviderCounter.getKeysWithNonZeroCount().size() == 0) {
                    logger.debug("All the RequiredCapabilityListeners are notified, therefore cancelling the capabilityListenerTimer");
                    CarbonStartupHandler.logServerStartupTime();
                    CarbonStartupHandler.registerCarbonServerInfoService();
                    RequireCapabilityCoordinator.this.capabilityListenerTimer.cancel();
                    RequireCapabilityCoordinator.this.capabilityServiceTracker.close();
                    return;
                }
                RequireCapabilityCoordinator.this.componentKeyCapabilityListenerMap.keySet().stream().forEach(componentKey -> {
                    String string = componentKey.intern();
                    synchronized (string) {
                        if (RequireCapabilityCoordinator.this.getPendingCapabilityProviderCount(componentKey) == 0 && RequireCapabilityCoordinator.this.componentKeyCapabilityCounter.get(componentKey) == 0) {
                            RequiredCapabilityListener capabilityListener = (RequiredCapabilityListener)RequireCapabilityCoordinator.this.componentKeyCapabilityListenerMap.remove(componentKey);
                            logger.debug("Notifying RequiredCapabilityListener: {} since all the required capabilities are available", (Object)capabilityListener.getClass().getName());
                            capabilityListener.onAllRequiredCapabilitiesAvailable();
                        }
                    }
                });
            }
        }, capabilityListenerTimerDelay, capabilityListenerTimerPeriod);
    }

    private int getPendingCapabilityProviderCount(String componentKey) {
        int i = this.capabilityComponentKeyMap.keySet().stream().filter(capabilityName -> this.capabilityComponentKeyMap.get(capabilityName).contains(componentKey)).mapToInt(this.capabilityProviderCounter::get).sum();
        logger.debug("Capability provider count for ComponentKey : {} is : {}", (Object)componentKey, (Object)i);
        return i;
    }

    @Deactivate
    public void stop(BundleContext bundleContext) throws Exception {
        logger.debug("Deactivating startup resolver component available in bundle {}", (Object)bundleContext.getBundle().getSymbolicName());
    }

    private void processManifestHeaders(List<Bundle> bundleList) {
        List<ManifestElement> manifestElementList = this.getOSGiServiceProvideCapabilityHeaders(bundleList);
        manifestElementList.stream().forEach(manifestElement -> {
            String objectClassName = manifestElement.getAttribute(OBJECT_CLASS);
            if (RequiredCapabilityListener.class.getName().equals(objectClassName)) {
                String capabilityNames = this.getManifestElementAttribute(CAPABILITY_NAME, (ManifestElement)manifestElement, true);
                String componentKey = this.getManifestElementAttribute(COMPONENT_KEY, (ManifestElement)manifestElement, true);
                assert (capabilityNames != null);
                String[] capabilityNameArray = capabilityNames.split(CAPABILITY_NAME_SPLIT_CHAR);
                Arrays.asList(capabilityNameArray).forEach(capabilityName -> this.addCapabilityComponetKeyMapping((String)capabilityName, componentKey));
                logger.debug("Adding RequiredCapabilityListener with the ComponentKey - {} and CapabilityNames - {} from ManifestHeader entry", (Object)componentKey, (Object)capabilityNames);
                this.capabilityListenerCounter.incrementAndGet(componentKey);
            } else if (CapabilityProvider.class.getName().equals(objectClassName)) {
                String capabilityName2 = this.getManifestElementAttribute(CAPABILITY_NAME, (ManifestElement)manifestElement, true);
                String dependentComponentKey = this.getManifestElementAttribute(DEPENDENT_COMPONENT_KEY, (ManifestElement)manifestElement, false);
                if (dependentComponentKey != null) {
                    this.addCapabilityComponetKeyMapping(capabilityName2, dependentComponentKey);
                }
                logger.debug("Adding CapabilityProvider with the CapabilityName {} from ManifestHeader entry", (Object)capabilityName2);
                this.capabilityProviderCounter.incrementAndGet(capabilityName2);
            } else if (manifestElement.getAttribute(DEPENDENT_COMPONENT_KEY) != null) {
                String dependentComponentKey = this.getManifestElementAttribute(DEPENDENT_COMPONENT_KEY, (ManifestElement)manifestElement, false);
                logger.debug("Adding Capability from ManifestHeader entry - {}", (Object)objectClassName);
                this.addCapabilityComponetKeyMapping(objectClassName, dependentComponentKey);
            }
        });
        manifestElementList.stream().filter(manifestElement -> {
            String objectClass = manifestElement.getAttribute(OBJECT_CLASS);
            return !RequiredCapabilityListener.class.getName().equals(objectClass) && !CapabilityProvider.class.getName().equals(objectClass);
        }).forEach(manifestElement -> {
            String objectClass = manifestElement.getAttribute(OBJECT_CLASS);
            if (this.capabilityComponentKeyMap.containsKey(objectClass)) {
                this.capabilityComponentKeyMap.get(objectClass).forEach(this.componentKeyCapabilityCounter::incrementAndGet);
            }
        });
    }

    private List<ManifestElement> getOSGiServiceProvideCapabilityHeaders(List<Bundle> bundleList) {
        return bundleList.parallelStream().filter(bundle -> AccessController.doPrivileged(() -> bundle.getHeaders(PROVIDE_CAPABILITY).get(PROVIDE_CAPABILITY) != null)).map(bundle -> {
            String headerValue = AccessController.doPrivileged(() -> (String)bundle.getHeaders(PROVIDE_CAPABILITY).get(PROVIDE_CAPABILITY));
            try {
                return ManifestElement.parseHeader(PROVIDE_CAPABILITY, headerValue);
            }
            catch (ManifestElementParserException e) {
                String message = "Error occurred while parsing the Provide-Capability header in bundle " + bundle.getSymbolicName();
                throw new RuntimeException(message);
            }
        }).flatMap(manifestElementArray -> Arrays.asList(manifestElementArray).stream()).filter(manifestElement -> OSGI_SERVICE_HEADER_ELEMENT.equals(manifestElement.getValue())).collect(Collectors.toList());
    }

    private String getManifestElementAttribute(String attributeKey, ManifestElement manifestElement, boolean mandatory) {
        String value = manifestElement.getAttribute(attributeKey);
        if ((value == null || value.equals("")) && mandatory) {
            throw new RuntimeException(attributeKey + " value is missing in Provide-Capability header");
        }
        return value != null ? value.trim() : null;
    }

    private void addCapabilityComponetKeyMapping(String capability, String componentKey) {
        List<String> componentKeyList = this.capabilityComponentKeyMap.get(capability);
        if (componentKeyList == null) {
            componentKeyList = new ArrayList<String>();
            this.capabilityComponentKeyMap.put(capability, componentKeyList);
        }
        componentKeyList.add(componentKey);
    }

    private void openCapabilityServiceTracker() {
        BundleContext bundleContext = DataHolder.getInstance().getBundleContext();
        Filter orFilter = this.getORFilter(new ArrayList<String>(this.capabilityComponentKeyMap.keySet()));
        this.capabilityServiceTracker = new ServiceTracker(bundleContext, orFilter, (ServiceTrackerCustomizer)new CapabilityServiceTrackerCustomizer());
        this.capabilityServiceTracker.open();
    }

    private Filter getORFilter(List<String> capabilityNameList) {
        StringBuilder orFilterBuilder = new StringBuilder();
        orFilterBuilder.append("(|");
        for (String service : capabilityNameList) {
            orFilterBuilder.append("(").append(OBJECT_CLASS).append("=").append(service).append(")");
        }
        orFilterBuilder.append("(").append(OBJECT_CLASS).append("=").append(RequiredCapabilityListener.class.getName()).append(")");
        orFilterBuilder.append("(").append(OBJECT_CLASS).append("=").append(CapabilityProvider.class.getName()).append(")");
        orFilterBuilder.append(")");
        BundleContext bundleContext = DataHolder.getInstance().getBundleContext();
        try {
            return bundleContext.createFilter(orFilterBuilder.toString());
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private class CapabilityServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private CapabilityServiceTrackerCustomizer() {
        }

        public Object addingService(ServiceReference<Object> reference) {
            Object serviceObject = DataHolder.getInstance().getBundleContext().getService(reference);
            String serviceInterfaceClassName = ((String[])reference.getProperty(RequireCapabilityCoordinator.OBJECT_CLASS))[0];
            String serviceImplClassName = serviceObject.getClass().getName();
            if (RequiredCapabilityListener.class.getName().equals(serviceInterfaceClassName)) {
                String capabilityName = (String)reference.getProperty(RequireCapabilityCoordinator.CAPABILITY_NAME);
                if (capabilityName == null || capabilityName.equals("")) {
                    throw new RuntimeException("capability-name value is missing in the services registered with the key " + serviceInterfaceClassName + ", implementation class name is " + serviceImplClassName);
                }
                String componentKey = (String)reference.getProperty(RequireCapabilityCoordinator.COMPONENT_KEY);
                if (componentKey == null || componentKey.equals("")) {
                    throw new RuntimeException("component-key value is missing in the services registered with the key " + serviceInterfaceClassName + ", implementation class name is " + serviceImplClassName);
                }
                logger.debug("Adding {}. Service implementation class name: {}. capability-name: {}. component-key: {}", RequiredCapabilityListener.class.getName(), serviceImplClassName, capabilityName, componentKey);
                RequireCapabilityCoordinator.this.capabilityListenerCounter.decrementAndGet(componentKey);
                RequireCapabilityCoordinator.this.componentKeyCapabilityListenerMap.put(componentKey, (RequiredCapabilityListener)serviceObject);
            } else if (CapabilityProvider.class.getName().equals(serviceInterfaceClassName)) {
                CapabilityProvider provider = (CapabilityProvider)serviceObject;
                String capabilityName = (String)reference.getProperty(RequireCapabilityCoordinator.CAPABILITY_NAME);
                if (capabilityName == null || capabilityName.equals("")) {
                    throw new RuntimeException("capability-name value is missing in the services registered with the key " + serviceInterfaceClassName + ", implementation class name is " + serviceImplClassName);
                }
                logger.debug("Adding {}. Service implementation class name: {}. capability-name: {}", CapabilityProvider.class.getName(), serviceImplClassName, capabilityName);
                IntStream.range(0, provider.getCount()).forEach(count -> ((List)RequireCapabilityCoordinator.this.capabilityComponentKeyMap.get(capabilityName)).forEach(RequireCapabilityCoordinator.this.componentKeyCapabilityCounter::incrementAndGet));
                RequireCapabilityCoordinator.this.capabilityProviderCounter.decrementAndGet(capabilityName);
            } else {
                logger.debug("Adding Capability. Service id: {}. Service implementation class: {}. dependent-component-key: {}", serviceInterfaceClassName, serviceImplClassName, reference.getProperty(RequireCapabilityCoordinator.DEPENDENT_COMPONENT_KEY));
                ((List)RequireCapabilityCoordinator.this.capabilityComponentKeyMap.get(serviceInterfaceClassName)).forEach(RequireCapabilityCoordinator.this.componentKeyCapabilityCounter::decrementAndGet);
            }
            return serviceObject;
        }

        public void modifiedService(ServiceReference<Object> reference, Object service) {
        }

        public void removedService(ServiceReference<Object> reference, Object service) {
        }
    }
}

