/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.transports;

public abstract class CarbonTransport {
    protected String id;
    protected State state = State.UNINITIALIZED;

    public CarbonTransport(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    void startTransport() {
        if (!(this.state.equals((Object)State.UNINITIALIZED) || this.state.equals((Object)State.IN_MAINTENANCE) || this.state.equals((Object)State.STOPPED))) {
            throw new IllegalStateException("Cannot start transport " + this.id + ". Current state: " + (Object)((Object)this.state));
        }
        this.start();
        this.state = State.STARTED;
    }

    protected abstract void start();

    void stopTransport() {
        if (!this.state.equals((Object)State.STARTED)) {
            throw new IllegalStateException("Cannot stop transport " + this.id + ". Current state: " + (Object)((Object)this.state));
        }
        this.stop();
        this.state = State.STOPPED;
    }

    protected abstract void stop();

    void beginTransportMaintenance() {
        if (!this.state.equals((Object)State.STARTED)) {
            throw new IllegalStateException("Cannot put transport " + this.id + " into maintenance. Current state: " + (Object)((Object)this.state));
        }
        this.beginMaintenance();
        this.state = State.IN_MAINTENANCE;
    }

    protected abstract void beginMaintenance();

    void endTransportMaintenance() {
        if (!this.state.equals((Object)State.IN_MAINTENANCE)) {
            throw new IllegalStateException("Cannot end maintenance of transport " + this.id + ". Current state: " + (Object)((Object)this.state));
        }
        this.endMaintenance();
        this.state = State.STARTED;
    }

    protected abstract void endMaintenance();

    public static enum State {
        UNINITIALIZED,
        STARTED,
        STOPPED,
        IN_MAINTENANCE;


        public String toString() {
            return this.name();
        }
    }
}

