/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.utils;

import java.lang.management.ManagementPermission;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static final String VAR_REGEXP = "\\$\\{[^}]*}";
    private static final Pattern varPattern = Pattern.compile("\\$\\{[^}]*}");

    private Utils() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    public static Path getCarbonConfigHome() {
        return Paths.get(Utils.getCarbonHome().toString(), "conf");
    }

    public static Path getCarbonHome() {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null) {
            carbonHome = System.getenv("CARBON_HOME");
            System.setProperty("carbon.home", carbonHome);
        }
        return Paths.get(carbonHome, new String[0]);
    }

    public static String substituteVariables(String value) {
        String newValue = value;
        Matcher matcher = varPattern.matcher(value);
        while (matcher.find()) {
            String sysPropKey = value.substring(matcher.start() + 2, matcher.end() - 1);
            String sysPropValue = Utils.getSystemVariableValue(sysPropKey, null);
            if (sysPropValue == null || sysPropValue.length() == 0) {
                throw new RuntimeException("System property " + sysPropKey + " is not specified");
            }
            sysPropValue = sysPropValue.replace("\\", "\\\\");
            newValue = newValue.replaceFirst(VAR_REGEXP, sysPropValue);
        }
        return newValue;
    }

    public static String getSystemVariableValue(String variableName, String defaultValue) {
        String value = System.getProperty(variableName) != null ? System.getProperty(variableName) : (System.getenv(variableName) != null ? System.getenv(variableName) : defaultValue);
        return value;
    }

    public static void checkSecurity() {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
    }
}

