/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.utils.manifest;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.utils.Tokenizer;
import org.wso2.carbon.kernel.utils.manifest.ManifestElementParserException;

public class ManifestElement {
    private static final Logger logger = LoggerFactory.getLogger(ManifestElement.class);
    private static final String MANIFEST_INVALID_HEADER_EXCEPTION = "Invalid header found.";
    private final String mainValue;
    private Hashtable<String, Object> attributes;
    private Hashtable<String, Object> directives;

    private ManifestElement(String value) {
        this.mainValue = value;
    }

    public String getValue() {
        return this.mainValue;
    }

    public String getAttribute(String key) {
        return this.getTableValue(this.attributes, key);
    }

    public String[] getAttributes(String key) {
        return this.getTableValues(this.attributes, key);
    }

    public Enumeration<String> getKeys() {
        return this.getTableKeys(this.attributes);
    }

    private void addAttribute(String key, String value) {
        this.attributes = this.addTableValue(this.attributes, key, value);
    }

    public String[] getDirectives(String key) {
        return this.getTableValues(this.directives, key);
    }

    public Enumeration<String> getDirectiveKeys() {
        return this.getTableKeys(this.directives);
    }

    private void addDirective(String key, String value) {
        this.directives = this.addTableValue(this.directives, key, value);
    }

    private String getTableValue(Hashtable<String, Object> table, String key) {
        if (table == null) {
            return null;
        }
        Object result = table.get(key);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        List valueList = (List)result;
        return (String)valueList.get(valueList.size() - 1);
    }

    private String[] getTableValues(Hashtable<String, Object> table, String key) {
        if (table == null) {
            return new String[0];
        }
        Object result = table.get(key);
        if (result == null) {
            return new String[0];
        }
        if (result instanceof String) {
            return new String[]{(String)result};
        }
        List valueList = (List)result;
        return valueList.toArray(new String[valueList.size()]);
    }

    private Enumeration<String> getTableKeys(Hashtable<String, Object> table) {
        if (table == null) {
            return null;
        }
        return table.keys();
    }

    private Hashtable<String, Object> addTableValue(Hashtable<String, Object> table, String key, String value) {
        Object curValue;
        if (table == null) {
            table = new Hashtable(7);
        }
        if ((curValue = table.get(key)) != null) {
            ArrayList<String> newList;
            if (curValue instanceof List) {
                newList = (ArrayList<String>)curValue;
            } else {
                newList = new ArrayList<String>(5);
                newList.add((String)curValue);
            }
            newList.add(value);
            table.put(key, newList);
        } else {
            table.put(key, value);
        }
        return table;
    }

    public static ManifestElement[] parseHeader(String header, String value) throws ManifestElementParserException {
        char c;
        if (value == null) {
            return new ManifestElement[0];
        }
        ArrayList<ManifestElement> headerElements = new ArrayList<ManifestElement>(10);
        Tokenizer tokenizer = new Tokenizer(value);
        do {
            String next;
            if ((next = tokenizer.getString(";,")) == null) {
                throw new ManifestElementParserException("Invalid header found. Header: " + header + "Value: " + value);
            }
            StringBuilder headerValue = new StringBuilder(next);
            logger.debug("parseHeader: " + next);
            boolean directive = false;
            c = tokenizer.getChar();
            while (c == ';') {
                next = tokenizer.getString(";,=:");
                if (next == null) {
                    throw new ManifestElementParserException("Invalid header found. Header: " + header + "Value: " + value);
                }
                c = tokenizer.getChar();
                while (c == ':') {
                    c = tokenizer.getChar();
                    if (c != '=') {
                        String restOfNext = tokenizer.getToken(";,=:");
                        if (restOfNext == null) {
                            throw new ManifestElementParserException("Invalid header found. Header: " + header + "Value: " + value);
                        }
                        next = next.concat(":" + c + restOfNext);
                        c = tokenizer.getChar();
                        continue;
                    }
                    directive = true;
                }
                if (c != ';' && c != ',' && c != '\u0000') continue;
                headerValue.append(";").append(next);
                logger.debug(";" + next);
            }
            ManifestElement manifestElement = new ManifestElement(headerValue.toString());
            while (c == '=' || c == ':') {
                String val;
                Tokenizer listTokenizer;
                String attrKey;
                while (c == ':') {
                    c = tokenizer.getChar();
                    if (c != '=') {
                        String restOfNext = tokenizer.getToken("=:");
                        if (restOfNext == null) {
                            throw new ManifestElementParserException("Invalid header found. Header: " + header + "Value: " + value);
                        }
                        next = next.concat(":" + c + restOfNext);
                        c = tokenizer.getChar();
                        continue;
                    }
                    directive = true;
                }
                String preserveEscapes = null;
                String tempNextWithoutFirstLetter = next.substring(1);
                if (!directive && tempNextWithoutFirstLetter.contains("List") && (attrKey = (listTokenizer = new Tokenizer(next)).getToken(":")) != null && listTokenizer.getChar() == ':' && "List".equals(listTokenizer.getToken("<"))) {
                    preserveEscapes = "\\,";
                }
                if ((val = tokenizer.getString(";,", preserveEscapes)) == null) {
                    throw new ManifestElementParserException("Invalid header found. Header: " + header + "Value: " + value);
                }
                logger.debug(";" + next + "=" + val);
                try {
                    if (directive) {
                        manifestElement.addDirective(next, val);
                    } else {
                        manifestElement.addAttribute(next, val);
                    }
                    directive = false;
                }
                catch (Exception e) {
                    throw new ManifestElementParserException("Invalid header found. Header: " + header + "Value: " + value);
                }
                c = tokenizer.getChar();
                if (c != ';') continue;
                next = tokenizer.getToken("=:");
                if (next == null) {
                    throw new ManifestElementParserException("Invalid header found. Header: " + header + "Value: " + value);
                }
                c = tokenizer.getChar();
            }
            headerElements.add(manifestElement);
        } while (c == ',');
        if (c != '\u0000') {
            throw new ManifestElementParserException("Invalid header found. Header: " + header + "Value: " + value);
        }
        int size = headerElements.size();
        if (size == 0) {
            return new ManifestElement[0];
        }
        return headerElements.toArray(new ManifestElement[size]);
    }

    public String toString() {
        String key;
        Enumeration<String> attrKeys = this.getKeys();
        Enumeration<String> directiveKeys = this.getDirectiveKeys();
        if (attrKeys == null && directiveKeys == null) {
            return this.mainValue;
        }
        StringBuffer result = new StringBuffer(this.mainValue);
        if (attrKeys != null) {
            while (attrKeys.hasMoreElements()) {
                key = attrKeys.nextElement();
                this.addValues(false, key, this.getAttributes(key), result);
            }
        }
        if (directiveKeys != null) {
            while (directiveKeys.hasMoreElements()) {
                key = directiveKeys.nextElement();
                this.addValues(true, key, this.getDirectives(key), result);
            }
        }
        return result.toString();
    }

    private void addValues(boolean directive, String key, String[] values, StringBuffer result) {
        if (values == null) {
            return;
        }
        for (String value : values) {
            result.append(';').append(key);
            if (directive) {
                result.append(':');
            }
            result.append("=\"").append(value).append('\"');
        }
    }
}

