/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.kernel.transports.CarbonTransport;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.MicroservicesRegistry;

@Component(name="org.wso2.msf4j.internal.MicroServicesServerSC", immediate=true, service={RequiredCapabilityListener.class}, property={"capability-name=org.wso2.msf4j.Microservice, org.wso2.msf4j.Interceptor", "component-key=wso2-microservices-server"})
public class MicroservicesServerSC
implements RequiredCapabilityListener {
    public static final String CHANNEL_ID_KEY = "channel.id";
    private static final Logger log = LoggerFactory.getLogger(MicroservicesServerSC.class);
    private final MicroservicesRegistry microservicesRegistry = MicroservicesRegistry.getInstance();

    @Activate
    protected void start(BundleContext bundleContext) {
    }

    @Reference(name="microservice", service=Microservice.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeHttpService")
    protected void addHttpService(Microservice httpService) {
        this.microservicesRegistry.addHttpService(httpService);
    }

    protected void removeHttpService(Microservice httpService) {
        this.microservicesRegistry.removeHttpService(httpService);
    }

    @Reference(name="carbon-transport", service=CarbonTransport.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="removeCarbonTransport")
    protected void addCarbonTransport(CarbonTransport carbonTransport) {
        DataHolder.getInstance().addCarbonTransport(carbonTransport);
    }

    protected void removeCarbonTransport(CarbonTransport carbonTransport) {
        DataHolder.getInstance().removeCarbonTransport(carbonTransport);
    }

    @Reference(name="interceptor", service=Interceptor.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeInterceptor")
    protected void addInterceptor(Interceptor interceptor) {
        this.microservicesRegistry.addInterceptor(interceptor);
    }

    protected void removeInterceptor(Interceptor interceptor) {
        this.microservicesRegistry.removeInterceptor(interceptor);
    }

    @Override
    public void onAllRequiredCapabilitiesAvailable() {
        DataHolder.getInstance().getBundleContext().registerService(MicroservicesServerSC.class, (Object)this, null);
        log.info("All microservices are available");
    }
}

