/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.wso2.msf4j.ChunkResponder;
import org.wso2.msf4j.internal.router.AbstractHttpResponder;
import org.wso2.msf4j.internal.router.ChannelChunkResponder;

public class BasicHttpResponder
extends AbstractHttpResponder {
    private final Channel channel;
    private final boolean keepAlive;
    private final AtomicBoolean responded;

    public BasicHttpResponder(Channel channel, boolean keepAlive) {
        this.channel = channel;
        this.keepAlive = keepAlive;
        this.responded = new AtomicBoolean(false);
    }

    @Override
    public ChunkResponder sendChunkStart(HttpResponseStatus status, @Nullable Multimap<String, String> headers) {
        Preconditions.checkArgument(this.responded.compareAndSet(false, true), "Response has been already sent");
        Preconditions.checkArgument(status.code() >= 200 && status.code() < 210, "Http Chunk Failure");
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        this.setCustomHeaders(response, headers);
        response.headers().set("Transfer-Encoding", (Object)"chunked");
        boolean responseKeepAlive = this.setResponseKeepAlive(response);
        this.channel.write(response);
        return new ChannelChunkResponder(this.channel, responseKeepAlive);
    }

    @Override
    public void sendContent(HttpResponseStatus status, @Nullable ByteBuf content, String contentType, @Nullable Multimap<String, String> headers) {
        HttpHeaders responseHeaders;
        DefaultHttpResponse response;
        Preconditions.checkArgument(this.responded.compareAndSet(false, true), "Response has been already sent");
        if (content != null) {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
            responseHeaders = response.headers();
            responseHeaders.set("Content-Type", (Object)contentType);
            responseHeaders.set("Content-Length", (Object)content.readableBytes());
        } else {
            response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
            responseHeaders = response.headers();
            responseHeaders.set("Content-Length", (Object)0);
        }
        this.setCustomHeaders(response, headers);
        boolean responseKeepAlive = this.setResponseKeepAlive(response);
        ChannelFuture future = this.channel.write(response);
        if (!responseKeepAlive) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void sendFile(File file, String contentType, @Nullable Multimap<String, String> headers) throws IOException {
        Preconditions.checkArgument(this.responded.compareAndSet(false, true), "Response has been already sent");
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.setCustomHeaders(response, headers);
        response.headers().set("Content-Type", (Object)contentType);
        if (!response.headers().contains("Content-Length")) {
            response.headers().set("Transfer-Encoding", (Object)"chunked");
        }
        this.channel.writeAndFlush(response);
        HttpChunkedInput httpChunkWriter = new HttpChunkedInput(new ChunkedFile(file));
        ChannelFuture sendFileFuture = this.channel.write(httpChunkWriter);
        boolean responseKeepAlive = this.setResponseKeepAlive(response);
        sendFileFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (!responseKeepAlive) {
                this.channel.close();
            }
        }));
    }

    private void setCustomHeaders(HttpResponse response, @Nullable Multimap<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, Collection<String>> entry : headers.asMap().entrySet()) {
                response.headers().add(entry.getKey(), (Iterable)entry.getValue());
            }
        }
    }

    private boolean setResponseKeepAlive(HttpResponse response) {
        boolean responseKeepAlive;
        HttpHeaders headers = response.headers();
        boolean closeConn = "close".equalsIgnoreCase(headers.get("Connection"));
        boolean bl = responseKeepAlive = this.keepAlive && !closeConn;
        if (responseKeepAlive) {
            headers.set("Connection", (Object)"keep-alive");
        } else {
            headers.set("Connection", (Object)"close");
        }
        return responseKeepAlive;
    }
}

