/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.netty.handler.codec.http.HttpMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.wso2.msf4j.HttpStreamer;
import org.wso2.msf4j.internal.router.ExceptionHandler;
import org.wso2.msf4j.internal.router.ParamConvertUtils;

public final class HttpResourceModel {
    private static final Set<Class<? extends Annotation>> SUPPORTED_PARAM_ANNOTATIONS = ImmutableSet.of(PathParam.class, QueryParam.class, HeaderParam.class, Context.class);
    private static final String[] ANY_MEDIA_TYPE = new String[]{"*/*"};
    private static final int STREAMING_REQ_UNKNOWN = 0;
    private static final int STREAMING_REQ_SUPPORTED = 1;
    private static final int STREAMING_REQ_UNSUPPORTED = 2;
    private final Set<HttpMethod> httpMethods;
    private final String path;
    private final Method method;
    private final Object handler;
    private final List<ParameterInfo<?>> paramInfoList;
    private final ExceptionHandler exceptionHandler;
    private List<String> consumesMediaTypes;
    private List<String> producesMediaTypes;
    private int isStreamingReqSupported = 0;

    public HttpResourceModel(String path, Method method, Object handler, ExceptionHandler exceptionHandler) {
        this.httpMethods = this.getHttpMethods(method);
        this.path = path;
        this.method = method;
        this.handler = handler;
        this.paramInfoList = this.makeParamInfoList(method);
        this.exceptionHandler = exceptionHandler;
        this.consumesMediaTypes = this.parseConsumesMediaTypes();
        this.producesMediaTypes = this.parseProducesMediaTypes();
    }

    private List<String> parseConsumesMediaTypes() {
        String[] consumesMediaTypeArr = this.method.isAnnotationPresent(Consumes.class) ? this.method.getAnnotation(Consumes.class).value() : (this.handler.getClass().isAnnotationPresent(Consumes.class) ? this.handler.getClass().getAnnotation(Consumes.class).value() : ANY_MEDIA_TYPE);
        return Arrays.asList(consumesMediaTypeArr);
    }

    private List<String> parseProducesMediaTypes() {
        String[] producesMediaTypeArr = this.method.isAnnotationPresent(Produces.class) ? this.method.getAnnotation(Produces.class).value() : (this.handler.getClass().isAnnotationPresent(Produces.class) ? this.handler.getClass().getAnnotation(Produces.class).value() : ANY_MEDIA_TYPE);
        return Arrays.asList(producesMediaTypeArr);
    }

    public boolean matchConsumeMediaType(String consumesMediaType) {
        return consumesMediaType == null || consumesMediaType.isEmpty() || consumesMediaType.equals("*/*") || this.consumesMediaTypes.contains("*/*") || this.consumesMediaTypes.contains(consumesMediaType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matchProduceMediaType(List<String> producesMediaTypes) {
        if (producesMediaTypes == null) return true;
        if (producesMediaTypes.contains("*/*")) return true;
        if (this.producesMediaTypes.contains("*/*")) return true;
        if (!this.producesMediaTypes.stream().filter(producesMediaTypes::contains).findAny().isPresent()) return false;
        return true;
    }

    public Set<HttpMethod> getHttpMethod() {
        return this.httpMethods;
    }

    public String getPath() {
        return this.path;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getHttpHandler() {
        return this.handler;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("httpMethods", this.httpMethods).add("path", this.path).add("method", this.method).add("handler", this.handler).toString();
    }

    private Set<HttpMethod> getHttpMethods(Method method) {
        HashSet<HttpMethod> httpMethods = Sets.newHashSet();
        if (method.isAnnotationPresent(GET.class)) {
            httpMethods.add(HttpMethod.GET);
        }
        if (method.isAnnotationPresent(PUT.class)) {
            httpMethods.add(HttpMethod.PUT);
        }
        if (method.isAnnotationPresent(POST.class)) {
            httpMethods.add(HttpMethod.POST);
        }
        if (method.isAnnotationPresent(DELETE.class)) {
            httpMethods.add(HttpMethod.DELETE);
        }
        return ImmutableSet.copyOf(httpMethods);
    }

    private List<ParameterInfo<?>> makeParamInfoList(Method method) {
        ArrayList paramInfoList = new ArrayList();
        Type[] paramTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < paramAnnotations.length; ++i) {
            Annotation[] annotations = paramAnnotations[i];
            if (Sets.intersection(SUPPORTED_PARAM_ANNOTATIONS, ImmutableSet.of(annotations)).size() > 1) {
                throw new IllegalArgumentException(String.format("Must have exactly one annotation from %s for parameter %d in method %s", SUPPORTED_PARAM_ANNOTATIONS, i, method));
            }
            Annotation annotation = null;
            Type parameterType = paramTypes[i];
            Function<Object, Object> converter = null;
            String defaultVal = null;
            for (Annotation annotation0 : annotations) {
                annotation = annotation0;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (PathParam.class.isAssignableFrom(annotationType)) {
                    converter = ParamConvertUtils.createPathParamConverter(parameterType);
                    continue;
                }
                if (QueryParam.class.isAssignableFrom(annotationType)) {
                    converter = ParamConvertUtils.createQueryParamConverter(parameterType);
                    continue;
                }
                if (HeaderParam.class.isAssignableFrom(annotationType)) {
                    converter = ParamConvertUtils.createHeaderParamConverter(parameterType);
                    continue;
                }
                if (!DefaultValue.class.isAssignableFrom(annotationType)) continue;
                defaultVal = ((DefaultValue)annotation).value();
            }
            ParameterInfo parameterInfo = ParameterInfo.create(parameterType, annotation, defaultVal, converter);
            paramInfoList.add(parameterInfo);
        }
        return Collections.unmodifiableList(paramInfoList);
    }

    public boolean isStreamingReqSupported() {
        if (this.isStreamingReqSupported == 1) {
            return true;
        }
        if (this.isStreamingReqSupported == 2) {
            return false;
        }
        if (this.paramInfoList.stream().filter(parameterInfo -> parameterInfo.getParameterType().equals(HttpStreamer.class)).findAny().isPresent()) {
            this.isStreamingReqSupported = 1;
            return true;
        }
        this.isStreamingReqSupported = 2;
        return false;
    }

    public List<ParameterInfo<?>> getParamInfoList() {
        return this.paramInfoList;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public List<String> getConsumesMediaTypes() {
        return this.consumesMediaTypes;
    }

    public List<String> getProducesMediaTypes() {
        return this.producesMediaTypes;
    }

    public static final class ParameterInfo<T> {
        private final Annotation annotation;
        private final Function<T, Object> converter;
        private final Type parameterType;
        private final String defaultVal;

        private ParameterInfo(Type parameterType, Annotation annotation, String defaultVal, @Nullable Function<T, Object> converter) {
            this.parameterType = parameterType;
            this.annotation = annotation;
            this.defaultVal = defaultVal;
            this.converter = converter;
        }

        static <V> ParameterInfo<V> create(Type parameterType, Annotation annotation, String defaultVal, @Nullable Function<V, Object> converter) {
            return new ParameterInfo<V>(parameterType, annotation, defaultVal, converter);
        }

        <V extends Annotation> V getAnnotation() {
            return (V)this.annotation;
        }

        public Type getParameterType() {
            return this.parameterType;
        }

        public String getDefaultVal() {
            return this.defaultVal;
        }

        Object convert(T input) {
            return this.converter == null ? null : this.converter.apply(input);
        }
    }
}

