/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMultimap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.internal.router.BasicHttpResponder;
import org.wso2.msf4j.internal.router.HandlerException;
import org.wso2.msf4j.internal.router.HttpMethodInfoBuilder;
import org.wso2.msf4j.internal.router.MicroserviceMetadata;

public class RequestRouter
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Logger log = LoggerFactory.getLogger(RequestRouter.class);
    private final int chunkMemoryLimit;
    private final MicroserviceMetadata httpMethodHandler;
    private final AtomicBoolean exceptionRaised;
    public static final String METHOD_INFO_BUILDER = "METHOD_INFO_BUILDER";
    private HttpMethodInfoBuilder httpMethodInfoBuilder;

    public RequestRouter(MicroserviceMetadata methodHandler, int chunkMemoryLimit) {
        this.httpMethodHandler = methodHandler;
        this.chunkMemoryLimit = chunkMemoryLimit;
        this.exceptionRaised = new AtomicBoolean(false);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        Channel channel = ctx.channel();
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            if (this.handleRequest(request, channel, ctx)) {
                if (this.httpMethodInfoBuilder.getHttpResourceModel().isStreamingReqSupported() && channel.pipeline().get("aggregator") != null) {
                    channel.pipeline().remove("aggregator");
                } else if (!this.httpMethodInfoBuilder.getHttpResourceModel().isStreamingReqSupported() && channel.pipeline().get("aggregator") == null) {
                    channel.pipeline().addAfter("router", "aggregator", new HttpObjectAggregator(Integer.MAX_VALUE));
                }
            }
            ReferenceCountUtil.retain(msg);
            ctx.fireChannelRead(msg);
        } else if (msg instanceof HttpContent) {
            ReferenceCountUtil.retain(msg);
            ctx.fireChannelRead(msg);
        }
    }

    private boolean handleRequest(HttpRequest httpRequest, Channel channel, ChannelHandlerContext ctx) throws HandlerException {
        this.httpMethodInfoBuilder = this.httpMethodHandler.getDestinationMethod(httpRequest, new BasicHttpResponder(channel, HttpHeaders.isKeepAlive(httpRequest)));
        ctx.attr(AttributeKey.valueOf(METHOD_INFO_BUILDER)).set(this.httpMethodInfoBuilder);
        return this.httpMethodInfoBuilder != null;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String exceptionMessage = "Exception caught in channel processing.";
        if (!this.exceptionRaised.get()) {
            this.exceptionRaised.set(true);
            if (this.httpMethodInfoBuilder != null) {
                log.error(exceptionMessage, cause);
                this.sendError(HttpResponseStatus.INTERNAL_SERVER_ERROR, cause);
                this.httpMethodInfoBuilder = null;
            } else {
                HttpResponse response;
                if (cause instanceof HandlerException) {
                    response = ((HandlerException)cause).createFailureResponse();
                    if (this.isUserError(response)) {
                        log.trace(exceptionMessage, cause);
                    } else {
                        log.error(exceptionMessage, cause);
                    }
                } else {
                    log.error(exceptionMessage, cause);
                    response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                }
                response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
                ctx.writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
            }
        } else {
            log.trace(exceptionMessage, cause);
        }
    }

    private boolean isUserError(HttpResponse response) {
        int code = response.getStatus().code();
        return code == HttpResponseStatus.BAD_REQUEST.code() || code == HttpResponseStatus.NOT_FOUND.code() || code == HttpResponseStatus.METHOD_NOT_ALLOWED.code();
    }

    private void sendError(HttpResponseStatus status, Throwable ex) {
        String msg = ex instanceof InvocationTargetException ? String.format("Exception Encountered while processing request : %s", Objects.firstNonNull(ex.getCause(), ex).getMessage()) : String.format("Exception Encountered while processing request: %s", ex.getMessage());
        this.httpMethodInfoBuilder.getResponder().sendString(status, msg, ImmutableMultimap.of("Connection", "close"));
    }
}

