/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.throttling.siddhi.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.carbon.apimgt.throttling.siddhi.extension.ThrottleStreamProcessor;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

@Extension(name="emitOnStateChange", namespace="throttler", description="The logger stream processor logs the message with or without event for the given log priority.", parameters={@Parameter(name="throttle.key", description="The priority/type of this log message.", type={DataType.STRING}), @Parameter(name="is.throttled", description="This submit the log message.", type={DataType.STRING})}, examples={@Example(syntax="from fooStream#log(\"INFO\", \"Sample Event :\", true)\nselect *\ninsert into barStream;", description="This will log as INFO with the message \"Sample Event :\" + fooStream:events."), @Example(syntax="from fooStream#log(\"Sample Event :\", true)\nselect *\ninsert into barStream;", description="This will logs with default log level as INFO."), @Example(syntax="from fooStream#log(\"Sample Event :\", fasle)\nselect *\ninsert into barStream;", description="This will only log message."), @Example(syntax="from fooStream#log(true)\nselect *\ninsert into barStream;", description="This will only log fooStream:events."), @Example(syntax="from fooStream#log(\"Sample Event :\")\nselect *\ninsert into barStream;", description="This will log message and fooStream:events.")})
public class EmitOnStateChange
extends StreamProcessor {
    private VariableExpressionExecutor keyExpressionExecutor;
    private VariableExpressionExecutor isThrottledExpressionExecutor;
    private Map<String, Object> throttleStateMap = new HashMap<String, Object>();
    private static final Logger log = Logger.getLogger(ThrottleStreamProcessor.class);

    public void start() {
    }

    public void stop() {
    }

    public Map<String, Object> currentState() {
        return this.throttleStateMap;
    }

    public void restoreState(Map<String, Object> map) {
        this.throttleStateMap = map;
    }

    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor processor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        while (streamEventChunk.hasNext()) {
            StreamEvent event = (StreamEvent)streamEventChunk.next();
            Boolean currentThrottleState = (Boolean)this.isThrottledExpressionExecutor.execute((ComplexEvent)event);
            String key = (String)this.keyExpressionExecutor.execute((ComplexEvent)event);
            Boolean lastThrottleState = (Boolean)this.throttleStateMap.get(key);
            log.info((Object)("currentThrottleState" + currentThrottleState));
            log.info((Object)("lastThrottleState" + lastThrottleState));
            log.info((Object)("result" + (currentThrottleState.equals(lastThrottleState) && currentThrottleState == false)));
            if (currentThrottleState.equals(lastThrottleState) && !currentThrottleState.booleanValue()) {
                streamEventChunk.remove();
                continue;
            }
            this.throttleStateMap.put(key, currentThrottleState);
        }
        this.nextProcessor.process(streamEventChunk);
    }

    protected List<Attribute> init(AbstractDefinition abstractDefinition, ExpressionExecutor[] expressionExecutors, ConfigReader configReader, ExecutionPlanContext executionPlanContext) {
        if (this.attributeExpressionExecutors.length != 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to throttler:emitOnStateChange(key,isThrottled), required 2, but found " + this.attributeExpressionExecutors.length);
        }
        if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the argument of throttler:emitOnStateChange(key,isThrottled), required " + Attribute.Type.STRING + ", but found " + this.attributeExpressionExecutors[0].getReturnType());
        }
        if (this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.BOOL) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the argument of throttler:emitOnStateChange(key,isThrottled), required " + Attribute.Type.BOOL + ", but found " + this.attributeExpressionExecutors[1].getReturnType());
        }
        this.keyExpressionExecutor = (VariableExpressionExecutor)this.attributeExpressionExecutors[0];
        this.isThrottledExpressionExecutor = (VariableExpressionExecutor)this.attributeExpressionExecutors[1];
        return new ArrayList<Attribute>();
    }
}

