/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.throttling.siddhi.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

@Extension(name="timeBatch", namespace="throttler", description="A batch (tumbling) time window that holds events that arrive during window.time periods, and gets updated for each window.time.", parameters={@Parameter(name="window.time", description="The batch time period for which the window should hold events.", type={DataType.INT, DataType.LONG, DataType.TIME}), @Parameter(name="start.time", description="This specifies an offset in milliseconds in order to start the window at a time different to the standard time.", type={DataType.INT})}, examples={@Example(syntax="define window cseEventWindow (symbol string, price float, volume int) timeBatch(20) output all events;\n@info(name = 'query0')\nfrom cseEventStream\ninsert into cseEventWindow;\n@info(name = 'query1')\nfrom cseEventWindow\nselect symbol, sum(price) as price\ninsert all events into outputStream ;", description="This will processing events arrived every 20 milliseconds as a batch and out put all events.")})
public class ThrottleStreamProcessor
extends StreamProcessor
implements SchedulingProcessor,
FindableProcessor {
    private static final Logger log = Logger.getLogger(ThrottleStreamProcessor.class);
    private long timeInMilliSeconds;
    private ComplexEventChunk<StreamEvent> expiredEventChunk = new ComplexEventChunk(true);
    private Scheduler scheduler = null;
    private ExecutionPlanContext executionPlanContext;
    private long expireEventTime = -1L;
    private long startTime = -1L;

    public synchronized void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public synchronized Scheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Attribute> init(AbstractDefinition abstractDefinition, ExpressionExecutor[] expressionExecutors, ConfigReader configReader, ExecutionPlanContext executionPlanContext) {
        this.executionPlanContext = executionPlanContext;
        if (this.attributeExpressionExecutors.length == 1) {
            if (!(this.attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new ExecutionPlanValidationException("Throttle batch window 1st parameter needs to be constant parameter attribute but found a dynamic attribute " + this.attributeExpressionExecutors[0].getClass().getCanonicalName());
            if (this.attributeExpressionExecutors[0].getReturnType() == Attribute.Type.INT) {
                this.timeInMilliSeconds = ((Integer)((ConstantExpressionExecutor)this.attributeExpressionExecutors[0]).getValue()).intValue();
            } else {
                if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("Throttle batch window's 1st parameter attribute should be either int or long, but found " + this.attributeExpressionExecutors[0].getReturnType());
                this.timeInMilliSeconds = (Long)((ConstantExpressionExecutor)this.attributeExpressionExecutors[0]).getValue();
            }
        } else {
            if (this.attributeExpressionExecutors.length != 2) throw new ExecutionPlanValidationException("Throttle batch window should only have one/two parameter (<int|long|time> windowTime (and <int|long> startTime), but found " + this.attributeExpressionExecutors.length + " input attributes");
            if (!(this.attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new ExecutionPlanValidationException("Throttle batch window 1st parameter needs to be constant attribute but found a dynamic attribute " + this.attributeExpressionExecutors[0].getClass().getCanonicalName());
            if (this.attributeExpressionExecutors[0].getReturnType() == Attribute.Type.INT) {
                this.timeInMilliSeconds = ((Integer)((ConstantExpressionExecutor)this.attributeExpressionExecutors[0]).getValue()).intValue();
            } else {
                if (this.attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("Throttle batch window's 1st parameter attribute should be either int or long, but found " + this.attributeExpressionExecutors[0].getReturnType());
                this.timeInMilliSeconds = (Long)((ConstantExpressionExecutor)this.attributeExpressionExecutors[0]).getValue();
            }
            if (this.attributeExpressionExecutors[1].getReturnType() == Attribute.Type.INT) {
                this.startTime = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)this.attributeExpressionExecutors[1]).getValue()));
            } else {
                if (this.attributeExpressionExecutors[1].getReturnType() != Attribute.Type.LONG) throw new ExecutionPlanValidationException("Throttle batch window 2nd parameter needs to be a Long or Int type but found a " + this.attributeExpressionExecutors[2].getReturnType());
                this.startTime = Long.parseLong(String.valueOf(((ConstantExpressionExecutor)this.attributeExpressionExecutors[1]).getValue()));
            }
        }
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        attributeList.add(new Attribute("expiryTimeStamp", Attribute.Type.LONG));
        return attributeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        ThrottleStreamProcessor throttleStreamProcessor = this;
        synchronized (throttleStreamProcessor) {
            boolean sendEvents;
            long currentTime;
            if (this.expireEventTime == -1L) {
                currentTime = this.executionPlanContext.getTimestampGenerator().currentTime();
                this.expireEventTime = this.startTime != -1L ? this.addTimeShift(currentTime) : this.executionPlanContext.getTimestampGenerator().currentTime() + this.timeInMilliSeconds;
                if (this.scheduler != null) {
                    this.scheduler.notifyAt(this.expireEventTime);
                } else {
                    log.error((Object)"scheduler is not initiated");
                }
            }
            if ((currentTime = this.executionPlanContext.getTimestampGenerator().currentTime()) >= this.expireEventTime) {
                this.expireEventTime += this.timeInMilliSeconds;
                if (this.scheduler != null) {
                    this.scheduler.notifyAt(this.expireEventTime);
                } else {
                    log.error((Object)"scheduler is not initiated");
                }
                sendEvents = true;
            } else {
                sendEvents = false;
            }
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                if (streamEvent.getType() != ComplexEvent.Type.CURRENT) continue;
                complexEventPopulater.populateComplexEvent((ComplexEvent)streamEvent, new Object[]{this.expireEventTime});
                StreamEvent clonedStreamEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedStreamEvent.setType(ComplexEvent.Type.EXPIRED);
                clonedStreamEvent.setTimestamp(this.expireEventTime);
                this.expiredEventChunk.add((ComplexEvent)clonedStreamEvent);
            }
            if (sendEvents) {
                this.expiredEventChunk.reset();
                if (this.expiredEventChunk.getFirst() != null) {
                    streamEventChunk.add(this.expiredEventChunk.getFirst());
                }
                this.expiredEventChunk.clear();
            }
        }
        if (streamEventChunk.getFirst() != null) {
            streamEventChunk.setBatch(true);
            nextProcessor.process(streamEventChunk);
            streamEventChunk.setBatch(false);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Map<String, Object> currentState() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("0", this.expiredEventChunk);
        return map;
    }

    public void restoreState(Map<String, Object> map) {
    }

    public synchronized StreamEvent find(StateEvent stateEvent, CompiledCondition compiledCondition) {
        if (compiledCondition instanceof Operator) {
            return ((Operator)compiledCondition).find(stateEvent, this.expiredEventChunk, this.streamEventCloner);
        }
        return null;
    }

    private long addTimeShift(long currentTime) {
        long timePassedUntilNow = (currentTime - this.startTime) % this.timeInMilliSeconds;
        return currentTime + (this.timeInMilliSeconds - timePassedUntilNow);
    }

    public CompiledCondition compileCondition(Expression expression, MatchingMetaInfoHolder matchingMetaInfoHolder, ExecutionPlanContext executionPlanContext, List<VariableExpressionExecutor> list, Map<String, Table> map, String s) {
        return OperatorParser.constructOperator(this.expiredEventChunk, (Expression)expression, (MatchingMetaInfoHolder)matchingMetaInfoHolder, (ExecutionPlanContext)executionPlanContext, list, map, (String)this.queryName);
    }
}

