/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.output.transport.jms;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.MapCarbonMessage;
import org.wso2.carbon.messaging.TextCarbonMessage;
import org.wso2.carbon.messaging.exceptions.ClientConnectorException;
import org.wso2.carbon.transport.jms.sender.JMSClientConnector;

public class JMSPublisher
implements Runnable {
    private static final Logger log = Logger.getLogger(JMSPublisher.class);
    private static final String MESSAGE_TYPE_FIELD = "JMS_MESSAGE_TYPE";
    private static final String TEXT_MESSAGE_TYPE = "TextMessage";
    private static final String BYTEARRAY_MESSAGE_TYPE = "ByteMessage";
    private Map<String, String> jmsProperties = new HashMap<String, String>();
    private JMSClientConnector jmsClientConnector;
    private CarbonMessage message;

    public JMSPublisher(String destination, Map<String, String> staticJMSProperties, JMSClientConnector jmsClientConnector, Object payload) {
        this.jmsProperties.putAll(staticJMSProperties);
        this.jmsProperties.put("destination", destination);
        this.jmsClientConnector = jmsClientConnector;
        this.message = this.handleCarbonMessage(payload);
    }

    @Override
    public void run() {
        try {
            this.jmsClientConnector.send(this.message, null, this.jmsProperties);
        }
        catch (ClientConnectorException e) {
            log.error((Object)"Error sending JMS message: ", (Throwable)e);
        }
    }

    private CarbonMessage handleCarbonMessage(Object payload) {
        if (payload instanceof String) {
            TextCarbonMessage textCarbonMessage = new TextCarbonMessage(payload.toString());
            this.jmsProperties.put(MESSAGE_TYPE_FIELD, TEXT_MESSAGE_TYPE);
            return textCarbonMessage;
        }
        if (payload instanceof Map) {
            MapCarbonMessage mapCarbonMessage = new MapCarbonMessage();
            ((Map)payload).forEach((key, value) -> mapCarbonMessage.setValue((String)key, (String)value));
            return mapCarbonMessage;
        }
        if (payload instanceof Byte[]) {
            TextCarbonMessage byteCarbonMessage = new TextCarbonMessage(payload.toString());
            this.jmsProperties.put(MESSAGE_TYPE_FIELD, BYTEARRAY_MESSAGE_TYPE);
            return byteCarbonMessage;
        }
        throw new RuntimeException("The type of the output payload cannot be cast to String, Map or Byte[] from JMS");
    }
}

