/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.output.transport.jms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.wso2.carbon.transport.jms.sender.JMSClientConnector;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ConnectionUnavailableException;
import org.wso2.siddhi.core.stream.output.sink.Sink;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.transport.DynamicOptions;
import org.wso2.siddhi.core.util.transport.Option;
import org.wso2.siddhi.core.util.transport.OptionHolder;
import org.wso2.siddhi.extension.output.transport.jms.JMSPublisher;
import org.wso2.siddhi.extension.output.transport.jms.util.JMSOptionsMapper;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

@Extension(name="jms", namespace="sink", description="JMS Output Transport", examples={@Example(description="TBD", syntax="TBD")})
public class JMSSink
extends Sink {
    private OptionHolder optionHolder;
    private JMSClientConnector clientConnector;
    private Option destination;
    private Map<String, String> jmsStaticProperties;
    private ExecutorService executorService;

    protected void init(StreamDefinition outputStreamDefinition, OptionHolder optionHolder, ConfigReader sinkConfigReader, ExecutionPlanContext executionPlanContext) {
        this.optionHolder = optionHolder;
        this.destination = optionHolder.getOrCreateOption("destination", null);
        this.jmsStaticProperties = this.initJMSProperties();
        this.executorService = executionPlanContext.getExecutorService();
    }

    public void connect() throws ConnectionUnavailableException {
        this.clientConnector = new JMSClientConnector();
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }

    public void publish(Object payload, DynamicOptions transportOptions) throws ConnectionUnavailableException {
        String topicQueueName = this.destination.getValue(transportOptions);
        this.executorService.submit(new JMSPublisher(topicQueueName, this.jmsStaticProperties, this.clientConnector, payload));
    }

    public String[] getSupportedDynamicOptions() {
        return new String[]{"destination"};
    }

    public void disconnect() {
    }

    public void destroy() {
    }

    private Map<String, String> initJMSProperties() {
        List<String> requiredOptions = JMSOptionsMapper.getRequiredOptions();
        Map<String, String> customPropertyMapping = JMSOptionsMapper.getCustomPropertyMapping();
        HashMap<String, String> transportProperties = new HashMap<String, String>();
        requiredOptions.forEach(requiredOption -> transportProperties.put((String)customPropertyMapping.get(requiredOption), this.optionHolder.validateAndGetStaticValue(requiredOption)));
        this.optionHolder.getStaticOptionsKeys().stream().filter(option -> !requiredOptions.contains(option) && !option.equals("type")).forEach(option -> transportProperties.put((String)option, this.optionHolder.validateAndGetStaticValue(option)));
        return transportProperties;
    }
}

