/*
 * WSO2 API Manager - Publisher API
 * This specifies a **RESTful API** for WSO2 **API Manager** - Publisher.  Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.0.4/components/apimgt/org.wso2.carbon.apimgt.rest.api.publisher/src/main/resources/publisher-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: 0.10.0
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.wso2.carbon.apimgt.rest.integration.tests.api;

import org.wso2.carbon.apimgt.rest.integration.tests.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.model.Tier;
import org.wso2.carbon.apimgt.rest.integration.tests.model.TierPermission;
import org.junit.Test;

/**
 * API tests for ThrottlingTierIndividualApi
 */
public class ThrottlingTierIndividualApiIT {

    private final ThrottlingTierIndividualApi api = new ThrottlingTierIndividualApi();

    
    /**
     * Delete a Tier
     *
     * This operation can be used to delete an existing policy. The only supported policy level is &#x60;api&#x60; policies. &#x60;DELETE https://127.0.0.1:9443/api/am/publisher/v0.10/policies/api/Low&#x60;  **IMPORTANT:** * This is only effective when Advanced Throttling is disabled in the Server. If enabled, we need to use Admin REST API for throttling policies modification related operations. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void policiesTierLevelTierNameDeleteTest() throws ApiException {
        String tierName = null;
        String tierLevel = null;
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        // api.policiesTierLevelTierNameDelete(tierName, tierLevel, ifMatch, ifUnmodifiedSince);

        // TODO: test validations
    }
    
    /**
     * Get details of a policy
     *
     * This operation can be used to retrieve details of a single policy by specifying the policy level and policy name. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void policiesTierLevelTierNameGetTest() throws ApiException {
        String tierName = null;
        String tierLevel = null;
        String accept = null;
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        //Tier response = api.policiesTierLevelTierNameGet(tierName, tierLevel, accept, ifNoneMatch, ifModifiedSince);

        // TODO: test validations
    }
    
    /**
     * Update a Tier
     *
     * This operation can be used to update an existing policy. The only supported policy level is &#x60;api&#x60; policies. &#x60;PUT https://127.0.0.1:9443/api/am/publisher/v0.10/policies/api/Low&#x60;  **IMPORTANT:** * This is only effective when Advanced Throttling is disabled in the Server. If enabled, we need to use Admin REST API for throttling policies modification related operations. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void policiesTierLevelTierNamePutTest() throws ApiException {
        String tierName = null;
        Tier body = null;
        String tierLevel = null;
        String contentType = null;
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        // Tier response = api.policiesTierLevelTierNamePut(tierName, body, tierLevel, contentType, ifMatch, ifUnmodifiedSince);

        // TODO: test validations
    }
    
    /**
     * Update policy permission
     *
     * This operation can be used to update policy permissions which controls access for the particular policy based on the subscribers&#39; roles. 
     *
     * @throws ApiException
     *          if the Api call fails
     */
    @Test
    public void policiesUpdatePermissionPostTest() throws ApiException {
        String tierName = null;
        String tierLevel = null;
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        TierPermission permissions = null;
        // List<Tier> response = api.policiesUpdatePermissionPost(tierName, tierLevel, ifMatch, ifUnmodifiedSince, permissions);

        // TODO: test validations
    }
    
}
