/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.importexport;

import java.io.File;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.importexport.APIExportException;
import org.wso2.carbon.apimgt.importexport.APIImportException;
import org.wso2.carbon.apimgt.importexport.utils.APIExportUtil;
import org.wso2.carbon.apimgt.importexport.utils.APIImportUtil;
import org.wso2.carbon.apimgt.importexport.utils.ArchiveGeneratorUtil;
import org.wso2.carbon.apimgt.importexport.utils.AuthenticatorUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

@Path(value="/")
public class APIService {
    private static final Log log = LogFactory.getLog(APIService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/export-api")
    @Produces(value={"application/zip"})
    public Response exportAPI(@QueryParam(value="name") String name, @QueryParam(value="version") String version, @QueryParam(value="provider") String providerName, @Context HttpHeaders httpHeaders) {
        if (name == null || version == null || providerName == null) {
            log.error((Object)"Invalid API Information ");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid API Information").type("application/json").build();
        }
        log.info((Object)("Retrieving API for API-Id : " + name + "-" + version + "-" + providerName));
        boolean isTenantFlowStarted = false;
        try {
            String apiRequesterDomain;
            Response authorizationResponse = AuthenticatorUtil.authorizeUser((HttpHeaders)httpHeaders);
            if (Response.Status.OK.getStatusCode() != authorizationResponse.getStatus()) {
                Response response = authorizationResponse;
                return response;
            }
            String userName = AuthenticatorUtil.getAuthenticatedUserName();
            String apiDomain = MultitenantUtils.getTenantDomain((String)providerName);
            if (!apiDomain.equals(apiRequesterDomain = MultitenantUtils.getTenantDomain((String)userName))) {
                log.error((Object)("Not authorized to export API :" + name + "-" + version + "-" + providerName));
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Not authorized to export API :" + name + "-" + version + "-" + providerName)).type("application/json").build();
                return response;
            }
            APIIdentifier apiIdentifier = new APIIdentifier(APIUtil.replaceEmailDomain((String)providerName), name, version);
            String currentDirectory = System.getProperty("java.io.tmpdir");
            String createdFolders = File.separator + RandomStringUtils.randomAlphanumeric((int)5) + File.separator;
            File exportFolder = new File(currentDirectory + createdFolders);
            APIExportUtil.createDirectory((String)exportFolder.getPath());
            String archiveBasePath = exportFolder.toString();
            APIExportUtil.setArchiveBasePath((String)archiveBasePath);
            if (apiRequesterDomain != null && !"carbon.super".equals(apiRequesterDomain)) {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(apiRequesterDomain, true);
                isTenantFlowStarted = true;
            }
            Response apiResourceRetrievalResponse = APIExportUtil.retrieveApiToExport((APIIdentifier)apiIdentifier, (String)userName);
            if (Response.Status.OK.getStatusCode() != apiResourceRetrievalResponse.getStatus()) {
                Response response = apiResourceRetrievalResponse;
                return response;
            }
            ArchiveGeneratorUtil.archiveDirectory((String)archiveBasePath);
            log.info((Object)("API" + name + "-" + version + " exported successfully"));
            File file = new File(archiveBasePath + ".zip");
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + file.getName() + "\""));
            Response response2 = response.build();
            return response2;
        }
        catch (APIExportException e) {
            log.error((Object)"APIExportException occurred while exporting ", (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).type("application/json").build();
            return response;
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/import-api")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response importAPI(@Multipart(value="file") InputStream uploadedInputStream, @QueryParam(value="preserveProvider") String defaultProviderStatus, @Context HttpHeaders httpHeaders) {
        Response response;
        boolean isProviderPreserved = true;
        boolean isTenantFlowStarted = false;
        if ("FALSE".equalsIgnoreCase(defaultProviderStatus)) {
            isProviderPreserved = false;
        }
        try {
            Response authorizationResponse = AuthenticatorUtil.authorizeUser((HttpHeaders)httpHeaders);
            if (Response.Status.OK.getStatusCode() == authorizationResponse.getStatus()) {
                String currentUser = AuthenticatorUtil.getAuthenticatedUserName();
                APIImportUtil.initializeProvider((String)currentUser);
                String currentDirectory = System.getProperty("java.io.tmpdir");
                String createdFolders = File.separator + RandomStringUtils.randomAlphanumeric((int)5) + File.separator;
                File importFolder = new File(currentDirectory + createdFolders);
                boolean folderCreateStatus = importFolder.mkdirs();
                if (folderCreateStatus) {
                    String uploadFileName = "APIArchive.zip";
                    String absolutePath = currentDirectory + createdFolders;
                    APIImportUtil.transferFile((InputStream)uploadedInputStream, (String)uploadFileName, (String)absolutePath);
                    String extractedFolderName = APIImportUtil.extractArchive((File)new File(absolutePath + uploadFileName), (String)absolutePath);
                    String tenantDomain = MultitenantUtils.getTenantDomain((String)currentUser);
                    if (tenantDomain != null && !"carbon.super".equals(tenantDomain)) {
                        PrivilegedCarbonContext.startTenantFlow();
                        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
                        isTenantFlowStarted = true;
                    }
                    APIImportUtil.importAPI((String)(absolutePath + extractedFolderName), (String)currentUser, (boolean)isProviderPreserved);
                    importFolder.deleteOnExit();
                    Response response2 = Response.status((Response.Status)Response.Status.CREATED).entity((Object)"API imported successfully.\n").build();
                    return response2;
                }
                Response response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                return response3;
            }
            Response response4 = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Not authorized to import API.\n").build();
            return response4;
        }
        catch (APIExportException e) {
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error in initializing API provider.\n").build();
            return response;
        }
        catch (APIImportException e) {
            response = Response.serverError().entity((Object)e.getErrorDescription()).build();
            return response;
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }
}

