/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.importexport.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.APIStatus;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.impl.APIManagerFactory;
import org.wso2.carbon.apimgt.impl.definitions.APIDefinitionFromSwagger20;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.importexport.APIExportException;
import org.wso2.carbon.apimgt.importexport.APIImportExportConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.governance.lcm.util.CommonUtil;
import org.wso2.carbon.registry.api.Collection;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;

/*
 * Exception performing whole class analysis ignored.
 */
public class APIExportUtil {
    private static final Log log = LogFactory.getLog(APIExportUtil.class);
    private static String archiveBasePath = null;

    private APIExportUtil() {
    }

    public static void setArchiveBasePath(String path) {
        archiveBasePath = path;
    }

    public static APIProvider getProvider(String userName) throws APIExportException {
        try {
            APIProvider provider = APIManagerFactory.getInstance().getAPIProvider(userName);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Current provider retrieved successfully");
            }
            int tenantId = APIUtil.getTenantId((String)userName);
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            RegistryService registryService = (RegistryService)carbonContext.getOSGiService(RegistryService.class, null);
            CommonUtil.addDefaultLifecyclesIfNotAvailable((Registry)registryService.getConfigSystemRegistry(tenantId), (Registry)CommonUtil.getRootSystemRegistry((int)tenantId));
            return provider;
        }
        catch (APIManagementException e) {
            String errorMessage = "Error while retrieving provider";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String errorMessage = "Error while loading logged in user's tenant registry";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (FileNotFoundException e) {
            String errorMessage = "Error while loading logged in user's tenant registry";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            String errorMessage = "Error while loading logged in user's tenant registry";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
    }

    public static org.wso2.carbon.registry.api.Registry getRegistry() {
        org.wso2.carbon.registry.api.Registry registry = CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registry of logged in user retrieved successfully");
        }
        return registry;
    }

    public static Response retrieveApiToExport(APIIdentifier apiID, String userName) throws APIExportException {
        String wsdlUrl;
        List docList;
        API apiToReturn;
        String archivePath = archiveBasePath.concat(File.separator + apiID.getApiName() + "-" + apiID.getVersion());
        APIProvider provider = APIExportUtil.getProvider((String)userName);
        org.wso2.carbon.registry.api.Registry registry = APIExportUtil.getRegistry();
        int tenantId = APIUtil.getTenantId((String)userName);
        APIExportUtil.createDirectory((String)archivePath);
        try {
            apiToReturn = provider.getAPI(apiID);
        }
        catch (APIManagementException e) {
            String errorMessage = "Unable to retrieve API";
            log.error((Object)errorMessage, (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorMessage).type("application/json").build();
        }
        APIExportUtil.exportAPIThumbnail((APIIdentifier)apiID, (org.wso2.carbon.registry.api.Registry)registry);
        try {
            docList = provider.getAllDocumentation(apiID);
        }
        catch (APIManagementException e) {
            String errorMessage = "Unable to retrieve API Documentation";
            log.error((Object)errorMessage, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Internal Server Error").type("application/json").build();
        }
        if (!docList.isEmpty()) {
            APIExportUtil.exportAPIDocumentation((List)docList, (APIIdentifier)apiID, (org.wso2.carbon.registry.api.Registry)registry);
        }
        if ((wsdlUrl = apiToReturn.getWsdlUrl()) != null) {
            APIExportUtil.exportWSDL((APIIdentifier)apiID, (org.wso2.carbon.registry.api.Registry)registry);
        }
        APIExportUtil.exportSequences((API)apiToReturn, (APIIdentifier)apiID, (org.wso2.carbon.registry.api.Registry)registry);
        apiToReturn.setStatus(APIStatus.CREATED);
        APIExportUtil.exportMetaInformation((API)apiToReturn, (org.wso2.carbon.registry.api.Registry)registry);
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportAPIThumbnail(APIIdentifier apiIdentifier, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        String thumbnailUrl = "/apimgt/applicationdata/icons/" + apiIdentifier.getProviderName() + "/" + apiIdentifier.getApiName() + "/" + apiIdentifier.getVersion() + "/" + "icon";
        InputStream imageDataStream = null;
        FileOutputStream outputStream = null;
        String archivePath = archiveBasePath.concat(File.separator + apiIdentifier.getApiName() + '-' + apiIdentifier.getVersion());
        try {
            if (registry.resourceExists(thumbnailUrl)) {
                Resource icon = registry.get(thumbnailUrl);
                imageDataStream = icon.getContentStream();
                String mediaType = icon.getMediaType();
                String extension = APIExportUtil.getThumbnailFileType((String)mediaType);
                if (extension != null) {
                    APIExportUtil.createDirectory((String)(archivePath + File.separator + "Image"));
                    outputStream = new FileOutputStream(archivePath + File.separator + "Image" + File.separator + "icon." + extension);
                    IOUtils.copy((InputStream)imageDataStream, (OutputStream)outputStream);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Thumbnail image retrieved successfully");
                    }
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"I/O error while writing API Thumbnail to file", (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retrieving API Thumbnail ", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(imageDataStream);
            IOUtils.closeQuietly(outputStream);
        }
    }

    private static String getThumbnailFileType(String mediaType) {
        if ("image/png".equals(mediaType)) {
            return "png";
        }
        if ("image/jpg".equals(mediaType)) {
            return "jpg";
        }
        if ("image/jpeg".equals(mediaType)) {
            return "jpeg";
        }
        if ("image/bmp".equals(mediaType)) {
            return "bmp";
        }
        if ("image/gif".equals(mediaType)) {
            return "gif";
        }
        log.error((Object)("Unsupported media type for icon " + mediaType));
        return null;
    }

    public static void exportAPIDocumentation(List<Documentation> docList, APIIdentifier apiIdentifier, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String archivePath = archiveBasePath.concat(File.separator + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion());
        APIExportUtil.createDirectory((String)(archivePath + File.separator + "Docs"));
        InputStream fileInputStream = null;
        FileOutputStream outputStream = null;
        try {
            for (Documentation doc : docList) {
                String sourceType = doc.getSourceType().name();
                if (Documentation.DocumentSourceType.FILE.toString().equalsIgnoreCase(sourceType)) {
                    String fileName = doc.getFilePath().substring(doc.getFilePath().lastIndexOf("/") + 1);
                    String filePath = APIUtil.getDocumentationFilePath((APIIdentifier)apiIdentifier, (String)fileName);
                    Resource docFile = registry.get(filePath);
                    String localDirectoryPath = File.separator + "Docs" + File.separator + "FileContents";
                    APIExportUtil.createDirectory((String)(archivePath + File.separator + localDirectoryPath));
                    String localFilePath = localDirectoryPath + File.separator + fileName;
                    outputStream = new FileOutputStream(archivePath + localFilePath);
                    fileInputStream = docFile.getContentStream();
                    IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
                    doc.setFilePath(fileName);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(fileName + " retrieved successfully"));
                    continue;
                }
                if (!Documentation.DocumentSourceType.INLINE.toString().equalsIgnoreCase(sourceType)) continue;
                APIExportUtil.createDirectory((String)(archivePath + File.separator + "Docs" + File.separator + "InlineContents"));
                String contentPath = APIUtil.getAPIDocPath((APIIdentifier)apiIdentifier) + "/" + "contents" + "/" + doc.getName();
                Resource docFile = registry.get(contentPath);
                String localFilePath = File.separator + "Docs" + File.separator + "InlineContents" + File.separator + doc.getName();
                outputStream = new FileOutputStream(archivePath + localFilePath);
                fileInputStream = docFile.getContentStream();
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
            }
            String json = gson.toJson(docList);
            APIExportUtil.writeFile((String)(archivePath + APIImportExportConstants.DOCUMENT_FILE_LOCATION), (String)json);
            if (log.isDebugEnabled()) {
                log.debug((Object)"API Documentation retrieved successfully");
            }
        }
        catch (IOException e) {
            String errorMessage = "I/O error while writing API documentation to file";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (RegistryException e) {
            String errorMessage = "Error while retrieving documentation ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
            IOUtils.closeQuietly(outputStream);
        }
    }

    public static void exportWSDL(APIIdentifier apiIdentifier, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        InputStream wsdlStream = null;
        FileOutputStream outputStream = null;
        String archivePath = archiveBasePath.concat("/" + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion());
        try {
            String wsdlPath = "/apimgt/applicationdata/wsdls/" + apiIdentifier.getProviderName() + "--" + apiIdentifier.getApiName() + apiIdentifier.getVersion() + ".wsdl";
            if (registry.resourceExists(wsdlPath)) {
                APIExportUtil.createDirectory((String)(archivePath + File.separator + "WSDL"));
                Resource wsdl = registry.get(wsdlPath);
                wsdlStream = wsdl.getContentStream();
                outputStream = new FileOutputStream(archivePath + File.separator + "WSDL" + File.separator + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion() + ".wsdl");
                IOUtils.copy((InputStream)wsdlStream, (OutputStream)outputStream);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"WSDL file retrieved successfully");
                }
            }
        }
        catch (IOException e) {
            String errorMessage = "I/O error while writing WSDL to file";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (RegistryException e) {
            String errorMessage = "Error while retrieving WSDL ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(wsdlStream);
            IOUtils.closeQuietly(outputStream);
        }
    }

    public static void exportSequences(API api, APIIdentifier apiIdentifier, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        HashMap<String, String> sequences = new HashMap<String, String>();
        if (api.getInSequence() != null) {
            sequences.put("in", api.getInSequence());
        }
        if (api.getOutSequence() != null) {
            sequences.put("out", api.getOutSequence());
        }
        if (api.getFaultSequence() != null) {
            sequences.put("fault", api.getFaultSequence());
        }
        if (!sequences.isEmpty()) {
            String archivePath = archiveBasePath.concat(File.separator + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion());
            APIExportUtil.createDirectory((String)(archivePath + File.separator + "Sequences"));
            for (Map.Entry sequence : sequences.entrySet()) {
                AbstractMap.SimpleEntry sequenceDetails;
                String sequenceName = (String)sequence.getValue();
                String direction = (String)sequence.getKey();
                if (sequenceName == null) continue;
                if ("in".equalsIgnoreCase(direction)) {
                    sequenceDetails = APIExportUtil.getCustomSequence((String)sequenceName, (String)"in", (org.wso2.carbon.registry.api.Registry)registry);
                    if (sequenceDetails == null) {
                        sequenceDetails = APIExportUtil.getAPISpecificSequence((APIIdentifier)api.getId(), (String)sequenceName, (String)"in", (org.wso2.carbon.registry.api.Registry)registry);
                        APIExportUtil.writeAPISpecificSequenceToFile((AbstractMap.SimpleEntry)sequenceDetails, (String)"in", (APIIdentifier)apiIdentifier);
                        continue;
                    }
                    APIExportUtil.writeSequenceToFile((AbstractMap.SimpleEntry)sequenceDetails, (String)"in", (APIIdentifier)apiIdentifier);
                    continue;
                }
                if ("out".equalsIgnoreCase(direction)) {
                    sequenceDetails = APIExportUtil.getCustomSequence((String)sequenceName, (String)"out", (org.wso2.carbon.registry.api.Registry)registry);
                    if (sequenceDetails == null) {
                        sequenceDetails = APIExportUtil.getAPISpecificSequence((APIIdentifier)api.getId(), (String)sequenceName, (String)"out", (org.wso2.carbon.registry.api.Registry)registry);
                        APIExportUtil.writeAPISpecificSequenceToFile((AbstractMap.SimpleEntry)sequenceDetails, (String)"out", (APIIdentifier)apiIdentifier);
                        continue;
                    }
                    APIExportUtil.writeSequenceToFile((AbstractMap.SimpleEntry)sequenceDetails, (String)"out", (APIIdentifier)apiIdentifier);
                    continue;
                }
                sequenceDetails = APIExportUtil.getCustomSequence((String)sequenceName, (String)"fault", (org.wso2.carbon.registry.api.Registry)registry);
                if (sequenceDetails == null) {
                    sequenceDetails = APIExportUtil.getAPISpecificSequence((APIIdentifier)api.getId(), (String)sequenceName, (String)"fault", (org.wso2.carbon.registry.api.Registry)registry);
                    APIExportUtil.writeAPISpecificSequenceToFile((AbstractMap.SimpleEntry)sequenceDetails, (String)"fault", (APIIdentifier)apiIdentifier);
                    continue;
                }
                APIExportUtil.writeSequenceToFile((AbstractMap.SimpleEntry)sequenceDetails, (String)"fault", (APIIdentifier)apiIdentifier);
            }
        }
    }

    private static AbstractMap.SimpleEntry<String, OMElement> getCustomSequence(String sequenceName, String type, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        Collection seqCollection = null;
        try {
            if ("in".equals(type)) {
                seqCollection = (Collection)registry.get("/apimgt/customsequences/in/");
            } else if ("out".equals(type)) {
                seqCollection = (Collection)registry.get("/apimgt/customsequences/out/");
            } else if ("fault".equals(type)) {
                seqCollection = (Collection)registry.get("/apimgt/customsequences/fault/");
            }
            if (seqCollection != null) {
                String[] childPaths;
                for (String childPath : childPaths = seqCollection.getChildren()) {
                    Resource sequence = registry.get(childPath);
                    OMElement seqElment = APIUtil.buildOMElement((InputStream)sequence.getContentStream());
                    if (!sequenceName.equals(seqElment.getAttributeValue(new QName("name")))) continue;
                    String sequenceFileName = sequence.getPath().substring(sequence.getPath().lastIndexOf("/"));
                    AbstractMap.SimpleEntry<String, OMElement> sequenceDetails = new AbstractMap.SimpleEntry<String, OMElement>(sequenceFileName, seqElment);
                    return sequenceDetails;
                }
            }
        }
        catch (RegistryException e) {
            String errorMessage = "Error while retrieving sequence from the registry ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (Exception e) {
            String errorMessage = "Error while reading sequence content ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        return null;
    }

    private static AbstractMap.SimpleEntry<String, OMElement> getAPISpecificSequence(APIIdentifier api, String sequenceName, String type, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        String regPath = "/apimgt/applicationdata/provider/" + api.getProviderName() + "/" + api.getApiName() + "/" + api.getVersion() + "/" + type;
        try {
            Collection seqCollection = (Collection)registry.get(regPath);
            if (seqCollection != null) {
                String[] childPaths;
                for (String childPath : childPaths = seqCollection.getChildren()) {
                    Resource sequence = registry.get(childPath);
                    OMElement seqElment = APIUtil.buildOMElement((InputStream)sequence.getContentStream());
                    if (!sequenceName.equals(seqElment.getAttributeValue(new QName("name")))) continue;
                    String sequenceFileName = sequence.getPath().substring(sequence.getPath().lastIndexOf("/"));
                    AbstractMap.SimpleEntry<String, OMElement> sequenceDetails = new AbstractMap.SimpleEntry<String, OMElement>(sequenceFileName, seqElment);
                    return sequenceDetails;
                }
            }
        }
        catch (RegistryException e) {
            String errorMessage = "Error while retrieving sequence from the registry ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (Exception e) {
            String errorMessage = "Error while reading sequence content ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeSequenceToFile(AbstractMap.SimpleEntry<String, OMElement> sequenceDetails, String direction, APIIdentifier apiIdentifier) throws APIExportException {
        FileOutputStream outputStream = null;
        String archivePath = archiveBasePath.concat(File.separator + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion()) + File.separator + "Sequences" + File.separator;
        String pathToExportedSequence = archivePath + direction + "-sequence" + File.separator;
        String sequenceFileName = sequenceDetails.getKey();
        OMElement sequenceConfig = sequenceDetails.getValue();
        String exportedSequenceFile = pathToExportedSequence + sequenceFileName;
        try {
            APIExportUtil.createDirectory((String)pathToExportedSequence);
            outputStream = new FileOutputStream(exportedSequenceFile);
            sequenceConfig.serialize((OutputStream)outputStream);
            if (log.isDebugEnabled()) {
                log.debug((Object)(sequenceFileName + " retrieved successfully"));
            }
        }
        catch (FileNotFoundException e) {
            try {
                String errorMessage = "Unable to find file: " + exportedSequenceFile;
                log.error((Object)errorMessage, (Throwable)e);
                throw new APIExportException(errorMessage, (Throwable)e);
                catch (XMLStreamException e2) {
                    errorMessage = "Error while processing XML stream ";
                    log.error((Object)errorMessage, (Throwable)e2);
                    throw new APIExportException(errorMessage, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeAPISpecificSequenceToFile(AbstractMap.SimpleEntry<String, OMElement> sequenceDetails, String direction, APIIdentifier apiIdentifier) throws APIExportException {
        FileOutputStream outputStream = null;
        String archivePath = archiveBasePath.concat(File.separator + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion()) + File.separator + "Sequences" + File.separator;
        String pathToExportedSequence = archivePath + direction + "-sequence" + File.separator + "Custom";
        String sequenceFileName = sequenceDetails.getKey();
        OMElement sequenceConfig = sequenceDetails.getValue();
        String exportedSequenceFile = pathToExportedSequence + sequenceFileName;
        try {
            APIExportUtil.createDirectory((String)pathToExportedSequence);
            outputStream = new FileOutputStream(exportedSequenceFile);
            sequenceConfig.serialize((OutputStream)outputStream);
            if (log.isDebugEnabled()) {
                log.debug((Object)(sequenceFileName + " retrieved successfully"));
            }
        }
        catch (FileNotFoundException e) {
            try {
                String errorMessage = "Unable to find file: " + exportedSequenceFile;
                log.error((Object)errorMessage, (Throwable)e);
                throw new APIExportException(errorMessage, (Throwable)e);
                catch (XMLStreamException e2) {
                    errorMessage = "Error while processing XML stream ";
                    log.error((Object)errorMessage, (Throwable)e2);
                    throw new APIExportException(errorMessage, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public static void createDirectory(String path) throws APIExportException {
        File file;
        if (path != null && !(file = new File(path)).exists() && !file.mkdirs()) {
            String errorMessage = "Error while creating directory : " + path;
            log.error((Object)errorMessage);
            throw new APIExportException(errorMessage);
        }
    }

    private static void exportMetaInformation(API apiToReturn, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        APIDefinitionFromSwagger20 definitionFromSwagger20 = new APIDefinitionFromSwagger20();
        String archivePath = archiveBasePath.concat(File.separator + apiToReturn.getId().getApiName() + "-" + apiToReturn.getId().getVersion());
        APIExportUtil.createDirectory((String)(archivePath + File.separator + "Meta-information"));
        APIExportUtil.cleanApiDataToExport((API)apiToReturn);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String apiInJson = gson.toJson((Object)apiToReturn);
        APIExportUtil.writeFile((String)(archivePath + File.separator + "Meta-information" + File.separator + "api.json"), (String)apiInJson);
        try {
            String swaggerDefinition = definitionFromSwagger20.getAPIDefinition(apiToReturn.getId(), registry);
            JsonParser parser = new JsonParser();
            JsonObject json = parser.parse(swaggerDefinition).getAsJsonObject();
            String formattedSwaggerJson = gson.toJson((JsonElement)json);
            APIExportUtil.writeFile((String)(archivePath + File.separator + "Meta-information" + File.separator + "swagger.json"), (String)formattedSwaggerJson);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Meta information retrieved successfully");
            }
        }
        catch (APIManagementException e) {
            String errorMessage = "Error while retrieving Swagger definition";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
    }

    private static void cleanApiDataToExport(API api) {
        api.setThumbnailUrl(null);
        api.setScopes(new TreeSet());
    }

    private static void writeFile(String path, String content) throws APIExportException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(path);
            IOUtils.copy((Reader)new StringReader(content), (Writer)writer);
        }
        catch (IOException e) {
            try {
                String errorMessage = "I/O error while writing to file";
                log.error((Object)errorMessage, (Throwable)e);
                throw new APIExportException(errorMessage, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }
}

