/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.importexport.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.importexport.APIExportException;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArchiveGeneratorUtil {
    private static final Log log = LogFactory.getLog(ArchiveGeneratorUtil.class);

    private ArchiveGeneratorUtil() {
    }

    public static void archiveDirectory(String sourceDirectory) throws APIExportException {
        File directoryToZip = new File(sourceDirectory);
        ArrayList fileList = new ArrayList();
        ArchiveGeneratorUtil.getAllFiles((File)directoryToZip, fileList);
        ArchiveGeneratorUtil.writeArchiveFile((File)directoryToZip, fileList);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Archived API generated successfully");
        }
    }

    private static void getAllFiles(File sourceDirectory, List<File> fileList) {
        File[] files = sourceDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                fileList.add(file);
                if (!file.isDirectory()) continue;
                ArchiveGeneratorUtil.getAllFiles((File)file, fileList);
            }
        }
    }

    private static void writeArchiveFile(File directoryToZip, List<File> fileList) throws APIExportException {
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(directoryToZip.getPath() + ".zip");
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            for (File file : fileList) {
                if (file.isDirectory()) continue;
                ArchiveGeneratorUtil.addToArchive((File)directoryToZip, (File)file, (ZipOutputStream)zipOutputStream);
            }
        }
        catch (IOException e) {
            try {
                String errorMessage = "I/O error while adding files to archive";
                log.error((Object)errorMessage, (Throwable)e);
                throw new APIExportException(errorMessage, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipOutputStream);
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)zipOutputStream);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    private static void addToArchive(File directoryToZip, File file, ZipOutputStream zipOutputStream) throws APIExportException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1, file.getCanonicalPath().length());
            if (File.separatorChar != '/') {
                zipFilePath = zipFilePath.replace(File.separatorChar, '/');
            }
            ZipEntry zipEntry = new ZipEntry(zipFilePath);
            zipOutputStream.putNextEntry(zipEntry);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            try {
                String errorMessage = "I/O error while writing files to archive";
                log.error((Object)errorMessage, (Throwable)e);
                throw new APIExportException(errorMessage, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
    }
}

