/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.importexport.utils;

import java.util.List;
import java.util.StringTokenizer;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.importexport.APIExportException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthenticatorUtil {
    private static final String AUTHORIZATION_PROPERTY = "Authorization";
    private static final String AUTHENTICATION_SCHEME = "Basic";
    private static final Log log = LogFactory.getLog(AuthenticatorUtil.class);
    private static String username;
    private static String password;

    private AuthenticatorUtil() {
    }

    public static Response authorizeUser(HttpHeaders headers) throws APIExportException {
        if (!AuthenticatorUtil.isValidCredentials((HttpHeaders)headers)) {
            log.error((Object)"No username and password is provided for authentication");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"No username and password is provided for authentication").type("application/json").build();
        }
        try {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            UserStoreManager userstoremanager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
            String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)username);
            if (userstoremanager.authenticate(tenantAwareUsername, (Object)password)) {
                String[] userRoles;
                log.info((Object)(username + " user authenticated successfully"));
                String adminRoleName = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration().getAdminRoleName();
                for (String userRole : userRoles = userstoremanager.getRoleListOfUser(tenantAwareUsername)) {
                    if (!adminRoleName.equalsIgnoreCase(userRole)) continue;
                    log.info((Object)(username + " is authorized to import and export APIs"));
                    Response response = Response.ok().build();
                    return response;
                }
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"User Authorization Failed").type("application/json").build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"User Authentication Failed").type("application/json").build();
            return response;
        }
        catch (UserStoreException e) {
            String errorMessage = "Error while accessing user configuration";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private static boolean isValidCredentials(HttpHeaders headers) throws APIExportException {
        List authorization = headers.getRequestHeader("Authorization");
        if (authorization == null || authorization.isEmpty()) {
            return false;
        }
        String encodedUserPassword = ((String)authorization.get(0)).replaceFirst("Basic ", "");
        String usernameAndPassword = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((byte[])encodedUserPassword.getBytes()));
        if (usernameAndPassword != null) {
            StringTokenizer tokenizer = new StringTokenizer(usernameAndPassword, ":");
            username = tokenizer.nextToken();
            password = tokenizer.nextToken();
            if (username != null && password != null) {
                return true;
            }
        }
        return false;
    }

    public static String getAuthenticatedUserName() {
        return username;
    }
}

