/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.importexport;

import java.io.File;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.importexport.APIExportException;
import org.wso2.carbon.apimgt.importexport.APIImportException;
import org.wso2.carbon.apimgt.importexport.utils.APIExportUtil;
import org.wso2.carbon.apimgt.importexport.utils.APIImportUtil;
import org.wso2.carbon.apimgt.importexport.utils.ArchiveGeneratorUtil;
import org.wso2.carbon.apimgt.importexport.utils.AuthenticationContext;
import org.wso2.carbon.apimgt.importexport.utils.AuthenticatorUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

@Path(value="/")
public class APIService {
    private static final Log log = LogFactory.getLog(APIService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/export-api")
    @Produces(value={"application/zip"})
    public Response exportAPI(@QueryParam(value="name") String name, @QueryParam(value="version") String version, @QueryParam(value="provider") String providerName, @Context HttpHeaders httpHeaders) {
        if (name == null || version == null || providerName == null) {
            log.error((Object)"Invalid API Information ");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid API Information").type("application/json").build();
        }
        log.info((Object)("Retrieving API for API-Id : " + name + "-" + version + "-" + providerName));
        boolean isTenantFlowStarted = false;
        try {
            Response authorizationResponse = AuthenticatorUtil.authorizeUser((HttpHeaders)httpHeaders);
            if (Response.Status.OK.getStatusCode() != authorizationResponse.getStatus()) {
                Response response = authorizationResponse;
                return response;
            }
            AuthenticationContext authenticationContext = (AuthenticationContext)authorizationResponse.getEntity();
            String userName = authenticationContext.getDomainAwareUsername();
            String tenantDomain = authenticationContext.getTenantDomain();
            if (!"carbon.super".equalsIgnoreCase(tenantDomain)) {
                userName = userName + "@" + tenantDomain;
            }
            String apiDomain = MultitenantUtils.getTenantDomain((String)providerName);
            String apiRequesterDomain = MultitenantUtils.getTenantDomain((String)userName);
            boolean migrationMode = Boolean.getBoolean("migrationMode");
            if (migrationMode) {
                if (APIExportUtil.isCrossTenantAccessPermissionsViolated((String)apiDomain, (String)userName).booleanValue()) {
                    String error = "Not authorized to export API :\"" + name + "-" + version + "-" + providerName;
                    String backEndError = error + ". Reason: Cross Tenant API access is not allowed. Both the facts; setting 'migrationMode=true' system property set at APIM Server startup and the requester being a super tenant admin, should be satisfied for this to be allowed";
                    log.error((Object)backEndError);
                    Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)error).type("application/json").build();
                    return response;
                }
            } else if (!apiDomain.equals(apiRequesterDomain)) {
                log.error((Object)("Not authorized to export API :" + name + "-" + version + "-" + providerName));
                Response error = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Not authorized to export API :" + name + "-" + version + "-" + providerName)).type("application/json").build();
                return error;
            }
            APIIdentifier apiIdentifier = new APIIdentifier(APIUtil.replaceEmailDomain((String)providerName), name, version);
            String currentDirectory = System.getProperty("java.io.tmpdir");
            String createdFolders = File.separator + RandomStringUtils.randomAlphanumeric((int)5) + File.separator;
            File exportFolder = new File(currentDirectory + createdFolders);
            APIExportUtil.createDirectory((String)exportFolder.getPath());
            String archiveBasePath = exportFolder.toString();
            APIExportUtil.setArchiveBasePath((String)archiveBasePath);
            if (migrationMode) {
                if (!"carbon.super".equals(apiDomain)) {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(apiDomain, true);
                    isTenantFlowStarted = true;
                }
            } else if (apiRequesterDomain != null && !"carbon.super".equals(apiRequesterDomain)) {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(apiRequesterDomain, true);
                isTenantFlowStarted = true;
            }
            Response apiResourceRetrievalResponse = APIExportUtil.retrieveApiToExport((APIIdentifier)apiIdentifier, (String)userName);
            if (Response.Status.OK.getStatusCode() != apiResourceRetrievalResponse.getStatus()) {
                Response response = apiResourceRetrievalResponse;
                return response;
            }
            ArchiveGeneratorUtil.archiveDirectory((String)archiveBasePath);
            log.info((Object)("API" + name + "-" + version + " exported successfully"));
            File file = new File(archiveBasePath + ".zip");
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)("attachment; filename=\"" + file.getName() + "\""));
            Response response2 = response.build();
            return response2;
        }
        catch (APIExportException e) {
            log.error((Object)"APIExportException occurred while exporting ", (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).type("application/json").build();
            return response;
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/import-api")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response importAPI(@Multipart(value="file") InputStream uploadedInputStream, @QueryParam(value="preserveProvider") String defaultProviderStatus, @Context HttpHeaders httpHeaders) {
        Response response;
        boolean isProviderPreserved = true;
        boolean isTenantFlowStarted = false;
        if ("FALSE".equalsIgnoreCase(defaultProviderStatus)) {
            isProviderPreserved = false;
        }
        try {
            Response authorizationResponse = AuthenticatorUtil.authorizeUser((HttpHeaders)httpHeaders);
            if (Response.Status.OK.getStatusCode() != authorizationResponse.getStatus()) {
                Response response2 = authorizationResponse;
                return response2;
            }
            AuthenticationContext authenticationContext = (AuthenticationContext)authorizationResponse.getEntity();
            String tenantDomain = MultitenantUtils.getTenantDomain((String)authenticationContext.getUsername());
            String currentUser = authenticationContext.getDomainAwareUsername();
            if (!tenantDomain.equals("carbon.super")) {
                currentUser = currentUser + "@" + tenantDomain;
            }
            APIImportUtil.initializeProvider((String)currentUser);
            String currentDirectory = System.getProperty("java.io.tmpdir");
            String createdFolders = File.separator + RandomStringUtils.randomAlphanumeric((int)5) + File.separator;
            File importFolder = new File(currentDirectory + createdFolders);
            boolean folderCreateStatus = importFolder.mkdirs();
            if (folderCreateStatus) {
                String extractedFolderName;
                String uploadFileName = "APIArchive.zip";
                String absolutePath = currentDirectory + createdFolders;
                APIImportUtil.transferFile((InputStream)uploadedInputStream, (String)uploadFileName, (String)absolutePath);
                try {
                    extractedFolderName = APIImportUtil.extractArchive((File)new File(absolutePath + uploadFileName), (String)absolutePath);
                }
                catch (APIImportException e) {
                    Response response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                    if (isTenantFlowStarted) {
                        PrivilegedCarbonContext.endTenantFlow();
                    }
                    return response3;
                }
                if (tenantDomain != null && !"carbon.super".equals(tenantDomain)) {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
                    isTenantFlowStarted = true;
                }
                APIImportUtil.importAPI((String)(absolutePath + extractedFolderName), (String)currentUser, (boolean)isProviderPreserved);
                importFolder.deleteOnExit();
                Response response4 = Response.status((Response.Status)Response.Status.CREATED).entity((Object)"API imported successfully.\n").build();
                return response4;
            }
            Response response5 = Response.serverError().entity((Object)"Failed to create temporary directory.\n").build();
            return response5;
        }
        catch (APIExportException e) {
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error in initializing API provider.\n").build();
            return response;
        }
        catch (APIImportException e) {
            response = Response.serverError().entity((Object)e.getMessage()).build();
            return response;
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{apiID}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response updateAPI(@Multipart(value="file") InputStream uploadedInputStream, @PathParam(value="apiID") String apiID, @QueryParam(value="preserveProvider") String defaultProviderStatus, @Context HttpHeaders httpHeaders) {
        Response response;
        boolean isTenantFlowStarted = false;
        boolean isProviderPreserved = true;
        if ("FALSE".equalsIgnoreCase(defaultProviderStatus)) {
            isProviderPreserved = false;
        }
        try {
            Response authorizationResponse = AuthenticatorUtil.authorizeUser((HttpHeaders)httpHeaders);
            if (Response.Status.OK.getStatusCode() != authorizationResponse.getStatus()) {
                Response response2 = authorizationResponse;
                return response2;
            }
            AuthenticationContext authenticationContext = (AuthenticationContext)authorizationResponse.getEntity();
            String tenantDomain = MultitenantUtils.getTenantDomain((String)authenticationContext.getUsername());
            String currentUser = authenticationContext.getDomainAwareUsername();
            if (!"carbon.super".equals(tenantDomain)) {
                currentUser = currentUser + "@" + tenantDomain;
            }
            APIImportUtil.initializeProvider((String)currentUser);
            String currentDirectory = System.getProperty("java.io.tmpdir");
            String createdDirectories = File.separator + RandomStringUtils.randomAlphanumeric((int)5) + File.separator;
            File importDirectory = new File(currentDirectory + createdDirectories);
            boolean isImportDirectoryCreated = importDirectory.mkdirs();
            if (isImportDirectoryCreated) {
                String extractedDirName;
                String uploadFileName = "APIArchive.zip";
                String absolutePath = currentDirectory + createdDirectories;
                APIImportUtil.transferFile((InputStream)uploadedInputStream, (String)uploadFileName, (String)absolutePath);
                try {
                    extractedDirName = APIImportUtil.extractArchive((File)new File(absolutePath + uploadFileName), (String)absolutePath);
                }
                catch (APIImportException e) {
                    Response response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                    if (isTenantFlowStarted) {
                        PrivilegedCarbonContext.endTenantFlow();
                    }
                    return response3;
                }
                if (!"carbon.super".equals(tenantDomain)) {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
                    isTenantFlowStarted = true;
                }
                APIImportUtil.updateAPI((String)apiID, (String)(absolutePath + extractedDirName), (String)currentUser, (boolean)isProviderPreserved);
                importDirectory.deleteOnExit();
                Response response4 = Response.status((Response.Status)Response.Status.CREATED).entity((Object)"API updated successfully.").build();
                return response4;
            }
            Response response5 = Response.serverError().entity((Object)"Failed to create temporary directory.").build();
            return response5;
        }
        catch (APIExportException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error in initializing API provider.").build();
            return response;
        }
        catch (APIImportException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            response = Response.serverError().entity((Object)e.getMessage()).build();
            return response;
        }
        finally {
            if (isTenantFlowStarted) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }
}

