/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.importexport.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.dto.CertificateMetadataDTO;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.Documentation;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.APIManagerFactory;
import org.wso2.carbon.apimgt.impl.definitions.APIDefinitionFromOpenAPISpec;
import org.wso2.carbon.apimgt.impl.dto.UserRegistrationConfigDTO;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.impl.utils.SelfSignUpUtil;
import org.wso2.carbon.apimgt.importexport.APIExportException;
import org.wso2.carbon.apimgt.importexport.APIImportExportConstants;
import org.wso2.carbon.apimgt.importexport.CertificateDetail;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.governance.lcm.util.CommonUtil;
import org.wso2.carbon.registry.api.Collection;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class APIExportUtil {
    private static final Log log = LogFactory.getLog(APIExportUtil.class);
    private static String archiveBasePath = null;

    private APIExportUtil() {
    }

    public static void setArchiveBasePath(String path) {
        archiveBasePath = path;
    }

    public static APIProvider getProvider(String userName) throws APIExportException {
        try {
            APIProvider provider = APIManagerFactory.getInstance().getAPIProvider(userName);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Current provider retrieved successfully");
            }
            int tenantId = APIUtil.getTenantId((String)userName);
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            RegistryService registryService = (RegistryService)carbonContext.getOSGiService(RegistryService.class, null);
            CommonUtil.addDefaultLifecyclesIfNotAvailable((Registry)registryService.getConfigSystemRegistry(tenantId), (Registry)CommonUtil.getRootSystemRegistry((int)tenantId));
            return provider;
        }
        catch (APIManagementException e) {
            String errorMessage = "Error while retrieving provider";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String errorMessage = "Error while loading logged in user's tenant registry";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (FileNotFoundException e) {
            String errorMessage = "Error while loading logged in user's tenant registry";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            String errorMessage = "Error while loading logged in user's tenant registry";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
    }

    public static org.wso2.carbon.registry.api.Registry getRegistry() {
        org.wso2.carbon.registry.api.Registry registry = CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registry of logged in user retrieved successfully");
        }
        return registry;
    }

    public static Response retrieveApiToExport(APIIdentifier apiID, String userName) throws APIExportException {
        String wsdlUrl;
        List docList;
        API apiToReturn;
        String archivePath = archiveBasePath.concat(File.separator + apiID.getApiName() + "-" + apiID.getVersion());
        APIProvider provider = APIExportUtil.getProvider((String)userName);
        org.wso2.carbon.registry.api.Registry registry = APIExportUtil.getRegistry();
        int tenantId = APIUtil.getTenantId((String)userName);
        APIExportUtil.createDirectory((String)archivePath);
        try {
            apiToReturn = provider.getAPI(apiID);
        }
        catch (APIManagementException e) {
            String errorMessage = "Unable to retrieve API";
            log.error((Object)errorMessage, (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)errorMessage).type("application/json").build();
        }
        APIExportUtil.exportAPIThumbnail((APIIdentifier)apiID, (org.wso2.carbon.registry.api.Registry)registry);
        try {
            docList = provider.getAllDocumentation(apiID, userName);
        }
        catch (APIManagementException e) {
            String errorMessage = "Unable to retrieve API Documentation";
            log.error((Object)errorMessage, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Internal Server Error").type("application/json").build();
        }
        if (!docList.isEmpty()) {
            APIExportUtil.exportAPIDocumentation((List)docList, (APIIdentifier)apiID, (org.wso2.carbon.registry.api.Registry)registry);
        }
        if ((wsdlUrl = apiToReturn.getWsdlUrl()) != null) {
            APIExportUtil.exportWSDL((APIIdentifier)apiID, (org.wso2.carbon.registry.api.Registry)registry);
        }
        APIExportUtil.exportSequences((API)apiToReturn, (APIIdentifier)apiID, (org.wso2.carbon.registry.api.Registry)registry);
        apiToReturn.setStatus("CREATED");
        APIExportUtil.exportMetaInformation((API)apiToReturn, (org.wso2.carbon.registry.api.Registry)registry);
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportAPIThumbnail(APIIdentifier apiIdentifier, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        String thumbnailUrl = "/apimgt/applicationdata/icons/" + apiIdentifier.getProviderName() + "/" + apiIdentifier.getApiName() + "/" + apiIdentifier.getVersion() + "/" + "icon";
        InputStream imageDataStream = null;
        FileOutputStream outputStream = null;
        String archivePath = archiveBasePath.concat(File.separator + apiIdentifier.getApiName() + '-' + apiIdentifier.getVersion());
        try {
            if (registry.resourceExists(thumbnailUrl)) {
                Resource icon = registry.get(thumbnailUrl);
                imageDataStream = icon.getContentStream();
                String mediaType = icon.getMediaType();
                String extension = APIExportUtil.getThumbnailFileType((String)mediaType);
                if (extension != null) {
                    APIExportUtil.createDirectory((String)(archivePath + File.separator + "Image"));
                    outputStream = new FileOutputStream(archivePath + File.separator + "Image" + File.separator + "icon." + extension);
                    IOUtils.copy((InputStream)imageDataStream, (OutputStream)outputStream);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Thumbnail image retrieved successfully");
                    }
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"I/O error while writing API Thumbnail to file", (Throwable)e);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retrieving API Thumbnail ", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(imageDataStream);
            IOUtils.closeQuietly(outputStream);
        }
    }

    private static String getThumbnailFileType(String mediaType) {
        if ("image/png".equals(mediaType)) {
            return "png";
        }
        if ("image/jpg".equals(mediaType)) {
            return "jpg";
        }
        if ("image/jpeg".equals(mediaType)) {
            return "jpeg";
        }
        if ("image/bmp".equals(mediaType)) {
            return "bmp";
        }
        if ("image/gif".equals(mediaType)) {
            return "gif";
        }
        log.error((Object)("Unsupported media type for icon " + mediaType));
        return null;
    }

    public static void exportAPIDocumentation(List<Documentation> docList, APIIdentifier apiIdentifier, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String archivePath = archiveBasePath.concat(File.separator + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion());
        APIExportUtil.createDirectory((String)(archivePath + File.separator + "Docs"));
        InputStream fileInputStream = null;
        FileOutputStream outputStream = null;
        try {
            for (Documentation doc : docList) {
                String sourceType = doc.getSourceType().name();
                if (Documentation.DocumentSourceType.FILE.toString().equalsIgnoreCase(sourceType)) {
                    String fileName = doc.getFilePath().substring(doc.getFilePath().lastIndexOf("/") + 1);
                    String filePath = APIUtil.getDocumentationFilePath((APIIdentifier)apiIdentifier, (String)fileName);
                    Resource docFile = registry.get(filePath);
                    String localDirectoryPath = File.separator + "Docs" + File.separator + "FileContents";
                    APIExportUtil.createDirectory((String)(archivePath + File.separator + localDirectoryPath));
                    String localFilePath = localDirectoryPath + File.separator + fileName;
                    outputStream = new FileOutputStream(archivePath + localFilePath);
                    fileInputStream = docFile.getContentStream();
                    IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
                    doc.setFilePath(fileName);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)(fileName + " retrieved successfully"));
                    continue;
                }
                if (!Documentation.DocumentSourceType.INLINE.toString().equalsIgnoreCase(sourceType)) continue;
                APIExportUtil.createDirectory((String)(archivePath + File.separator + "Docs" + File.separator + "InlineContents"));
                String contentPath = APIUtil.getAPIDocPath((APIIdentifier)apiIdentifier) + "/" + "contents" + "/" + doc.getName();
                Resource docFile = registry.get(contentPath);
                String localFilePath = File.separator + "Docs" + File.separator + "InlineContents" + File.separator + doc.getName();
                outputStream = new FileOutputStream(archivePath + localFilePath);
                fileInputStream = docFile.getContentStream();
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
            }
            String json = gson.toJson(docList);
            APIExportUtil.writeFile((String)(archivePath + APIImportExportConstants.DOCUMENT_FILE_LOCATION), (String)json);
            if (log.isDebugEnabled()) {
                log.debug((Object)"API Documentation retrieved successfully");
            }
        }
        catch (IOException e) {
            String errorMessage = "I/O error while writing API documentation to file";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (RegistryException e) {
            String errorMessage = "Error while retrieving documentation ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
            IOUtils.closeQuietly(outputStream);
        }
    }

    public static void exportWSDL(APIIdentifier apiIdentifier, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        InputStream wsdlStream = null;
        FileOutputStream outputStream = null;
        String archivePath = archiveBasePath.concat("/" + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion());
        try {
            String wsdlPath = "/apimgt/applicationdata/wsdls/" + apiIdentifier.getProviderName() + "--" + apiIdentifier.getApiName() + apiIdentifier.getVersion() + ".wsdl";
            if (registry.resourceExists(wsdlPath)) {
                APIExportUtil.createDirectory((String)(archivePath + File.separator + "WSDL"));
                Resource wsdl = registry.get(wsdlPath);
                wsdlStream = wsdl.getContentStream();
                outputStream = new FileOutputStream(archivePath + File.separator + "WSDL" + File.separator + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion() + ".wsdl");
                IOUtils.copy((InputStream)wsdlStream, (OutputStream)outputStream);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"WSDL file retrieved successfully");
                }
            }
        }
        catch (IOException e) {
            String errorMessage = "I/O error while writing WSDL to file";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (RegistryException e) {
            String errorMessage = "Error while retrieving WSDL ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(wsdlStream);
            IOUtils.closeQuietly(outputStream);
        }
    }

    public static void exportSequences(API api, APIIdentifier apiIdentifier, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        HashMap<String, String> sequences = new HashMap<String, String>();
        if (api.getInSequence() != null) {
            sequences.put("in", api.getInSequence());
        }
        if (api.getOutSequence() != null) {
            sequences.put("out", api.getOutSequence());
        }
        if (api.getFaultSequence() != null) {
            sequences.put("fault", api.getFaultSequence());
        }
        if (!sequences.isEmpty()) {
            String archivePath = archiveBasePath.concat(File.separator + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion());
            APIExportUtil.createDirectory((String)(archivePath + File.separator + "Sequences"));
            for (Map.Entry sequence : sequences.entrySet()) {
                AbstractMap.SimpleEntry sequenceDetails;
                String sequenceName = (String)sequence.getValue();
                String direction = (String)sequence.getKey();
                if (sequenceName == null) continue;
                if ("in".equalsIgnoreCase(direction)) {
                    sequenceDetails = APIExportUtil.getCustomSequence((String)sequenceName, (String)"in", (org.wso2.carbon.registry.api.Registry)registry);
                    if (sequenceDetails == null) {
                        sequenceDetails = APIExportUtil.getAPISpecificSequence((APIIdentifier)api.getId(), (String)sequenceName, (String)"in", (org.wso2.carbon.registry.api.Registry)registry);
                        APIExportUtil.writeAPISpecificSequenceToFile((AbstractMap.SimpleEntry)sequenceDetails, (String)"in", (APIIdentifier)apiIdentifier);
                        continue;
                    }
                    APIExportUtil.writeSequenceToFile((AbstractMap.SimpleEntry)sequenceDetails, (String)"in", (APIIdentifier)apiIdentifier);
                    continue;
                }
                if ("out".equalsIgnoreCase(direction)) {
                    sequenceDetails = APIExportUtil.getCustomSequence((String)sequenceName, (String)"out", (org.wso2.carbon.registry.api.Registry)registry);
                    if (sequenceDetails == null) {
                        sequenceDetails = APIExportUtil.getAPISpecificSequence((APIIdentifier)api.getId(), (String)sequenceName, (String)"out", (org.wso2.carbon.registry.api.Registry)registry);
                        APIExportUtil.writeAPISpecificSequenceToFile((AbstractMap.SimpleEntry)sequenceDetails, (String)"out", (APIIdentifier)apiIdentifier);
                        continue;
                    }
                    APIExportUtil.writeSequenceToFile((AbstractMap.SimpleEntry)sequenceDetails, (String)"out", (APIIdentifier)apiIdentifier);
                    continue;
                }
                sequenceDetails = APIExportUtil.getCustomSequence((String)sequenceName, (String)"fault", (org.wso2.carbon.registry.api.Registry)registry);
                if (sequenceDetails == null) {
                    sequenceDetails = APIExportUtil.getAPISpecificSequence((APIIdentifier)api.getId(), (String)sequenceName, (String)"fault", (org.wso2.carbon.registry.api.Registry)registry);
                    APIExportUtil.writeAPISpecificSequenceToFile((AbstractMap.SimpleEntry)sequenceDetails, (String)"fault", (APIIdentifier)apiIdentifier);
                    continue;
                }
                APIExportUtil.writeSequenceToFile((AbstractMap.SimpleEntry)sequenceDetails, (String)"fault", (APIIdentifier)apiIdentifier);
            }
        }
    }

    private static AbstractMap.SimpleEntry<String, OMElement> getCustomSequence(String sequenceName, String type, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        Collection seqCollection = null;
        try {
            if ("in".equals(type)) {
                seqCollection = (Collection)registry.get("/apimgt/customsequences/in/");
            } else if ("out".equals(type)) {
                seqCollection = (Collection)registry.get("/apimgt/customsequences/out/");
            } else if ("fault".equals(type)) {
                seqCollection = (Collection)registry.get("/apimgt/customsequences/fault/");
            }
            if (seqCollection != null) {
                String[] childPaths;
                for (String childPath : childPaths = seqCollection.getChildren()) {
                    Resource sequence = registry.get(childPath);
                    OMElement seqElment = APIUtil.buildOMElement((InputStream)sequence.getContentStream());
                    if (!sequenceName.equals(seqElment.getAttributeValue(new QName("name")))) continue;
                    String sequenceFileName = sequence.getPath().substring(sequence.getPath().lastIndexOf("/"));
                    AbstractMap.SimpleEntry<String, OMElement> sequenceDetails = new AbstractMap.SimpleEntry<String, OMElement>(sequenceFileName, seqElment);
                    return sequenceDetails;
                }
            }
        }
        catch (RegistryException e) {
            String errorMessage = "Error while retrieving sequence from the registry ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (Exception e) {
            String errorMessage = "Error while reading sequence content ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        return null;
    }

    private static AbstractMap.SimpleEntry<String, OMElement> getAPISpecificSequence(APIIdentifier api, String sequenceName, String type, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        String regPath = "/apimgt/applicationdata/provider/" + api.getProviderName() + "/" + api.getApiName() + "/" + api.getVersion() + "/" + type;
        try {
            Collection seqCollection = (Collection)registry.get(regPath);
            if (seqCollection != null) {
                String[] childPaths;
                for (String childPath : childPaths = seqCollection.getChildren()) {
                    Resource sequence = registry.get(childPath);
                    OMElement seqElment = APIUtil.buildOMElement((InputStream)sequence.getContentStream());
                    if (!sequenceName.equals(seqElment.getAttributeValue(new QName("name")))) continue;
                    String sequenceFileName = sequence.getPath().substring(sequence.getPath().lastIndexOf("/"));
                    AbstractMap.SimpleEntry<String, OMElement> sequenceDetails = new AbstractMap.SimpleEntry<String, OMElement>(sequenceFileName, seqElment);
                    return sequenceDetails;
                }
            }
        }
        catch (RegistryException e) {
            String errorMessage = "Error while retrieving sequence from the registry ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        catch (Exception e) {
            String errorMessage = "Error while reading sequence content ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeSequenceToFile(AbstractMap.SimpleEntry<String, OMElement> sequenceDetails, String direction, APIIdentifier apiIdentifier) throws APIExportException {
        FileOutputStream outputStream = null;
        String archivePath = archiveBasePath.concat(File.separator + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion()) + File.separator + "Sequences" + File.separator;
        String pathToExportedSequence = archivePath + direction + "-sequence" + File.separator;
        String sequenceFileName = sequenceDetails.getKey();
        OMElement sequenceConfig = sequenceDetails.getValue();
        String exportedSequenceFile = pathToExportedSequence + sequenceFileName;
        try {
            APIExportUtil.createDirectory((String)pathToExportedSequence);
            outputStream = new FileOutputStream(exportedSequenceFile);
            sequenceConfig.serialize((OutputStream)outputStream);
            if (log.isDebugEnabled()) {
                log.debug((Object)(sequenceFileName + " retrieved successfully"));
            }
        }
        catch (FileNotFoundException e) {
            try {
                String errorMessage = "Unable to find file: " + exportedSequenceFile;
                log.error((Object)errorMessage, (Throwable)e);
                throw new APIExportException(errorMessage, (Throwable)e);
                catch (XMLStreamException e2) {
                    errorMessage = "Error while processing XML stream ";
                    log.error((Object)errorMessage, (Throwable)e2);
                    throw new APIExportException(errorMessage, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeAPISpecificSequenceToFile(AbstractMap.SimpleEntry<String, OMElement> sequenceDetails, String direction, APIIdentifier apiIdentifier) throws APIExportException {
        FileOutputStream outputStream = null;
        String archivePath = archiveBasePath.concat(File.separator + apiIdentifier.getApiName() + "-" + apiIdentifier.getVersion()) + File.separator + "Sequences" + File.separator;
        String pathToExportedSequence = archivePath + direction + "-sequence" + File.separator + "Custom";
        String sequenceFileName = sequenceDetails.getKey();
        OMElement sequenceConfig = sequenceDetails.getValue();
        String exportedSequenceFile = pathToExportedSequence + sequenceFileName;
        try {
            APIExportUtil.createDirectory((String)pathToExportedSequence);
            outputStream = new FileOutputStream(exportedSequenceFile);
            sequenceConfig.serialize((OutputStream)outputStream);
            if (log.isDebugEnabled()) {
                log.debug((Object)(sequenceFileName + " retrieved successfully"));
            }
        }
        catch (FileNotFoundException e) {
            try {
                String errorMessage = "Unable to find file: " + exportedSequenceFile;
                log.error((Object)errorMessage, (Throwable)e);
                throw new APIExportException(errorMessage, (Throwable)e);
                catch (XMLStreamException e2) {
                    errorMessage = "Error while processing XML stream ";
                    log.error((Object)errorMessage, (Throwable)e2);
                    throw new APIExportException(errorMessage, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public static void createDirectory(String path) throws APIExportException {
        File file;
        if (path != null && !(file = new File(path)).exists() && !file.mkdirs()) {
            String errorMessage = "Error while creating directory : " + path;
            log.error((Object)errorMessage);
            throw new APIExportException(errorMessage);
        }
    }

    private static void exportMetaInformation(API apiToReturn, org.wso2.carbon.registry.api.Registry registry) throws APIExportException {
        APIDefinitionFromOpenAPISpec definitionFromOpenAPISpec = new APIDefinitionFromOpenAPISpec();
        String archivePath = archiveBasePath.concat(File.separator + apiToReturn.getId().getApiName() + "-" + apiToReturn.getId().getVersion());
        APIExportUtil.createDirectory((String)(archivePath + File.separator + "Meta-information"));
        APIExportUtil.cleanApiDataToExport((API)apiToReturn);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String apiInJson = gson.toJson((Object)apiToReturn);
        APIExportUtil.writeFile((String)(archivePath + File.separator + "Meta-information" + File.separator + "api.json"), (String)apiInJson);
        try {
            if (!APIConstants.APIType.WS.toString().equalsIgnoreCase(apiToReturn.getType())) {
                String swaggerDefinition = definitionFromOpenAPISpec.getAPIDefinition(apiToReturn.getId(), registry);
                JsonParser parser = new JsonParser();
                JsonObject json = parser.parse(swaggerDefinition).getAsJsonObject();
                String formattedSwaggerJson = gson.toJson((JsonElement)json);
                APIExportUtil.writeFile((String)(archivePath + File.separator + "Meta-information" + File.separator + "swagger.json"), (String)formattedSwaggerJson);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Meta information retrieved successfully");
                }
            }
        }
        catch (APIManagementException e) {
            String errorMessage = "Error while retrieving Swagger definition";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
    }

    private static void cleanApiDataToExport(API api) {
        api.setThumbnailUrl(null);
        api.setWsdlUrl(null);
        api.setScopes(new TreeSet());
        if (api.getEndpointUTPassword() != null) {
            api.setEndpointUTPassword("");
        }
    }

    private static void writeFile(String path, String content) throws APIExportException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(path);
            IOUtils.copy((Reader)new StringReader(content), (Writer)writer);
        }
        catch (IOException e) {
            try {
                String errorMessage = "I/O error while writing to file";
                log.error((Object)errorMessage, (Throwable)e);
                throw new APIExportException(errorMessage, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    public static Boolean isCrossTenantAccessPermissionsViolated(String apiDomain, String username) throws APIExportException {
        boolean isSuperAdminRoleNameExist;
        String superTenantDomain;
        String superAdminRole;
        String resourceRquesterDomain = MultitenantUtils.getTenantDomain((String)username);
        if (resourceRquesterDomain.equals(apiDomain)) {
            return false;
        }
        try {
            superAdminRole = ServiceReferenceHolder.getInstance().getRealmService().getTenantUserRealm(-1234).getRealmConfiguration().getAdminRoleName();
        }
        catch (UserStoreException e) {
            String errorMsg = "Error in getting super admin role name";
            throw new APIExportException(errorMsg, (Throwable)e);
        }
        try {
            superTenantDomain = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getSuperTenantDomain();
        }
        catch (UserStoreException e) {
            String errorMsg = "Error in getting the super tenant domain";
            throw new APIExportException(errorMsg, (Throwable)e);
        }
        boolean isSuperTenantUser = resourceRquesterDomain.equals(superTenantDomain);
        if (!isSuperTenantUser) {
            return true;
        }
        try {
            isSuperAdminRoleNameExist = APIExportUtil.isUserInRole((String)username, (String)superAdminRole);
        }
        catch (UserStoreException e) {
            String errorMsg = "Error in checking whether the user" + username + " has admin role";
            throw new APIExportException(errorMsg, (Throwable)e);
        }
        catch (APIManagementException e) {
            String errorMsg = "Error in checking whether the user" + username + " has admin role";
            throw new APIExportException(errorMsg, (Throwable)e);
        }
        return !isSuperAdminRoleNameExist;
    }

    public static boolean isUserInRole(String user, String role) throws UserStoreException, APIManagementException {
        String tenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)user));
        UserRegistrationConfigDTO signupConfig = SelfSignUpUtil.getSignupConfiguration((String)tenantDomain);
        user = SelfSignUpUtil.getDomainSpecificUserName((String)user, (UserRegistrationConfigDTO)signupConfig);
        String tenantAwareUserName = MultitenantUtils.getTenantAwareUsername((String)user);
        RealmService realmService = ServiceReferenceHolder.getInstance().getRealmService();
        int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
        UserRealm realm = (UserRealm)realmService.getTenantUserRealm(tenantId);
        UserStoreManager manager = realm.getUserStoreManager();
        AbstractUserStoreManager abstractManager = (AbstractUserStoreManager)manager;
        return abstractManager.isUserInRole(tenantAwareUserName, role);
    }

    private static void exportEndpointCertificates(API api, int tenantid, APIProvider apiprovider) throws APIExportException {
        String archivePath = archiveBasePath.concat(File.separator + api.getId().getApiName() + "-" + api.getId().getVersion());
        APIExportUtil.createDirectory((String)(archivePath + File.separator + "Meta-information"));
        JSONObject endpointConfig = null;
        JSONTokener tokener = new JSONTokener(api.getEndpointConfig());
        HashSet uniqueHostNames = new HashSet();
        ArrayList endpointCertificatesDetails = new ArrayList();
        try {
            endpointConfig = new JSONObject(tokener);
            List productionHostNames = APIExportUtil.getHostNames((JSONObject)endpointConfig, (String)"production_endpoints", (String)api.getId().getApiName());
            List sandboxEndpoints = APIExportUtil.getHostNames((JSONObject)endpointConfig, (String)"sandbox_endpoints", (String)api.getId().getApiName());
            uniqueHostNames.addAll(productionHostNames);
            uniqueHostNames.addAll(sandboxEndpoints);
            for (String hostname : uniqueHostNames) {
                List list = APIExportUtil.getCertificateContentAndMetaData((int)tenantid, (String)hostname, (APIProvider)apiprovider);
                endpointCertificatesDetails.addAll(list);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String element = gson.toJson(endpointCertificatesDetails, new /* Unavailable Anonymous Inner Class!! */.getType());
            APIExportUtil.writeFile((String)(archivePath + File.separator + "Meta-information" + File.separator + "endpoint_certificates.json"), (String)element);
        }
        catch (JSONException e) {
            String errorMsg = "Error in converting Endpoint config to JSON object in API [" + api.getId().getApiName() + "]";
            throw new APIExportException(errorMsg, (Throwable)e);
        }
    }

    private static String getHostAddress(URL url) {
        String host = url.getHost();
        String protocol = url.getProtocol();
        int port = url.getPort();
        String address = null;
        address = port != -1 ? protocol + "://" + host + ":" + port : protocol + "://" + host;
        return address;
    }

    private static List<String> getHostNames(JSONObject endpointConfig, String type, String apiName) throws APIExportException {
        ArrayList<String> hostNames = new ArrayList<String>();
        ArrayList<String> urls = new ArrayList<String>();
        if (endpointConfig != null) {
            try {
                Object item = null;
                item = endpointConfig.get(type);
                if (item instanceof JSONArray) {
                    JSONArray endpointsJSON = new JSONArray(endpointConfig.getJSONArray(type).toString());
                    for (int i = 0; i < endpointsJSON.length(); ++i) {
                        try {
                            String urlvalue = endpointsJSON.getJSONObject(i).get("url").toString();
                            urls.add(urlvalue);
                            continue;
                        }
                        catch (JSONException ex) {
                            log.error((Object)("Endpoint URL extraction from endpoints JSON objectfailed in API[" + apiName + "]"), (Throwable)ex);
                        }
                    }
                } else if (item instanceof JSONObject) {
                    JSONObject endpointJSON = new JSONObject(endpointConfig.getJSONObject(type).toString());
                    try {
                        String urlvalue = endpointJSON.get("url").toString();
                        urls.add(urlvalue);
                    }
                    catch (JSONException ex) {
                        log.error((Object)("Endpoint URL extraction from endpoint JSON object failed in API[" + apiName + "]"), (Throwable)ex);
                    }
                }
                for (String url : urls) {
                    try {
                        URL urlObj = new URL(url);
                        String address = APIExportUtil.getHostAddress((URL)urlObj);
                        hostNames.add(address);
                    }
                    catch (MalformedURLException e) {
                        log.error((Object)("URL object creation from extracted endpoint URL [" + url + "] failed in API [" + apiName + "]"));
                    }
                }
            }
            catch (JSONException ex) {
                log.info((Object)("Endpoint type [" + type + "] not found in API [" + apiName + "]"));
            }
        }
        return hostNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CertificateDetail> getCertificateContentAndMetaData(int tenantid, String hostname, APIProvider apiProvider) throws APIExportException {
        List certificateMetadataDTOS;
        ArrayList<CertificateDetail> certificateDetails = new ArrayList<CertificateDetail>();
        try {
            certificateMetadataDTOS = apiProvider.searchCertificates(tenantid, null, hostname);
        }
        catch (APIManagementException e) {
            String errorMsg = "Error retrieving certificate meta data. tenantId [" + tenantid + "] hostname [" + hostname + "]";
            throw new APIExportException(errorMsg, (Throwable)e);
        }
        ByteArrayInputStream certificate = null;
        try {
            for (CertificateMetadataDTO metadataDTO : certificateMetadataDTOS) {
                try {
                    certificate = apiProvider.getCertificateContent(metadataDTO.getAlias());
                    certificate.close();
                    byte[] certificateContent = IOUtils.toByteArray((InputStream)certificate);
                    String encodedCertificate = new String(Base64.encodeBase64((byte[])certificateContent));
                    CertificateDetail certificateDetail = new CertificateDetail();
                    certificateDetail.setHostName(hostname);
                    certificateDetail.setAlias(metadataDTO.getAlias());
                    certificateDetail.setCertificate(encodedCertificate);
                    certificateDetails.add(certificateDetail);
                }
                catch (APIManagementException e) {
                    log.error((Object)("Error retrieving certificate content. tenantId [" + tenantid + "] hostname [" + hostname + "] Alias [" + metadataDTO.getAlias() + "]"));
                }
                catch (IOException e) {
                    log.error((Object)"Error while converting certificate content to Byte Array");
                }
            }
        }
        finally {
            if (certificate != null) {
                IOUtils.closeQuietly(certificate);
            }
        }
        return certificateDetails;
    }
}

