/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.importexport.utils;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.api.APIProvider;
import org.wso2.carbon.apimgt.api.FaultGatewaysException;
import org.wso2.carbon.apimgt.api.model.API;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.apimgt.api.model.ResourceFile;
import org.wso2.carbon.apimgt.api.model.Scope;
import org.wso2.carbon.apimgt.api.model.Tier;
import org.wso2.carbon.apimgt.api.model.URITemplate;
import org.wso2.carbon.apimgt.impl.APIConstants;
import org.wso2.carbon.apimgt.impl.definitions.APIDefinitionFromOpenAPISpec;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.importexport.APIExportException;
import org.wso2.carbon.apimgt.importexport.APIImportException;
import org.wso2.carbon.apimgt.importexport.APIImportExportConstants;
import org.wso2.carbon.apimgt.importexport.APIService;
import org.wso2.carbon.apimgt.importexport.utils.APIExportUtil;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class APIImportUtil {
    private static final Log log = LogFactory.getLog(APIService.class);
    static APIProvider provider;

    public static void initializeProvider(String currentUserName) throws APIExportException {
        provider = APIExportUtil.getProvider((String)currentUserName);
    }

    public static void transferFile(InputStream uploadedInputStream, String newFileName, String storageLocation) throws APIImportException {
        FileOutputStream outFileStream = null;
        try {
            outFileStream = new FileOutputStream(new File(storageLocation, newFileName));
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = uploadedInputStream.read(bytes)) != -1) {
                outFileStream.write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            try {
                String errorMessage = "Error in transferring files.";
                log.error((Object)errorMessage, (Throwable)e);
                throw new APIImportException(errorMessage, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outFileStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outFileStream);
    }

    public static String extractArchive(File sourceFile, String destination) throws APIImportException {
        BufferedInputStream inputStream = null;
        InputStream zipInputStream = null;
        FileOutputStream outputStream = null;
        ZipFile zip = null;
        String archiveName = null;
        try {
            zip = new ZipFile(sourceFile);
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            int index = 0;
            while (zipFileEntries.hasMoreElements()) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                if (index == 0) {
                    archiveName = currentEntry.substring(0, currentEntry.indexOf(47));
                    --index;
                }
                File destinationFile = new File(destination, currentEntry);
                File destinationParent = destinationFile.getParentFile();
                String canonicalizedDestinationFilePath = destinationFile.getCanonicalPath();
                if (!canonicalizedDestinationFilePath.startsWith(new File(destination).getCanonicalPath())) {
                    String errorMessage = "Attempt to upload invalid zip archive with file at " + currentEntry + ". File path is outside target directory";
                    log.error((Object)errorMessage);
                    throw new APIImportException(errorMessage);
                }
                if (destinationParent.mkdirs()) {
                    log.info((Object)("Creation of folder is successful. Directory Name : " + destinationParent.getName()));
                }
                if (entry.isDirectory()) continue;
                zipInputStream = zip.getInputStream(entry);
                inputStream = new BufferedInputStream(zipInputStream);
                outputStream = new FileOutputStream(destinationFile);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            String string = archiveName;
            return string;
        }
        catch (IOException e) {
            String errorMessage = "Failed to extract the archive (zip) file. ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIImportException(errorMessage, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(zipInputStream);
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
        }
    }

    public static void importAPI(String pathToArchive, String currentUser, boolean isDefaultProviderAllowed) throws APIImportException {
        Sets.SetView unsupportedTiersList;
        String errorMessage;
        Set allowedTiers;
        API importedApi = null;
        APIDefinitionFromOpenAPISpec definitionFromOpenAPISpec = new APIDefinitionFromOpenAPISpec();
        String pathToJSONFile = pathToArchive + APIImportExportConstants.JSON_FILE_LOCATION;
        try {
            List contextMatchedApis;
            String jsonContent = FileUtils.readFileToString((File)new File(pathToJSONFile));
            JsonElement configElement = new JsonParser().parse(jsonContent);
            JsonObject configObject = configElement.getAsJsonObject();
            JsonObject apiId = configObject.getAsJsonObject("id");
            String prevProvider = apiId.get("providerName").getAsString();
            String prevTenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)prevProvider));
            String currentTenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)currentUser));
            if (isDefaultProviderAllowed) {
                if (!StringUtils.equals((String)prevTenantDomain, (String)currentTenantDomain)) {
                    String errorMessage2 = "Tenant mismatch! Please enable preserveProvider property for cross tenant API Import ";
                    log.error((Object)errorMessage2);
                    throw new APIImportException(errorMessage2);
                }
                importedApi = (API)new Gson().fromJson(configElement, API.class);
            } else {
                String prevProviderWithDomain = APIUtil.replaceEmailDomain((String)prevProvider);
                String currentUserWithDomain = APIUtil.replaceEmailDomain((String)currentUser);
                apiId.addProperty("providerName", currentUserWithDomain);
                if (configObject.get("wsdlUrl") != null) {
                    configObject.addProperty("wsdlUrl", configObject.get("wsdlUrl").getAsString().replace(prevProviderWithDomain, currentUserWithDomain));
                }
                importedApi = (API)new Gson().fromJson(configElement, API.class);
                importedApi = APIImportUtil.setCurrentProviderToAPIProperties((API)importedApi, (String)currentTenantDomain, (String)prevTenantDomain);
            }
            List allMatchedApis = provider.searchAPIs(importedApi.getId().getApiName(), "Name", null);
            if (!allMatchedApis.isEmpty()) {
                for (API matchAPI : allMatchedApis) {
                    if (!matchAPI.getId().getVersion().equalsIgnoreCase(importedApi.getId().getVersion()) || !matchAPI.getId().getApiName().equalsIgnoreCase(importedApi.getId().getApiName())) continue;
                    String errorMessage3 = "Error occurred while adding the API. A duplicate API already exists for " + importedApi.getId().getApiName() + '-' + importedApi.getId().getVersion();
                    log.error((Object)errorMessage3);
                    throw new APIImportException(errorMessage3);
                }
            }
            if ((contextMatchedApis = provider.searchAPIs(importedApi.getContext(), "Context", null)).size() > 0) {
                String errMsg = "Error occurred while adding the API [" + importedApi.getId().getApiName() + '-' + importedApi.getId().getVersion() + "]. A duplicate context[" + importedApi.getContext() + "] already exists";
                log.error((Object)errMsg);
                throw new APIImportException(errMsg);
            }
        }
        catch (IOException e) {
            String errorMessage4 = "Error in reading API definition. ";
            log.error((Object)errorMessage4, (Throwable)e);
            throw new APIImportException(errorMessage4, (Throwable)e);
        }
        catch (APIManagementException e) {
            String errorMessage5 = "Error in checking API existence. ";
            log.error((Object)errorMessage5, (Throwable)e);
            throw new APIImportException(errorMessage5, (Throwable)e);
        }
        try {
            allowedTiers = provider.getTiers();
        }
        catch (APIManagementException e) {
            errorMessage = "Error in retrieving tiers of the provider. ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIImportException(errorMessage, (Throwable)e);
        }
        if (!allowedTiers.isEmpty() && !(unsupportedTiersList = Sets.difference((Set)importedApi.getAvailableTiers(), (Set)allowedTiers)).isEmpty()) {
            for (Tier unsupportedTier : unsupportedTiersList) {
                log.warn((Object)("Tier name : " + unsupportedTier.getName() + " is not supported."));
            }
            importedApi.removeAvailableTiers((Set)unsupportedTiersList);
        }
        try {
            importedApi.setAsDefaultVersion(false);
            provider.addAPI(importedApi);
            if (!APIConstants.APIType.WS.toString().equalsIgnoreCase(importedApi.getType())) {
                String swaggerContent = FileUtils.readFileToString((File)new File(pathToArchive + APIImportExportConstants.SWAGGER_DEFINITION_LOCATION));
                APIImportUtil.addSwaggerDefinition((APIIdentifier)importedApi.getId(), (String)swaggerContent);
                Set uriTemplates = definitionFromOpenAPISpec.getURITemplates(importedApi, swaggerContent);
                importedApi.setUriTemplates(uriTemplates);
                Set scopes = definitionFromOpenAPISpec.getScopes(swaggerContent);
                importedApi.setScopes(scopes);
                for (URITemplate uriTemplate : uriTemplates) {
                    Scope scope = uriTemplate.getScope();
                    if (scope == null || APIUtil.isWhiteListedScope((String)scope.getKey()) || !provider.isScopeKeyAssigned(importedApi.getId(), scope.getKey(), PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(true))) continue;
                    String errorMessage6 = "Error in adding API. Scope " + scope.getKey() + " is already assigned by another API \n";
                    log.error((Object)errorMessage6);
                    throw new APIImportException(errorMessage6);
                }
                provider.updateAPI(importedApi);
            }
        }
        catch (APIManagementException e) {
            errorMessage = "Error in adding API to the provider. ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIImportException(errorMessage, (Throwable)e);
        }
        catch (IOException e) {
            errorMessage = "Error in reading Swagger definition ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIImportException(errorMessage, (Throwable)e);
        }
        catch (FaultGatewaysException e) {
            errorMessage = "Error in updating API ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIImportException(errorMessage, (Throwable)e);
        }
        APIImportUtil.addAPIImage((String)pathToArchive, (API)importedApi);
        APIImportUtil.addAPIDocuments((String)pathToArchive, (API)importedApi);
        APIImportUtil.addAPISequences((String)pathToArchive, (API)importedApi);
        APIImportUtil.addAPISpecificSequences((String)pathToArchive, (API)importedApi);
        APIImportUtil.addAPIWsdl((String)pathToArchive, (API)importedApi);
    }

    public static void updateAPI(String apiID, String pathToArchive, String currentUser, boolean isDefaultProviderAllowed) throws APIImportException {
        Sets.SetView unsupportedTiersList;
        String errorMessage;
        Set allowedTiers;
        API importedApi;
        APIDefinitionFromOpenAPISpec definitionFromOpenAPISpec = new APIDefinitionFromOpenAPISpec();
        String pathToJSONFile = pathToArchive + APIImportExportConstants.JSON_FILE_LOCATION;
        try {
            String jsonContent = FileUtils.readFileToString((File)new File(pathToJSONFile));
            JsonElement configElement = new JsonParser().parse(jsonContent);
            JsonObject configObject = configElement.getAsJsonObject();
            JsonObject apiId = configObject.getAsJsonObject("id");
            String prevProvider = apiId.get("providerName").getAsString();
            String prevTenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)prevProvider));
            String currentTenantDomain = MultitenantUtils.getTenantDomain((String)APIUtil.replaceEmailDomainBack((String)currentUser));
            if (isDefaultProviderAllowed) {
                if (!StringUtils.equals((String)prevTenantDomain, (String)currentTenantDomain)) {
                    String errorMessage2 = "Tenant mismatch! Please enable preserveProvider property for cross tenant API Import ";
                    throw new APIImportException(errorMessage2);
                }
                importedApi = (API)new Gson().fromJson(configElement, API.class);
            } else {
                String prevProviderWithDomain = APIUtil.replaceEmailDomain((String)prevProvider);
                String currentUserWithDomain = APIUtil.replaceEmailDomain((String)currentUser);
                apiId.addProperty("providerName", currentUserWithDomain);
                if (configObject.get("wsdlUrl") != null) {
                    configObject.addProperty("wsdlUrl", configObject.get("wsdlUrl").getAsString().replace(prevProviderWithDomain, currentUserWithDomain));
                }
                importedApi = (API)new Gson().fromJson(configElement, API.class);
                APIImportUtil.setCurrentProviderToAPIProperties((API)importedApi, (String)currentTenantDomain, (String)prevTenantDomain);
            }
            API targetApi = provider.getAPIbyUUID(apiID, currentTenantDomain);
            importedApi.setStatus(targetApi.getStatus());
        }
        catch (IOException e) {
            String errorMessage3 = "Error in reading API definition. ";
            throw new APIImportException(errorMessage3, (Throwable)e);
        }
        catch (APIManagementException e) {
            String errorMessage4 = "Error in checking API existence. ";
            throw new APIImportException(errorMessage4, (Throwable)e);
        }
        try {
            allowedTiers = provider.getTiers();
        }
        catch (APIManagementException e) {
            errorMessage = "Error in retrieving tiers of the provider. ";
            throw new APIImportException(errorMessage, (Throwable)e);
        }
        if (!allowedTiers.isEmpty() && !(unsupportedTiersList = Sets.difference((Set)importedApi.getAvailableTiers(), (Set)allowedTiers)).isEmpty()) {
            for (Tier unsupportedTier : unsupportedTiersList) {
                log.warn((Object)("Tier name : " + unsupportedTier.getName() + " is not supported."));
            }
            importedApi.removeAvailableTiers((Set)unsupportedTiersList);
        }
        try {
            if (!APIConstants.APIType.WS.toString().equalsIgnoreCase(importedApi.getType())) {
                String swaggerContent = FileUtils.readFileToString((File)new File(pathToArchive + APIImportExportConstants.SWAGGER_DEFINITION_LOCATION));
                APIImportUtil.addSwaggerDefinition((APIIdentifier)importedApi.getId(), (String)swaggerContent);
                Set uriTemplates = definitionFromOpenAPISpec.getURITemplates(importedApi, swaggerContent);
                importedApi.setUriTemplates(uriTemplates);
                Set scopes = definitionFromOpenAPISpec.getScopes(swaggerContent);
                importedApi.setScopes(scopes);
                int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(true);
                for (URITemplate uriTemplate : uriTemplates) {
                    Scope scope = uriTemplate.getScope();
                    if (scope == null || APIUtil.isWhiteListedScope((String)scope.getKey()) || !provider.isScopeKeyAssigned(importedApi.getId(), scope.getKey(), tenantID)) continue;
                    String errorMessage5 = "Error in adding API. Scope " + scope.getKey() + " is already assigned by another API";
                    throw new APIImportException(errorMessage5);
                }
            }
            provider.updateAPI(importedApi);
        }
        catch (APIManagementException e) {
            errorMessage = "Error in adding API to the provider. ";
            throw new APIImportException(errorMessage, (Throwable)e);
        }
        catch (IOException e) {
            errorMessage = "Error in reading Swagger definition ";
            throw new APIImportException(errorMessage, (Throwable)e);
        }
        catch (FaultGatewaysException e) {
            errorMessage = "Error in updating API ";
            throw new APIImportException(errorMessage, (Throwable)e);
        }
        APIImportUtil.addAPIImage((String)pathToArchive, (API)importedApi);
        APIImportUtil.addAPIDocuments((String)pathToArchive, (API)importedApi);
        APIImportUtil.addAPISequences((String)pathToArchive, (API)importedApi);
        APIImportUtil.addAPISpecificSequences((String)pathToArchive, (API)importedApi);
        APIImportUtil.addAPIWsdl((String)pathToArchive, (API)importedApi);
    }

    private static API setCurrentProviderToAPIProperties(API importedApi, String currentDomain, String previousDomain) {
        if ("carbon.super".equalsIgnoreCase(currentDomain) && !"carbon.super".equalsIgnoreCase(previousDomain)) {
            importedApi.setContext(importedApi.getContext().replace("/t/" + previousDomain, ""));
            importedApi.setContextTemplate(importedApi.getContextTemplate().replace("/t/" + previousDomain, ""));
        } else if (!"carbon.super".equalsIgnoreCase(currentDomain) && "carbon.super".equalsIgnoreCase(previousDomain)) {
            importedApi.setContext("/t/" + currentDomain + importedApi.getContext());
            importedApi.setContextTemplate("/t/" + currentDomain + importedApi.getContextTemplate());
        } else if (!StringUtils.equalsIgnoreCase((String)currentDomain, (String)previousDomain)) {
            importedApi.setContext(importedApi.getContext().replace(previousDomain, currentDomain));
            importedApi.setContextTemplate(importedApi.getContextTemplate().replace(previousDomain, currentDomain));
        }
        return importedApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAPIImage(String pathToArchive, API importedApi) {
        block10: {
            File imageFolder = new File(pathToArchive + APIImportExportConstants.IMAGE_FILE_LOCATION);
            File[] fileArray = imageFolder.listFiles();
            FileInputStream inputStream = null;
            try {
                if (!imageFolder.isDirectory() || fileArray == null) break block10;
                for (File imageFile : fileArray) {
                    if (imageFile == null || !imageFile.getName().contains("icon")) continue;
                    String mimeType = URLConnection.guessContentTypeFromName(imageFile.getName());
                    inputStream = new FileInputStream(imageFile.getAbsolutePath());
                    ResourceFile apiImage = new ResourceFile((InputStream)inputStream, mimeType);
                    String thumbPath = APIUtil.getIconPath((APIIdentifier)importedApi.getId());
                    String thumbnailUrl = provider.addResourceFile(thumbPath, apiImage);
                    importedApi.setThumbnailUrl(APIUtil.prependTenantPrefix((String)thumbnailUrl, (String)importedApi.getId().getProviderName()));
                    APIUtil.setResourcePermissions((String)importedApi.getId().getProviderName(), null, null, (String)thumbPath);
                    provider.updateAPI(importedApi);
                    break;
                }
            }
            catch (FileNotFoundException e) {
                log.error((Object)"Icon for API is not found. ", (Throwable)e);
            }
            catch (APIManagementException e) {
                log.error((Object)"Failed to add icon to the API. ", (Throwable)e);
            }
            catch (FaultGatewaysException e) {
                log.error((Object)"Failed to update API after adding icon. ", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static void addAPIDocuments(String pathToArchive, API importedApi) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void addAPISequences(String pathToArchive, API importedApi) {
        String regResourcePath;
        org.wso2.carbon.registry.api.Registry registry = APIExportUtil.getRegistry();
        String inSequenceFileName = importedApi.getInSequence() + ".xml";
        String inSequenceFileLocation = pathToArchive + APIImportExportConstants.IN_SEQUENCE_LOCATION + inSequenceFileName;
        if (APIImportUtil.checkFileExistence((String)inSequenceFileLocation)) {
            regResourcePath = "/apimgt/customsequences/in/" + inSequenceFileName;
            APIImportUtil.addSequenceToRegistry((org.wso2.carbon.registry.api.Registry)registry, (String)inSequenceFileLocation, (String)regResourcePath);
        }
        String outSequenceFileName = importedApi.getOutSequence() + ".xml";
        String outSequenceFileLocation = pathToArchive + APIImportExportConstants.OUT_SEQUENCE_LOCATION + outSequenceFileName;
        if (APIImportUtil.checkFileExistence((String)outSequenceFileLocation)) {
            regResourcePath = "/apimgt/customsequences/out/" + outSequenceFileName;
            APIImportUtil.addSequenceToRegistry((org.wso2.carbon.registry.api.Registry)registry, (String)outSequenceFileLocation, (String)regResourcePath);
        }
        String faultSequenceFileName = importedApi.getFaultSequence() + ".xml";
        String faultSequenceFileLocation = pathToArchive + APIImportExportConstants.FAULT_SEQUENCE_LOCATION + faultSequenceFileName;
        if (APIImportUtil.checkFileExistence((String)faultSequenceFileLocation)) {
            regResourcePath = "/apimgt/customsequences/fault/" + faultSequenceFileName;
            APIImportUtil.addSequenceToRegistry((org.wso2.carbon.registry.api.Registry)registry, (String)faultSequenceFileLocation, (String)regResourcePath);
        }
    }

    private static void addAPISpecificSequences(String pathToArchive, API importedApi) {
        org.wso2.carbon.registry.api.Registry registry = APIExportUtil.getRegistry();
        String regResourcePath = "/apimgt/applicationdata/provider/" + importedApi.getId().getProviderName() + "/" + importedApi.getId().getApiName() + "/" + importedApi.getId().getVersion() + "/";
        String inSequenceFileName = importedApi.getInSequence();
        String inSequenceFileLocation = pathToArchive + APIImportExportConstants.IN_SEQUENCE_LOCATION + "Custom" + File.separator + inSequenceFileName;
        if (APIImportUtil.checkFileExistence((String)inSequenceFileLocation)) {
            String inSequencePath = "in/" + inSequenceFileName;
            APIImportUtil.addSequenceToRegistry((org.wso2.carbon.registry.api.Registry)registry, (String)inSequenceFileLocation, (String)(regResourcePath + inSequencePath));
        }
        String outSequenceFileName = importedApi.getOutSequence();
        String outSequenceFileLocation = pathToArchive + APIImportExportConstants.OUT_SEQUENCE_LOCATION + "Custom" + File.separator + outSequenceFileName;
        if (APIImportUtil.checkFileExistence((String)outSequenceFileLocation)) {
            String outSequencePath = "out/" + outSequenceFileName;
            APIImportUtil.addSequenceToRegistry((org.wso2.carbon.registry.api.Registry)registry, (String)outSequenceFileLocation, (String)(regResourcePath + outSequencePath));
        }
        String faultSequenceFileName = importedApi.getFaultSequence();
        String faultSequenceFileLocation = pathToArchive + APIImportExportConstants.FAULT_SEQUENCE_LOCATION + "Custom" + File.separator + faultSequenceFileName;
        if (APIImportUtil.checkFileExistence((String)faultSequenceFileLocation)) {
            String faultSequencePath = "fault/" + faultSequenceFileName;
            APIImportUtil.addSequenceToRegistry((org.wso2.carbon.registry.api.Registry)registry, (String)faultSequenceFileLocation, (String)(regResourcePath + faultSequencePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSequenceToRegistry(org.wso2.carbon.registry.api.Registry registry, String sequenceFileLocation, String regResourcePath) {
        FileInputStream seqStream = null;
        try {
            if (registry.resourceExists(regResourcePath)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Defined sequences have already been added to the registry");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Adding defined sequences to the registry.");
                }
                File sequenceFile = new File(sequenceFileLocation);
                seqStream = new FileInputStream(sequenceFile);
                byte[] inSeqData = IOUtils.toByteArray((InputStream)seqStream);
                Resource inSeqResource = (Resource)registry.newResource();
                inSeqResource.setContent((Object)inSeqData);
                registry.put(regResourcePath, (org.wso2.carbon.registry.api.Resource)inSeqResource);
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Failed to add sequences into the registry : " + regResourcePath), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("I/O error while writing sequence data to the registry : " + regResourcePath), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(seqStream);
        }
    }

    private static void addAPIWsdl(String pathToArchive, API importedApi) {
        String wsdlFileName = importedApi.getId().getApiName() + "-" + importedApi.getId().getVersion() + ".wsdl";
        String wsdlPath = pathToArchive + APIImportExportConstants.WSDL_LOCATION + wsdlFileName;
        if (APIImportUtil.checkFileExistence((String)wsdlPath)) {
            try {
                URL wsdlFileUrl = new File(wsdlPath).toURI().toURL();
                importedApi.setWsdlUrl(wsdlFileUrl.toString());
                org.wso2.carbon.registry.api.Registry registry = APIExportUtil.getRegistry();
                APIUtil.createWSDL((Registry)((Registry)registry), (API)importedApi);
                provider.updateAPI(importedApi);
            }
            catch (MalformedURLException e) {
                log.error((Object)"Error in getting WSDL URL. ", (Throwable)e);
            }
            catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
                log.error((Object)"Error in putting the WSDL resource to registry. ", (Throwable)e);
            }
            catch (APIManagementException e) {
                log.error((Object)"Error in creating the WSDL resource in the registry. ", (Throwable)e);
            }
            catch (FaultGatewaysException e) {
                log.error((Object)"Failed to update API after adding WSDL. ", (Throwable)e);
            }
        }
    }

    private static void addSwaggerDefinition(APIIdentifier apiId, String swaggerContent) throws APIImportException {
        try {
            provider.saveSwagger20Definition(apiId, swaggerContent);
        }
        catch (APIManagementException e) {
            String errorMessage = "Error in adding Swagger definition for the API. ";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIImportException(errorMessage, (Throwable)e);
        }
    }

    private static boolean checkFileExistence(String fileLocation) {
        File testFile = new File(fileLocation);
        return testFile.exists();
    }

    private static void addEndpointCertificates(String pathToArchive, API importedApi) throws APIImportException {
        String pathToJSONFile = pathToArchive + File.separator + "Meta-information" + File.separator + "endpoint_certificates.json";
        try {
            String jsonContent = FileUtils.readFileToString((File)new File(pathToJSONFile));
            JsonElement configElement = new JsonParser().parse(jsonContent);
            JsonArray certificates = configElement.getAsJsonArray().getAsJsonArray();
            for (JsonElement certificate : certificates) {
                String certificate_content = certificate.getAsJsonObject().get("certificate").getAsString();
                String alias = certificate.getAsJsonObject().get("alias").getAsString();
                String endpoint = certificate.getAsJsonObject().get("hostName").getAsString();
                try {
                    provider.addCertificate(APIUtil.replaceEmailDomainBack((String)importedApi.getId().getProviderName()), certificate_content, alias, endpoint);
                }
                catch (APIManagementException e) {
                    String errorMessage = "Error while importing certificate endpoint [" + endpoint + " ]alias [" + alias + " ] tenantuser [" + APIUtil.replaceEmailDomainBack((String)importedApi.getId().getProviderName()) + "]";
                    log.error((Object)errorMessage, (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            String errorMessage = "Error in reading endpoint_certificates.jsonfile";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIImportException(errorMessage, (Throwable)e);
        }
    }
}

