/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.importexport.utils;

import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ServiceContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.importexport.APIExportException;
import org.wso2.carbon.apimgt.importexport.utils.AuthenticationContext;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthenticatorUtil {
    private static final String AUTHORIZATION_PROPERTY = "Authorization";
    private static final String AUTHENTICATION_SCHEME = "Basic";
    private static final Log log = LogFactory.getLog(AuthenticatorUtil.class);
    private static final String APIM_ADMIN_PERMISSION = "/permission/admin/manage/apim_admin";
    private static final String APIM_LOGIN_PERMISSION = "/permission/admin/login";
    private static final String APIM_API_CREATE_PERMISSION = "/permission/admin/manage/api/create";

    private AuthenticatorUtil() {
    }

    public static Response authorizeUser(HttpHeaders headers) throws APIExportException {
        AuthenticationContext authenticationContext = AuthenticatorUtil.getAuthenticationContext((HttpHeaders)headers);
        String username = authenticationContext.getUsername();
        String password = authenticationContext.getPassword();
        if (username == null || password == null) {
            String errorMessage = "No username or password is provided for authentication";
            log.error((Object)errorMessage);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)errorMessage).type("application/json").build();
        }
        try {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
            authenticationContext.setTenantDomain(tenantDomain);
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain, true);
            APIManagerConfiguration config = ServiceReferenceHolder.getInstance().getAPIManagerConfigurationService().getAPIManagerConfiguration();
            String url = config.getFirstProperty("AuthManager.ServerURL");
            AuthenticationAdminStub authAdminStub = new AuthenticationAdminStub(null, url + "AuthenticationAdmin");
            ServiceClient client = authAdminStub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            String host = new URL(url).getHost();
            if (authAdminStub.login(username, password, host)) {
                log.info((Object)(username + " user authenticated successfully"));
                ServiceContext serviceContext = authAdminStub._getServiceClient().getLastOperationContext().getServiceContext();
                String sessionCookie = (String)serviceContext.getProperty("Cookie");
                String domainAwareUserName = APIUtil.getLoggedInUserInfo((String)sessionCookie, (String)url).getUserName();
                authenticationContext.setDomainAwareUsername(domainAwareUserName);
                UserStoreManager userstoremanager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
                String[] userRoles = userstoremanager.getRoleListOfUser(domainAwareUserName);
                String adminRoleName = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration().getAdminRoleName();
                for (String userRole : userRoles) {
                    if (!adminRoleName.equalsIgnoreCase(userRole)) continue;
                    log.info((Object)(username + " is authorized to import and export APIs"));
                    Response response = Response.ok().entity((Object)authenticationContext).build();
                    return response;
                }
                AuthorizationManager authorizationManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getAuthorizationManager();
                if (authorizationManager.isUserAuthorized(domainAwareUserName, "/permission/admin/manage/apim_admin", "ui.execute") && authorizationManager.isUserAuthorized(domainAwareUserName, "/permission/admin/login", "ui.execute") && authorizationManager.isUserAuthorized(domainAwareUserName, "/permission/admin/manage/api/create", "ui.execute")) {
                    log.info((Object)(username + " is authorized to import and export APIs"));
                    Response response = Response.ok().entity((Object)authenticationContext).build();
                    return response;
                }
                Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"User Authorization Failed").type("application/json").build();
                return response;
            }
            Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"User Authentication Failed").type("application/json").build();
            return response;
        }
        catch (Exception e) {
            String errorMessage = "Error while authenticating the user";
            log.error((Object)errorMessage, (Throwable)e);
            throw new APIExportException(errorMessage, (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private static AuthenticationContext getAuthenticationContext(HttpHeaders headers) throws APIExportException {
        AuthenticationContext authenticationContext = new AuthenticationContext();
        List authorization = headers.getRequestHeader("Authorization");
        if (authorization == null || authorization.isEmpty()) {
            return authenticationContext;
        }
        String encodedUserPassword = ((String)authorization.get(0)).replaceFirst("Basic ", "");
        String usernameAndPassword = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((byte[])encodedUserPassword.getBytes()));
        if (usernameAndPassword != null) {
            StringTokenizer tokenizer = new StringTokenizer(usernameAndPassword, ":");
            authenticationContext.setUsername(tokenizer.nextToken());
            authenticationContext.setPassword(tokenizer.nextToken());
        }
        return authenticationContext;
    }
}

