/*
 * WSO2 API Manager - Publisher API
 * This specifies a **RESTful API** for WSO2 **API Manager** - Publisher.  Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.0.4/components/apimgt/org.wso2.carbon.apimgt.rest.api.publisher/src/main/resources/publisher-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v1.0
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.carbon.apimgt.rest.integration.tests.publisher.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;

import java.io.IOException;
import java.util.Objects;

/**
 * APIDefinitionValidationResponse
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2017-09-07T02:17:03.896Z")
public class APIDefinitionValidationResponse {
  @SerializedName("isValid")
  private Boolean isValid = null;

  /**
   * This attribute declares whether this definition is a swagger or WSDL 
   */
  @JsonAdapter(DefinitionTypeEnum.Adapter.class)
  public enum DefinitionTypeEnum {
    SWAGGER("SWAGGER"),
    
    WSDL("WSDL");

    private String value;

    DefinitionTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DefinitionTypeEnum fromValue(String text) {
      for (DefinitionTypeEnum b : DefinitionTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<DefinitionTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DefinitionTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DefinitionTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return DefinitionTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("definitionType")
  private DefinitionTypeEnum definitionType = null;

  @SerializedName("wsdlInfo")
  private APIDefinitionValidationResponseWsdlInfo wsdlInfo = null;

  public APIDefinitionValidationResponse isValid(Boolean isValid) {
    this.isValid = isValid;
    return this;
  }

   /**
   * This attribute declares whether this definition is valid or not. 
   * @return isValid
  **/
  @ApiModelProperty(example = "true", required = true, value = "This attribute declares whether this definition is valid or not. ")
  public Boolean getIsValid() {
    return isValid;
  }

  public void setIsValid(Boolean isValid) {
    this.isValid = isValid;
  }

  public APIDefinitionValidationResponse definitionType(DefinitionTypeEnum definitionType) {
    this.definitionType = definitionType;
    return this;
  }

   /**
   * This attribute declares whether this definition is a swagger or WSDL 
   * @return definitionType
  **/
  @ApiModelProperty(example = "WSDL", value = "This attribute declares whether this definition is a swagger or WSDL ")
  public DefinitionTypeEnum getDefinitionType() {
    return definitionType;
  }

  public void setDefinitionType(DefinitionTypeEnum definitionType) {
    this.definitionType = definitionType;
  }

  public APIDefinitionValidationResponse wsdlInfo(APIDefinitionValidationResponseWsdlInfo wsdlInfo) {
    this.wsdlInfo = wsdlInfo;
    return this;
  }

   /**
   * Get wsdlInfo
   * @return wsdlInfo
  **/
  @ApiModelProperty(value = "")
  public APIDefinitionValidationResponseWsdlInfo getWsdlInfo() {
    return wsdlInfo;
  }

  public void setWsdlInfo(APIDefinitionValidationResponseWsdlInfo wsdlInfo) {
    this.wsdlInfo = wsdlInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    APIDefinitionValidationResponse apIDefinitionValidationResponse = (APIDefinitionValidationResponse) o;
    return Objects.equals(this.isValid, apIDefinitionValidationResponse.isValid) &&
        Objects.equals(this.definitionType, apIDefinitionValidationResponse.definitionType) &&
        Objects.equals(this.wsdlInfo, apIDefinitionValidationResponse.wsdlInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isValid, definitionType, wsdlInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class APIDefinitionValidationResponse {\n");
    
    sb.append("    isValid: ").append(toIndentedString(isValid)).append("\n");
    sb.append("    definitionType: ").append(toIndentedString(definitionType)).append("\n");
    sb.append("    wsdlInfo: ").append(toIndentedString(wsdlInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

