/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.api.publisher;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.rest.integration.tests.api.publisher.TestUtils;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiResponse;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APICollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APIIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.DocumentCollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.DocumentIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIBusinessInformation;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APICorsConfiguration;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIList;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.Document;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.DocumentList;

public class DocumentIndividualApiIT {
    private final DocumentIndividualApi api = new DocumentIndividualApi();
    private final DocumentCollectionApi docApi = new DocumentCollectionApi();
    private final APICollectionApi apiSetup = new APICollectionApi();
    private final APIIndividualApi apiIndividualApi = new APIIndividualApi();
    private final TestUtils testUtils = new TestUtils();
    private String APIID = null;
    private String DOCID = null;

    @BeforeClass
    public void beforeClass() throws ApiException {
        API body = new API();
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        body.setName("DocsAPII");
        body.setContext("docssi");
        body.setVersion("1.0.0");
        body.setProvider("admin");
        body.setLifeCycleStatus("CREATED");
        body.setTransport((List)new ArrayList<String>(){
            {
                this.add("http");
            }
        });
        body.setCacheTimeout(Integer.valueOf(100));
        body.setPolicies((List)new ArrayList<String>(){
            {
                this.add("Unlimited");
            }
        });
        body.setVisibility(API.VisibilityEnum.PUBLIC);
        body.setTags(new ArrayList());
        body.setVisibleRoles(new ArrayList());
        body.setVisibleTenants(new ArrayList());
        body.setSequences(new ArrayList());
        body.setBusinessInformation(new APIBusinessInformation());
        body.setCorsConfiguration(new APICorsConfiguration());
        API response = this.apiSetup.apisPost(body);
        this.APIID = response.getId();
        Document docBody = new Document();
        docBody.setName("Help");
        docBody.setType(Document.TypeEnum.HOWTO);
        docBody.setSummary("This is the summary.");
        docBody.setSourceType(Document.SourceTypeEnum.INLINE);
        docBody.setVisibility(Document.VisibilityEnum.API_LEVEL);
        Document docResponse = this.docApi.apisApiIdDocumentsPost(response.getId(), docBody, ifMatch, ifUnmodifiedSince);
        this.DOCID = docResponse.getDocumentId();
    }

    @Test(enabled=false)
    public void apisApiIdDocumentsDocumentIdContentGetTest() throws ApiException {
        String apiId = this.APIID;
        String documentId = this.DOCID;
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        this.api.apisApiIdDocumentsDocumentIdContentGet(apiId, documentId, ifNoneMatch, ifModifiedSince);
    }

    @Test
    public void apisApiIdDocumentsDocumentIdContentGet_failureTest_404_invalidDoc() throws ApiException {
        String apiId = this.APIID;
        String documentId = "invalidDocId";
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        try {
            this.api.apisApiIdDocumentsDocumentIdContentGet(apiId, documentId, ifNoneMatch, ifModifiedSince);
            assert (false);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"status code mismatch");
        }
    }

    @Test(enabled=false)
    public void apisApiIdDocumentsDocumentIdContentGet_failureTest_404_invalidApi() throws ApiException {
        String apiId = "invalidApi";
        String documentId = this.DOCID;
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        try {
            this.api.apisApiIdDocumentsDocumentIdContentGet(apiId, documentId, ifNoneMatch, ifModifiedSince);
            assert (false);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"status code mismatch");
        }
    }

    @Test
    public void apisApiIdDocumentsDocumentIdContentPostTest_INLINE() throws ApiException {
        String apiId = this.APIID;
        String documentId = this.DOCID;
        File file = null;
        String inlineContent = "The content";
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        ApiResponse response = this.api.apisApiIdDocumentsDocumentIdContentPostWithHttpInfo(apiId, documentId, file, inlineContent, ifMatch, ifUnmodifiedSince);
        Assert.assertEquals((int)response.getStatusCode(), (int)201, (String)"Status code mismatch - INLINE");
    }

    @Test
    public void apisApiIdDocumentsDocumentIdContentPostTest_FILE() throws ApiException {
        String apiId = this.APIID;
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        File file = new File(this.getClass().getResource("/file1.pdf").getFile());
        Document docBody2 = new Document();
        docBody2.setName("Help2");
        docBody2.setType(Document.TypeEnum.HOWTO);
        docBody2.setSummary("This is the summary.");
        docBody2.setSourceType(Document.SourceTypeEnum.FILE);
        docBody2.setVisibility(Document.VisibilityEnum.API_LEVEL);
        Document docResponse = this.docApi.apisApiIdDocumentsPost(apiId, docBody2, ifMatch, ifUnmodifiedSince);
        String documentId2 = docResponse.getDocumentId();
        ApiResponse response2 = this.api.apisApiIdDocumentsDocumentIdContentPostWithHttpInfo(apiId, documentId2, file, null, ifMatch, ifUnmodifiedSince);
        Assert.assertEquals((int)response2.getStatusCode(), (int)201, (String)"Status code mismatch - FILE");
    }

    @Test
    public void apisApiIdDocumentsDocumentIdContentPostTest_FILE_FailureTest_404() throws ApiException {
        String apiId = this.APIID;
        String documentId = "invalidDocID";
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        File file = new File(this.getClass().getResource("/file1.pdf").getFile());
        try {
            this.api.apisApiIdDocumentsDocumentIdContentPost(apiId, documentId, file, null, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"Status code mismatch - FILE");
        }
    }

    @Test
    public void apisApiIdDocumentsDocumentIdContentPostTest_FILE_FailureTest_400() throws ApiException {
        String apiId = this.APIID;
        String documentId = this.DOCID;
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        File file = new File(this.getClass().getResource("/img1.jpg").getFile());
        try {
            this.api.apisApiIdDocumentsDocumentIdContentPost(apiId, documentId, file, null, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)400, (String)"Status code mismatch - FILE");
        }
    }

    @Test
    public void apisApiIdDocumentsDocumentIdContentPostTest_INLINE_FailureTest_404() throws ApiException {
        String apiId = this.APIID;
        String documentId = "invalidDocID";
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        String inlineContent = "The content";
        try {
            this.api.apisApiIdDocumentsDocumentIdContentPost(apiId, documentId, null, inlineContent, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"Status code mismatch - FILE");
        }
    }

    @Test
    public void apisApiIdDocumentsDocumentIdDeleteTest() throws ApiException {
        String ifNoneMatch = null;
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        String apiId = this.testUtils.createApi("API-150", "1.0.0", "API-150");
        Document docBody = new Document();
        docBody.setName("Help");
        docBody.setType(Document.TypeEnum.HOWTO);
        docBody.setSummary("This is the summary.");
        docBody.setSourceType(Document.SourceTypeEnum.INLINE);
        docBody.setVisibility(Document.VisibilityEnum.API_LEVEL);
        Document docResponse = this.docApi.apisApiIdDocumentsPost(apiId, docBody, ifMatch, ifUnmodifiedSince);
        String documentId = docResponse.getDocumentId();
        this.api.apisApiIdDocumentsDocumentIdDelete(apiId, documentId, ifMatch, ifUnmodifiedSince);
        DocumentList response = this.docApi.apisApiIdDocumentsGet(apiId, Integer.valueOf(10), Integer.valueOf(0), ifNoneMatch);
        int documentCount = response.getCount();
        Assert.assertEquals((int)documentCount, (int)0, (String)"document count mismatch");
    }

    @Test(enabled=false)
    public void apisApiIdDocumentsDocumentIdDeleteTest_NF_invalidDocument() throws ApiException {
        String apiId = this.APIID;
        String documentId = "invalidDocID";
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        try {
            this.api.apisApiIdDocumentsDocumentIdDelete(apiId, documentId, ifMatch, ifUnmodifiedSince);
            assert (false);
        }
        catch (ApiException ae) {
            int responseCode = ae.getCode();
            Assert.assertEquals((int)responseCode, (int)404, (String)"Response code mismatch");
        }
    }

    @Test(enabled=false)
    public void apisApiIdDocumentsDocumentIdDeleteTest_NF_invalidAPI() throws ApiException {
        String apiId = "invalidApi";
        String documentId = this.DOCID;
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        try {
            this.api.apisApiIdDocumentsDocumentIdDelete(apiId, documentId, ifMatch, ifUnmodifiedSince);
            assert (false);
        }
        catch (ApiException ae) {
            int responseCode = ae.getCode();
            Assert.assertEquals((int)responseCode, (int)404, (String)"Response code mismatch");
        }
    }

    @Test
    public void apisApiIdDocumentsDocumentIdGetTest() throws ApiException {
        String apiId = this.APIID;
        String documentId = this.DOCID;
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        Document response = this.api.apisApiIdDocumentsDocumentIdGet(apiId, documentId, ifNoneMatch, ifModifiedSince);
        Assert.assertEquals((String)response.getName(), (String)"Help", (String)"Document name mismatch");
        Assert.assertEquals((String)response.getVisibility().toString(), (String)"API_LEVEL", (String)"Document visibility mismatch");
        Assert.assertEquals((String)response.getSourceType().toString(), (String)"INLINE", (String)"Document visibility mismatch");
        Assert.assertEquals((String)response.getType().toString(), (String)"HOWTO", (String)"Document visibility mismatch");
        Assert.assertEquals((String)response.getSummary().toString(), (String)"This is the summary.", (String)"Document summary mismatch");
    }

    @Test(enabled=false)
    public void apisApiIdDocumentsDocumentIdGetTest_NF() throws ApiException {
        String apiId = this.APIID;
        String documentId = "invalidDocID";
        String ifNoneMatch = null;
        String ifModifiedSince = null;
        try {
            this.api.apisApiIdDocumentsDocumentIdGet(apiId, documentId, ifNoneMatch, ifModifiedSince);
        }
        catch (ApiException ae) {
            int responseCode = ae.getCode();
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(ae.getResponseBody());
            String errorMsg = responseBody.get("message").getAsString();
            Assert.assertEquals((int)responseCode, (int)404, (String)"Response code mismatch");
            Assert.assertEquals((String)errorMsg, (String)"Documentation not found.", (String)"Response message mismatch");
        }
    }

    @Test
    public void apisApiIdDocumentsDocumentIdPutTest() throws ApiException {
        String apiId = this.APIID;
        String documentId = this.DOCID;
        Document body = new Document();
        body.setSourceType(Document.SourceTypeEnum.FILE);
        body.setType(Document.TypeEnum.SWAGGER_DOC);
        body.setVisibility(Document.VisibilityEnum.OWNER_ONLY);
        body.setSummary("Summary changed");
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        Document response = this.api.apisApiIdDocumentsDocumentIdPut(apiId, documentId, body, ifMatch, ifUnmodifiedSince);
        Assert.assertEquals((String)response.getType().toString(), (String)"SWAGGER_DOC", (String)"Type update fails");
        Assert.assertEquals((String)response.getSummary().toString(), (String)"Summary changed", (String)"Summary update fails");
        Assert.assertEquals((String)response.getSourceType().toString(), (String)"FILE", (String)"Source Type update fails");
        Assert.assertEquals((String)response.getVisibility().toString(), (String)"OWNER_ONLY", (String)"Visibility update fails");
    }

    @Test
    public void apisApiIdDocumentsDocumentIdPut_failureTest_404() throws ApiException {
        String apiId = "invalidId";
        String documentId = this.DOCID;
        Document body = new Document();
        body.setSourceType(Document.SourceTypeEnum.FILE);
        body.setType(Document.TypeEnum.SWAGGER_DOC);
        body.setVisibility(Document.VisibilityEnum.OWNER_ONLY);
        body.setSummary("Summary changed");
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        try {
            Document document = this.api.apisApiIdDocumentsDocumentIdPut(apiId, documentId, body, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)404, (String)"status code mismatch");
        }
    }

    @Test(enabled=false)
    public void apisApiIdDocumentsDocumentIdPut_failureTest_400() throws ApiException {
        String apiId = this.APIID;
        String documentId = this.DOCID;
        Document body = new Document();
        String ifMatch = null;
        String ifUnmodifiedSince = null;
        try {
            Document document = this.api.apisApiIdDocumentsDocumentIdPut(apiId, documentId, body, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException apiException) {
            int statusCode = apiException.getCode();
            Assert.assertEquals((int)statusCode, (int)400, (String)"status code mismatch");
        }
    }

    @AfterClass
    public void afterClass() throws ApiException {
        APIList response = this.apiSetup.apisGet(Integer.valueOf(10), Integer.valueOf(0), null, null);
        for (int i = 0; i < response.getCount(); ++i) {
            this.apiIndividualApi.apisApiIdDelete(((APIInfo)response.getList().get(i)).getId(), null, null);
        }
    }
}

