/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.api.publisher;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.rest.integration.tests.api.publisher.TestUtils;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APICollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APIIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.DocumentCollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIList;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.Document;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.DocumentList;

public class DocumentCollectionApiIT {
    private final DocumentCollectionApi api = new DocumentCollectionApi();
    private final APICollectionApi apiSetup = new APICollectionApi();
    private final APIIndividualApi apiIndividualApi = new APIIndividualApi();
    TestUtils testUtils = new TestUtils();

    @Test
    public void apisApiIdDocumentsGetTest() throws ApiException {
        String apiId = this.testUtils.createApi("API-141", "1.0.0", "API-141");
        Document document1 = new Document();
        String ifUnmodifiedSince = null;
        String ifMatch = null;
        document1.setName("Help1");
        document1.setType(Document.TypeEnum.SWAGGER_DOC);
        document1.setSourceType(Document.SourceTypeEnum.FILE);
        document1.setVisibility(Document.VisibilityEnum.PRIVATE);
        this.api.apisApiIdDocumentsPost(apiId, document1, ifMatch, ifUnmodifiedSince);
        Document document2 = new Document();
        document2.setName("Help2");
        document2.setType(Document.TypeEnum.PUBLIC_FORUM);
        document2.setSourceType(Document.SourceTypeEnum.INLINE);
        document2.setVisibility(Document.VisibilityEnum.OWNER_ONLY);
        this.api.apisApiIdDocumentsPost(apiId, document2, ifMatch, ifUnmodifiedSince);
        Integer limit = 10;
        Integer offset = 0;
        String ifNoneMatch = null;
        DocumentList response = this.api.apisApiIdDocumentsGet(apiId, limit, offset, ifNoneMatch);
        int count = response.getCount();
        Assert.assertEquals((int)count, (int)2, (String)"document count mismatch");
        if (((Document)response.getList().get(0)).getName().equals("Help1")) {
            Assert.assertEquals((String)((Document)response.getList().get(0)).getName(), (String)"Help1", (String)"Document name mismatch");
            Assert.assertEquals((String)((Document)response.getList().get(0)).getType().toString(), (String)"SWAGGER_DOC", (String)"");
            Assert.assertEquals((String)((Document)response.getList().get(0)).getVisibility().toString(), (String)"PRIVATE", (String)"");
            Assert.assertEquals((String)((Document)response.getList().get(0)).getSourceType().toString(), (String)"FILE", (String)"");
            Assert.assertEquals((String)((Document)response.getList().get(1)).getName(), (String)"Help2", (String)"Document name mismatch");
            Assert.assertEquals((String)((Document)response.getList().get(1)).getType().toString(), (String)"PUBLIC_FORUM", (String)"");
            Assert.assertEquals((String)((Document)response.getList().get(1)).getVisibility().toString(), (String)"OWNER_ONLY", (String)"");
            Assert.assertEquals((String)((Document)response.getList().get(1)).getSourceType().toString(), (String)"INLINE", (String)"");
        } else {
            Assert.assertEquals((String)((Document)response.getList().get(0)).getName(), (String)"Help2", (String)"Document name mismatch");
            Assert.assertEquals((String)((Document)response.getList().get(0)).getType().toString(), (String)"PUBLIC_FORUM", (String)"");
            Assert.assertEquals((String)((Document)response.getList().get(0)).getVisibility().toString(), (String)"OWNER_ONLY", (String)"");
            Assert.assertEquals((String)((Document)response.getList().get(0)).getSourceType().toString(), (String)"INLINE", (String)"");
            Assert.assertEquals((String)((Document)response.getList().get(1)).getName(), (String)"Help1", (String)"Document name mismatch");
            Assert.assertEquals((String)((Document)response.getList().get(1)).getType().toString(), (String)"SWAGGER_DOC", (String)"");
            Assert.assertEquals((String)((Document)response.getList().get(1)).getVisibility().toString(), (String)"PRIVATE", (String)"");
            Assert.assertEquals((String)((Document)response.getList().get(1)).getSourceType().toString(), (String)"FILE", (String)"");
        }
        this.testUtils.deleteApi();
    }

    @Test
    public void apisApiIdDocumentsGetTest_NF() throws ApiException {
        try {
            String apiId = "invalidId";
            Integer limit = 10;
            Integer offset = 0;
            String ifNoneMatch = null;
            DocumentList documentList = this.api.apisApiIdDocumentsGet(apiId, limit, offset, ifNoneMatch);
        }
        catch (ApiException ae) {
            int responseCode = ae.getCode();
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(ae.getResponseBody());
            String errorMsg = responseBody.get("message").getAsString();
            Assert.assertEquals((int)responseCode, (int)404, (String)"Response code mismatch");
            Assert.assertEquals((String)errorMsg, (String)"API not found", (String)"Response message mismatch");
        }
    }

    @Test
    public void apisApiIdDocumentsPostTest() throws ApiException {
        String apiId = this.testUtils.createApi("API-140", "1.0.0", "API-140");
        String ifUnmodifiedSince = null;
        String ifMatch = null;
        Document body = new Document();
        body.setName("Help");
        body.setType(Document.TypeEnum.HOWTO);
        body.setSourceType(Document.SourceTypeEnum.INLINE);
        body.setVisibility(Document.VisibilityEnum.API_LEVEL);
        Document response = this.api.apisApiIdDocumentsPost(apiId, body, ifMatch, ifUnmodifiedSince);
        Assert.assertEquals((String)response.getSourceType().toString(), (String)"INLINE", (String)"source type mismatch");
        Assert.assertEquals((String)response.getType().toString(), (String)"HOWTO", (String)"type mismatch");
        Assert.assertEquals((String)response.getVisibility().toString(), (String)"API_LEVEL", (String)"Visibility mismatch");
        Assert.assertEquals((String)response.getName(), (String)"Help", (String)"Document name mismatch");
        this.testUtils.deleteApi();
    }

    @Test(enabled=false)
    public void apisApiIdDocumentsPostTest_NF() throws ApiException {
        try {
            String apiId = this.testUtils.createApi("API-143", "1.0.0", "API-143");
            Document body = new Document();
            body.setName("Help");
            body.setVisibility(Document.VisibilityEnum.API_LEVEL);
            body.setSourceType(Document.SourceTypeEnum.INLINE);
            String ifUnmodifiedSince = null;
            String ifMatch = null;
            this.api.apisApiIdDocumentsPost(apiId, body, ifMatch, ifUnmodifiedSince);
        }
        catch (ApiException ae) {
            int responseCode = ae.getCode();
            JsonParser parser = new JsonParser();
            JsonObject responseBody = (JsonObject)parser.parse(ae.getResponseBody());
            String errorMsg = responseBody.get("message").getAsString();
            System.out.println(ae.getResponseBody());
            Assert.assertEquals((int)responseCode, (int)400, (String)"Response code mismatch");
            Assert.assertEquals((String)errorMsg, (String)"Bad Request", (String)"Response message mismatch");
        }
    }

    @AfterClass
    public void afterClass() throws ApiException {
        APIList response = this.apiSetup.apisGet(Integer.valueOf(10), Integer.valueOf(0), null, null);
        for (int i = 0; i < response.getCount(); ++i) {
            this.apiIndividualApi.apisApiIdDelete(((APIInfo)response.getList().get(i)).getId(), null, null);
        }
    }
}

