/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.publisher.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Tier {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="tierLevel")
    private TierLevelEnum tierLevel = null;
    @JsonProperty(value="attributes")
    private Map<String, String> attributes = null;
    @JsonProperty(value="requestCount")
    private Long requestCount = null;
    @JsonProperty(value="unitTime")
    private Long unitTime = null;
    @JsonProperty(value="timeUnit")
    private String timeUnit = null;
    @JsonProperty(value="tierPlan")
    private TierPlanEnum tierPlan = null;
    @JsonProperty(value="stopOnQuotaReach")
    private Boolean stopOnQuotaReach = null;

    public Tier name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Platinum", required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Tier description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Allows 50 request(s) per minute.", value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Tier tierLevel(TierLevelEnum tierLevel) {
        this.tierLevel = tierLevel;
        return this;
    }

    @ApiModelProperty(example="api", value="")
    public TierLevelEnum getTierLevel() {
        return this.tierLevel;
    }

    public void setTierLevel(TierLevelEnum tierLevel) {
        this.tierLevel = tierLevel;
    }

    public Tier attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Tier putAttributesItem(String key, String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @ApiModelProperty(example="{}", value="Custom attributes added to the policy policy ")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Tier requestCount(Long requestCount) {
        this.requestCount = requestCount;
        return this;
    }

    @ApiModelProperty(example="50", required=true, value="Maximum number of requests which can be sent within a provided unit time ")
    public Long getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(Long requestCount) {
        this.requestCount = requestCount;
    }

    public Tier unitTime(Long unitTime) {
        this.unitTime = unitTime;
        return this;
    }

    @ApiModelProperty(example="60000", required=true, value="")
    public Long getUnitTime() {
        return this.unitTime;
    }

    public void setUnitTime(Long unitTime) {
        this.unitTime = unitTime;
    }

    public Tier timeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    @ApiModelProperty(example="min", value="")
    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public Tier tierPlan(TierPlanEnum tierPlan) {
        this.tierPlan = tierPlan;
        return this;
    }

    @ApiModelProperty(example="FREE", required=true, value="This attribute declares whether this policy is available under commercial or free ")
    public TierPlanEnum getTierPlan() {
        return this.tierPlan;
    }

    public void setTierPlan(TierPlanEnum tierPlan) {
        this.tierPlan = tierPlan;
    }

    public Tier stopOnQuotaReach(Boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
        return this;
    }

    @ApiModelProperty(example="true", required=true, value="By making this attribute to false, you are capabale of sending requests even if the request count exceeded within a unit time ")
    public Boolean isStopOnQuotaReach() {
        return this.stopOnQuotaReach;
    }

    public void setStopOnQuotaReach(Boolean stopOnQuotaReach) {
        this.stopOnQuotaReach = stopOnQuotaReach;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tier tier = (Tier)o;
        return Objects.equals(this.name, tier.name) && Objects.equals(this.description, tier.description) && Objects.equals((Object)this.tierLevel, (Object)tier.tierLevel) && Objects.equals(this.attributes, tier.attributes) && Objects.equals(this.requestCount, tier.requestCount) && Objects.equals(this.unitTime, tier.unitTime) && Objects.equals(this.timeUnit, tier.timeUnit) && Objects.equals((Object)this.tierPlan, (Object)tier.tierPlan) && Objects.equals(this.stopOnQuotaReach, tier.stopOnQuotaReach);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.tierLevel, this.attributes, this.requestCount, this.unitTime, this.timeUnit, this.tierPlan, this.stopOnQuotaReach});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tier {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    tierLevel: ").append(this.toIndentedString((Object)this.tierLevel)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    requestCount: ").append(this.toIndentedString(this.requestCount)).append("\n");
        sb.append("    unitTime: ").append(this.toIndentedString(this.unitTime)).append("\n");
        sb.append("    timeUnit: ").append(this.toIndentedString(this.timeUnit)).append("\n");
        sb.append("    tierPlan: ").append(this.toIndentedString((Object)this.tierPlan)).append("\n");
        sb.append("    stopOnQuotaReach: ").append(this.toIndentedString(this.stopOnQuotaReach)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TierPlanEnum {
        FREE("FREE"),
        COMMERCIAL("COMMERCIAL");

        private String value;

        private TierPlanEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TierPlanEnum fromValue(String text) {
            for (TierPlanEnum b : TierPlanEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TierLevelEnum {
        API("api"),
        APPLICATION("application"),
        RESOURCE("resource");

        private String value;

        private TierLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TierLevelEnum fromValue(String text) {
            for (TierLevelEnum b : TierLevelEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

