/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.publisher;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.apimgt.core.models.APIStatus;
import org.wso2.carbon.apimgt.rest.integration.tests.exceptions.AMIntegrationTestException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APICollectionApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.api.APIIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.APIList;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.FileInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.store.api.SubscriptionIndividualApi;
import org.wso2.carbon.apimgt.rest.integration.tests.util.SampleTestObjectCreator;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TestUtil;

public class APILifeCycleTestCaseIT {
    private API api;
    APICollectionApi apiCollectionApi;
    APIIndividualApi apiIndividualApi;
    SubscriptionIndividualApi subscriptionIndividualApi;
    private static final Logger log = LoggerFactory.getLogger(APILifeCycleTestCaseIT.class);

    @BeforeClass
    public void init() throws AMIntegrationTestException {
        this.apiCollectionApi = (APICollectionApi)TestUtil.getPublisherApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APICollectionApi.class);
        this.apiIndividualApi = (APIIndividualApi)TestUtil.getPublisherApiClient((String)"user1", (String)TestUtil.getUser((String)"user1"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(APIIndividualApi.class);
    }

    @Test
    public void testCreateApi() {
        this.api = SampleTestObjectCreator.ApiToCreate((String)"api1-lifecycle", (String)"1.0.0", (String)"/apiLifecycle");
        this.api = this.apiCollectionApi.apisPost(this.api);
        Assert.assertNotNull((Object)this.api.getId());
    }

    @Test(dependsOnMethods={"testCreateApi"})
    public void testUpdateApi() {
        this.api.addPoliciesItem("Gold");
        this.api.addTransportItem("http");
        this.api = this.apiIndividualApi.apisApiIdPut(this.api.getId(), this.api, "", "");
    }

    @Test(dependsOnMethods={"testUpdateApi"})
    public void testUpdateImage() {
        FileInfo fileInfo = this.apiIndividualApi.apisApiIdThumbnailPost(this.api.getId(), new File(Thread.currentThread().getContextClassLoader().getResource("img1.jpg").getPath()), null, null);
        this.apiIndividualApi.apisApiIdThumbnailGet(this.api.getId(), null, null);
    }

    @Test(dependsOnMethods={"testUpdateImage"})
    public void testMakeApiProtoType() {
        this.apiIndividualApi.apisChangeLifecyclePost(APIStatus.PROTOTYPED.getStatus(), this.api.getId(), "Deprecate old versions after publish the API:false,Require re-subscription when publish the API:false", "", "");
        Assert.assertEquals((String)this.apiIndividualApi.apisApiIdGet(this.api.getId(), "", "").getLifeCycleStatus(), (String)APIStatus.PROTOTYPED.getStatus());
    }

    @Test(dependsOnMethods={"testMakeApiProtoType"})
    public void testMakeApiPublished() {
        this.apiIndividualApi.apisChangeLifecyclePost(APIStatus.PUBLISHED.getStatus(), this.api.getId(), "Deprecate old versions after publish the API:false,Require re-subscription when publish the API:false", "", "");
        Assert.assertEquals((String)this.apiIndividualApi.apisApiIdGet(this.api.getId(), "", "").getLifeCycleStatus(), (String)APIStatus.PUBLISHED.getStatus());
    }

    @Test(dependsOnMethods={"testMakeApiPublished"})
    public void testCopyApiVersion() {
        this.apiIndividualApi.apisCopyApiPost("v2.0.0", this.api.getId());
        APIList apiList = this.apiCollectionApi.apisGet(Integer.valueOf(2), Integer.valueOf(0), "name:api1-lifecycle", "");
        Assert.assertNotNull((Object)apiList);
        Assert.assertEquals((int)apiList.getCount(), (int)2);
    }

    @Test(dependsOnMethods={"testCopyApiVersion"})
    public void testMakeApiDeprecated() throws AMIntegrationTestException {
        this.apiIndividualApi.apisChangeLifecyclePost(APIStatus.DEPRECATED.getStatus(), this.api.getId(), "Deprecate old versions after publish the API:false,Require re-subscription when publish the API:false", "", "");
        Assert.assertEquals((String)this.apiIndividualApi.apisApiIdGet(this.api.getId(), "", "").getLifeCycleStatus(), (String)APIStatus.DEPRECATED.getStatus());
        org.wso2.carbon.apimgt.rest.integration.tests.store.api.APICollectionApi apiCollectionApi = (org.wso2.carbon.apimgt.rest.integration.tests.store.api.APICollectionApi)TestUtil.getStoreApiClient((String)"user4", (String)TestUtil.getUser((String)"user4"), (String)"apim:api_view apim:api_create apim:api_update apim:api_delete apim:apidef_update apim:api_publish apim:subscription_view apim:subscription_block apim:dedicated_gateway apim:external_services_discover apim:subscribe").buildClient(org.wso2.carbon.apimgt.rest.integration.tests.store.api.APICollectionApi.class);
        org.wso2.carbon.apimgt.rest.integration.tests.store.model.APIList apiList = apiCollectionApi.apisGet(Integer.valueOf(10), Integer.valueOf(0), "", "", "");
        Assert.assertNotNull((Object)apiList);
        Assert.assertNotNull((Object)apiList.getList());
        for (org.wso2.carbon.apimgt.rest.integration.tests.store.model.APIInfo apiInfo : apiList.getList()) {
            Assert.assertNotEquals((Object)this.api.getId(), (Object)apiInfo.getId());
        }
    }

    @Test(dependsOnMethods={"testMakeApiDeprecated"})
    public void testMakeApiRetired() {
        this.apiIndividualApi.apisChangeLifecyclePost(APIStatus.RETIRED.getStatus(), this.api.getId(), "Deprecate old versions after publish the API:false,Require re-subscription when publish the API:false", "", "");
    }

    @AfterClass
    public void destroy() {
        APIList apiList = this.apiCollectionApi.apisGet(Integer.valueOf(2), Integer.valueOf(0), "name:api1-lifecycle", "");
        for (APIInfo apiInfo : apiList.getList()) {
            if (!this.api.getName().equals(apiInfo.getName())) continue;
            this.apiIndividualApi.apisApiIdDelete(apiInfo.getId(), "", "");
        }
    }
}

