/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.publisher.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.EndpointConfigAttributes;

public class EndpointConfig {
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="timeout")
    private String timeout = null;
    @JsonProperty(value="isPrimary")
    private Boolean isPrimary = null;
    @JsonProperty(value="attributes")
    private List<EndpointConfigAttributes> attributes = null;

    public EndpointConfig url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="http://localhost:8280", value="Service url of the endpoint ")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public EndpointConfig timeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    @ApiModelProperty(example="1000", value="Time out of the endpoint ")
    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public EndpointConfig isPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
        return this;
    }

    @ApiModelProperty(example="true", value="Defines whether the endpoint is primary when used in fail over. ")
    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public void setIsPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public EndpointConfig attributes(List<EndpointConfigAttributes> attributes) {
        this.attributes = attributes;
        return this;
    }

    public EndpointConfig addAttributesItem(EndpointConfigAttributes attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<EndpointConfigAttributes>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<EndpointConfigAttributes> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<EndpointConfigAttributes> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointConfig endpointConfig = (EndpointConfig)o;
        return Objects.equals(this.url, endpointConfig.url) && Objects.equals(this.timeout, endpointConfig.timeout) && Objects.equals(this.isPrimary, endpointConfig.isPrimary) && Objects.equals(this.attributes, endpointConfig.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.timeout, this.isPrimary, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EndpointConfig {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    isPrimary: ").append(this.toIndentedString(this.isPrimary)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

