/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.text.DateFormat;
import org.wso2.carbon.apimgt.rest.integration.tests.exceptions.AMIntegrationTestException;
import org.wso2.carbon.apimgt.rest.integration.tests.util.AMIntegrationSSLSocketFactory;
import org.wso2.carbon.apimgt.rest.integration.tests.util.RFC3339DateFormat;
import org.wso2.carbon.apimgt.rest.integration.tests.util.RestAPIErrorDecoder;
import org.wso2.carbon.apimgt.rest.integration.tests.util.auth.OAuth;

public class ApiClient {
    protected ObjectMapper objectMapper;
    private String basePath;
    private Feign.Builder feignBuilder;
    public static final String KEY_MANAGER_CERT_ALIAS = "wso2carbon";

    public ApiClient(String basePath, String username, String password, String scopes) throws AMIntegrationTestException {
        this.basePath = basePath;
        this.objectMapper = this.createObjectMapper();
        this.feignBuilder = Feign.builder().encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(this.objectMapper))).decoder((Decoder)new JacksonDecoder(this.objectMapper)).errorDecoder((ErrorDecoder)new RestAPIErrorDecoder()).logger((Logger)new Slf4jLogger()).requestInterceptor((RequestInterceptor)new OAuth(username, password, scopes)).client((Client)new Client.Default(AMIntegrationSSLSocketFactory.getSSLSocketFactory(KEY_MANAGER_CERT_ALIAS), (hostname, sslSession) -> true));
    }

    public ApiClient(String basePath, String username, String password) throws AMIntegrationTestException {
        this.basePath = basePath;
        this.objectMapper = this.createObjectMapper();
        this.feignBuilder = Feign.builder().encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(this.objectMapper))).decoder((Decoder)new JacksonDecoder(this.objectMapper)).errorDecoder((ErrorDecoder)new RestAPIErrorDecoder()).logger((Logger)new Slf4jLogger()).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(username, password)).client((Client)new Client.Default(AMIntegrationSSLSocketFactory.getSSLSocketFactory(KEY_MANAGER_CERT_ALIAS), (hostname, sslSession) -> true));
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setDateFormat((DateFormat)((Object)new RFC3339DateFormat()));
        objectMapper.registerModule((Module)new JodaModule());
        return objectMapper;
    }

    public <T extends Api> T buildClient(Class<T> clientClass) {
        return (T)((Api)this.feignBuilder.target(clientClass, this.basePath));
    }

    public static interface Api {
    }
}

