/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.util.auth;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.RetryableException;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TestUtil;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TokenInfo;

public class OAuth
implements RequestInterceptor {
    private String username;
    private String password;
    private String scopes;
    private volatile TokenInfo tokenInfo;

    public OAuth(String username, String password, String scopes) {
        this.username = username;
        this.password = password;
        this.scopes = scopes;
    }

    public void apply(RequestTemplate template) {
        if (template.headers().containsKey("Authorization")) {
            return;
        }
        if (this.tokenInfo == null) {
            this.generateFirstToken();
        } else if (System.currentTimeMillis() - this.tokenInfo.getExpiryTime() >= 1000L) {
            this.generateTokenFromRefreshGrant();
        }
        if (this.getAccessToken() != null) {
            template.header("Authorization", new String[]{"Bearer " + this.getAccessToken()});
        }
    }

    public synchronized void generateFirstToken() {
        try {
            this.tokenInfo = TestUtil.generateToken(this.username, this.password, this.scopes);
        }
        catch (Exception e) {
            throw new RetryableException(e.getMessage(), (Throwable)e, null);
        }
    }

    public synchronized void generateTokenFromRefreshGrant() {
        try {
            this.tokenInfo = TestUtil.generateToken(this.scopes, this.tokenInfo.getRefreshToken());
        }
        catch (Exception e) {
            throw new RetryableException(e.getMessage(), (Throwable)e, null);
        }
    }

    public synchronized String getAccessToken() {
        return this.tokenInfo.getToken();
    }
}

