/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import org.wso2.carbon.apimgt.rest.integration.tests.util.StringUtil;

public final class EncodingUtils {
    private EncodingUtils() {
    }

    public static Object encodeCollection(Collection<?> parameters, String collectionFormat) {
        if (parameters == null) {
            return parameters;
        }
        ArrayList<String> stringValues = new ArrayList<String>(parameters.size());
        for (Object parameter : parameters) {
            if (parameter == null) continue;
            stringValues.add(EncodingUtils.encode(parameter));
        }
        if (stringValues.size() < 2 || "multi".equals(collectionFormat)) {
            return stringValues;
        }
        String[] stringArray = stringValues.toArray(new String[0]);
        switch (collectionFormat) {
            default: {
                return StringUtil.join(stringArray, ",");
            }
            case "ssv": {
                return StringUtil.join(stringArray, " ");
            }
            case "tsv": {
                return StringUtil.join(stringArray, "\t");
            }
            case "pipes": 
        }
        return StringUtil.join(stringArray, "|");
    }

    public static String encode(Object parameter) {
        if (parameter == null) {
            return null;
        }
        try {
            return URLEncoder.encode(parameter.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

