/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.util;

import com.google.gson.Gson;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apimgt.rest.integration.tests.exceptions.RestAPIException;
import org.wso2.carbon.apimgt.rest.integration.tests.util.Error;

public class RestAPIErrorDecoder
implements ErrorDecoder {
    private static Logger logger = LoggerFactory.getLogger(RestAPIErrorDecoder.class);

    public Exception decode(String s, Response response) {
        Error error = null;
        if (response.status() >= 400 && response.status() <= 499) {
            try {
                error = (Error)new Gson().fromJson(response.body().asReader(), Error.class);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return new RestAPIException(response.status(), response.reason(), error);
        }
        if (response.status() >= 500 && response.status() <= 599) {
            try {
                error = (Error)new Gson().fromJson(response.body().asReader(), Error.class);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return new RestAPIException(response.status(), response.reason(), error);
        }
        return new ErrorDecoder.Default().decode(s, response);
    }
}

