/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.apimgt.rest.integration.tests.ApiCallback;
import org.wso2.carbon.apimgt.rest.integration.tests.ApiClient;
import org.wso2.carbon.apimgt.rest.integration.tests.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.ApiResponse;
import org.wso2.carbon.apimgt.rest.integration.tests.Configuration;
import org.wso2.carbon.apimgt.rest.integration.tests.Pair;
import org.wso2.carbon.apimgt.rest.integration.tests.ProgressRequestBody;
import org.wso2.carbon.apimgt.rest.integration.tests.ProgressResponseBody;
import org.wso2.carbon.apimgt.rest.integration.tests.model.Tier;
import org.wso2.carbon.apimgt.rest.integration.tests.model.TierList;

public class ThrottlingTierCollectionApi {
    private ApiClient apiClient;

    public ThrottlingTierCollectionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ThrottlingTierCollectionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private Call policiesTierLevelGetCall(String tierLevel, Integer limit, Integer offset, String accept, String ifNoneMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/policies/{tierLevel}".replaceAll("\\{format\\}", "json").replaceAll("\\{tierLevel\\}", this.apiClient.escapeString(tierLevel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (accept != null) {
            localVarHeaderParams.put("Accept", this.apiClient.parameterToString(accept));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call policiesTierLevelGetValidateBeforeCall(String tierLevel, Integer limit, Integer offset, String accept, String ifNoneMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tierLevel == null) {
            throw new ApiException("Missing the required parameter 'tierLevel' when calling policiesTierLevelGet(Async)");
        }
        Call call = this.policiesTierLevelGetCall(tierLevel, limit, offset, accept, ifNoneMatch, progressListener, progressRequestListener);
        return call;
    }

    public TierList policiesTierLevelGet(String tierLevel, Integer limit, Integer offset, String accept, String ifNoneMatch) throws ApiException {
        ApiResponse<TierList> resp = this.policiesTierLevelGetWithHttpInfo(tierLevel, limit, offset, accept, ifNoneMatch);
        return resp.getData();
    }

    public ApiResponse<TierList> policiesTierLevelGetWithHttpInfo(String tierLevel, Integer limit, Integer offset, String accept, String ifNoneMatch) throws ApiException {
        Call call = this.policiesTierLevelGetValidateBeforeCall(tierLevel, limit, offset, accept, ifNoneMatch, null, null);
        Type localVarReturnType = new TypeToken<TierList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call policiesTierLevelGetAsync(String tierLevel, Integer limit, Integer offset, String accept, String ifNoneMatch, final ApiCallback<TierList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.policiesTierLevelGetValidateBeforeCall(tierLevel, limit, offset, accept, ifNoneMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TierList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    private Call policiesTierLevelPostCall(Tier body, String tierLevel, String contentType, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Tier localVarPostBody = body;
        String localVarPath = "/policies/{tierLevel}".replaceAll("\\{format\\}", "json").replaceAll("\\{tierLevel\\}", this.apiClient.escapeString(tierLevel.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call policiesTierLevelPostValidateBeforeCall(Tier body, String tierLevel, String contentType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling policiesTierLevelPost(Async)");
        }
        if (tierLevel == null) {
            throw new ApiException("Missing the required parameter 'tierLevel' when calling policiesTierLevelPost(Async)");
        }
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling policiesTierLevelPost(Async)");
        }
        Call call = this.policiesTierLevelPostCall(body, tierLevel, contentType, progressListener, progressRequestListener);
        return call;
    }

    public Tier policiesTierLevelPost(Tier body, String tierLevel, String contentType) throws ApiException {
        ApiResponse<Tier> resp = this.policiesTierLevelPostWithHttpInfo(body, tierLevel, contentType);
        return resp.getData();
    }

    public ApiResponse<Tier> policiesTierLevelPostWithHttpInfo(Tier body, String tierLevel, String contentType) throws ApiException {
        Call call = this.policiesTierLevelPostValidateBeforeCall(body, tierLevel, contentType, null, null);
        Type localVarReturnType = new TypeToken<Tier>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call policiesTierLevelPostAsync(Tier body, String tierLevel, String contentType, final ApiCallback<Tier> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.policiesTierLevelPostValidateBeforeCall(body, tierLevel, contentType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Tier>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

