/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.publisher.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiCallback;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiClient;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiResponse;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.Configuration;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.Pair;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ProgressRequestBody;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ProgressResponseBody;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.API;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.FileInfo;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.LifecycleState;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.WorkflowResponse;

public class APIIndividualApi {
    private ApiClient apiClient;

    public APIIndividualApi() {
        this(Configuration.getDefaultApiClient());
    }

    public APIIndividualApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call apisApiIdDeleteCall(String apiId, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdDeleteValidateBeforeCall(String apiId, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdDelete(Async)");
        }
        Call call = this.apisApiIdDeleteCall(apiId, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdDelete(String apiId, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        this.apisApiIdDeleteWithHttpInfo(apiId, ifMatch, ifUnmodifiedSince);
    }

    public ApiResponse<Void> apisApiIdDeleteWithHttpInfo(String apiId, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.apisApiIdDeleteValidateBeforeCall(apiId, ifMatch, ifUnmodifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdDeleteAsync(String apiId, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdDeleteValidateBeforeCall(apiId, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdGatewayConfigGetCall(String apiId, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/gateway-config".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdGatewayConfigGetValidateBeforeCall(String apiId, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdGatewayConfigGet(Async)");
        }
        Call call = this.apisApiIdGatewayConfigGetCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdGatewayConfigGet(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        this.apisApiIdGatewayConfigGetWithHttpInfo(apiId, ifNoneMatch, ifModifiedSince);
    }

    public ApiResponse<Void> apisApiIdGatewayConfigGetWithHttpInfo(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.apisApiIdGatewayConfigGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdGatewayConfigGetAsync(String apiId, String ifNoneMatch, String ifModifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdGatewayConfigGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdGatewayConfigPutCall(String apiId, String gatewayConfig, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/gateway-config".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (gatewayConfig != null) {
            localVarFormParams.put("gatewayConfig", gatewayConfig);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdGatewayConfigPutValidateBeforeCall(String apiId, String gatewayConfig, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdGatewayConfigPut(Async)");
        }
        if (gatewayConfig == null) {
            throw new ApiException("Missing the required parameter 'gatewayConfig' when calling apisApiIdGatewayConfigPut(Async)");
        }
        Call call = this.apisApiIdGatewayConfigPutCall(apiId, gatewayConfig, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdGatewayConfigPut(String apiId, String gatewayConfig, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        this.apisApiIdGatewayConfigPutWithHttpInfo(apiId, gatewayConfig, ifMatch, ifUnmodifiedSince);
    }

    public ApiResponse<Void> apisApiIdGatewayConfigPutWithHttpInfo(String apiId, String gatewayConfig, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.apisApiIdGatewayConfigPutValidateBeforeCall(apiId, gatewayConfig, ifMatch, ifUnmodifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdGatewayConfigPutAsync(String apiId, String gatewayConfig, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdGatewayConfigPutValidateBeforeCall(apiId, gatewayConfig, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdGetCall(String apiId, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdGetValidateBeforeCall(String apiId, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdGet(Async)");
        }
        Call call = this.apisApiIdGetCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public API apisApiIdGet(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        ApiResponse<API> resp = this.apisApiIdGetWithHttpInfo(apiId, ifNoneMatch, ifModifiedSince);
        return resp.getData();
    }

    public ApiResponse<API> apisApiIdGetWithHttpInfo(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.apisApiIdGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, null, null);
        Type localVarReturnType = new TypeToken<API>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdGetAsync(String apiId, String ifNoneMatch, String ifModifiedSince, final ApiCallback<API> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<API>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdLifecycleGetCall(String apiId, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/lifecycle".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdLifecycleGetValidateBeforeCall(String apiId, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdLifecycleGet(Async)");
        }
        Call call = this.apisApiIdLifecycleGetCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public LifecycleState apisApiIdLifecycleGet(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        ApiResponse<LifecycleState> resp = this.apisApiIdLifecycleGetWithHttpInfo(apiId, ifNoneMatch, ifModifiedSince);
        return resp.getData();
    }

    public ApiResponse<LifecycleState> apisApiIdLifecycleGetWithHttpInfo(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.apisApiIdLifecycleGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, null, null);
        Type localVarReturnType = new TypeToken<LifecycleState>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdLifecycleGetAsync(String apiId, String ifNoneMatch, String ifModifiedSince, final ApiCallback<LifecycleState> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdLifecycleGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LifecycleState>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdLifecycleHistoryGetCall(String apiId, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/lifecycle-history".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdLifecycleHistoryGetValidateBeforeCall(String apiId, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdLifecycleHistoryGet(Async)");
        }
        Call call = this.apisApiIdLifecycleHistoryGetCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdLifecycleHistoryGet(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        this.apisApiIdLifecycleHistoryGetWithHttpInfo(apiId, ifNoneMatch, ifModifiedSince);
    }

    public ApiResponse<Void> apisApiIdLifecycleHistoryGetWithHttpInfo(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.apisApiIdLifecycleHistoryGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdLifecycleHistoryGetAsync(String apiId, String ifNoneMatch, String ifModifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdLifecycleHistoryGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdLifecycleLifecyclePendingTaskDeleteCall(String apiId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/lifecycle/lifecycle-pending-task".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdLifecycleLifecyclePendingTaskDeleteValidateBeforeCall(String apiId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdLifecycleLifecyclePendingTaskDelete(Async)");
        }
        Call call = this.apisApiIdLifecycleLifecyclePendingTaskDeleteCall(apiId, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdLifecycleLifecyclePendingTaskDelete(String apiId) throws ApiException {
        this.apisApiIdLifecycleLifecyclePendingTaskDeleteWithHttpInfo(apiId);
    }

    public ApiResponse<Void> apisApiIdLifecycleLifecyclePendingTaskDeleteWithHttpInfo(String apiId) throws ApiException {
        Call call = this.apisApiIdLifecycleLifecyclePendingTaskDeleteValidateBeforeCall(apiId, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdLifecycleLifecyclePendingTaskDeleteAsync(String apiId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdLifecycleLifecyclePendingTaskDeleteValidateBeforeCall(apiId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdPutCall(String apiId, API body, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        API localVarPostBody = body;
        String localVarPath = "/apis/{apiId}".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdPutValidateBeforeCall(String apiId, API body, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdPut(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling apisApiIdPut(Async)");
        }
        Call call = this.apisApiIdPutCall(apiId, body, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public API apisApiIdPut(String apiId, API body, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        ApiResponse<API> resp = this.apisApiIdPutWithHttpInfo(apiId, body, ifMatch, ifUnmodifiedSince);
        return resp.getData();
    }

    public ApiResponse<API> apisApiIdPutWithHttpInfo(String apiId, API body, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.apisApiIdPutValidateBeforeCall(apiId, body, ifMatch, ifUnmodifiedSince, null, null);
        Type localVarReturnType = new TypeToken<API>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdPutAsync(String apiId, API body, String ifMatch, String ifUnmodifiedSince, final ApiCallback<API> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdPutValidateBeforeCall(apiId, body, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<API>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdSwaggerGetCall(String apiId, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/swagger".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdSwaggerGetValidateBeforeCall(String apiId, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdSwaggerGet(Async)");
        }
        Call call = this.apisApiIdSwaggerGetCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdSwaggerGet(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        this.apisApiIdSwaggerGetWithHttpInfo(apiId, ifNoneMatch, ifModifiedSince);
    }

    public ApiResponse<Void> apisApiIdSwaggerGetWithHttpInfo(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.apisApiIdSwaggerGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdSwaggerGetAsync(String apiId, String ifNoneMatch, String ifModifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdSwaggerGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdSwaggerPutCall(String apiId, String endpointId, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/swagger".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (endpointId != null) {
            localVarFormParams.put("endpointId", endpointId);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdSwaggerPutValidateBeforeCall(String apiId, String endpointId, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdSwaggerPut(Async)");
        }
        if (endpointId == null) {
            throw new ApiException("Missing the required parameter 'endpointId' when calling apisApiIdSwaggerPut(Async)");
        }
        Call call = this.apisApiIdSwaggerPutCall(apiId, endpointId, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdSwaggerPut(String apiId, String endpointId, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        this.apisApiIdSwaggerPutWithHttpInfo(apiId, endpointId, ifMatch, ifUnmodifiedSince);
    }

    public ApiResponse<Void> apisApiIdSwaggerPutWithHttpInfo(String apiId, String endpointId, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.apisApiIdSwaggerPutValidateBeforeCall(apiId, endpointId, ifMatch, ifUnmodifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdSwaggerPutAsync(String apiId, String endpointId, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdSwaggerPutValidateBeforeCall(apiId, endpointId, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdThumbnailGetCall(String apiId, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/thumbnail".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdThumbnailGetValidateBeforeCall(String apiId, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdThumbnailGet(Async)");
        }
        Call call = this.apisApiIdThumbnailGetCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdThumbnailGet(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        this.apisApiIdThumbnailGetWithHttpInfo(apiId, ifNoneMatch, ifModifiedSince);
    }

    public ApiResponse<Void> apisApiIdThumbnailGetWithHttpInfo(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.apisApiIdThumbnailGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdThumbnailGetAsync(String apiId, String ifNoneMatch, String ifModifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdThumbnailGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdThumbnailPostCall(String apiId, File file, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/thumbnail".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdThumbnailPostValidateBeforeCall(String apiId, File file, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdThumbnailPost(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling apisApiIdThumbnailPost(Async)");
        }
        Call call = this.apisApiIdThumbnailPostCall(apiId, file, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public FileInfo apisApiIdThumbnailPost(String apiId, File file, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        ApiResponse<FileInfo> resp = this.apisApiIdThumbnailPostWithHttpInfo(apiId, file, ifMatch, ifUnmodifiedSince);
        return resp.getData();
    }

    public ApiResponse<FileInfo> apisApiIdThumbnailPostWithHttpInfo(String apiId, File file, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.apisApiIdThumbnailPostValidateBeforeCall(apiId, file, ifMatch, ifUnmodifiedSince, null, null);
        Type localVarReturnType = new TypeToken<FileInfo>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisApiIdThumbnailPostAsync(String apiId, File file, String ifMatch, String ifUnmodifiedSince, final ApiCallback<FileInfo> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdThumbnailPostValidateBeforeCall(apiId, file, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FileInfo>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisApiIdWsdlGetCall(String apiId, String ifNoneMatch, String ifModifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/wsdl".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdWsdlGetValidateBeforeCall(String apiId, String ifNoneMatch, String ifModifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdWsdlGet(Async)");
        }
        Call call = this.apisApiIdWsdlGetCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdWsdlGet(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        this.apisApiIdWsdlGetWithHttpInfo(apiId, ifNoneMatch, ifModifiedSince);
    }

    public ApiResponse<Void> apisApiIdWsdlGetWithHttpInfo(String apiId, String ifNoneMatch, String ifModifiedSince) throws ApiException {
        Call call = this.apisApiIdWsdlGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdWsdlGetAsync(String apiId, String ifNoneMatch, String ifModifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdWsdlGetValidateBeforeCall(apiId, ifNoneMatch, ifModifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisApiIdWsdlPutCall(String apiId, File file, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/apis/{apiId}/wsdl".replaceAll("\\{apiId\\}", this.apiClient.escapeString(apiId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisApiIdWsdlPutValidateBeforeCall(String apiId, File file, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisApiIdWsdlPut(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling apisApiIdWsdlPut(Async)");
        }
        Call call = this.apisApiIdWsdlPutCall(apiId, file, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public void apisApiIdWsdlPut(String apiId, File file, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        this.apisApiIdWsdlPutWithHttpInfo(apiId, file, ifMatch, ifUnmodifiedSince);
    }

    public ApiResponse<Void> apisApiIdWsdlPutWithHttpInfo(String apiId, File file, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.apisApiIdWsdlPutValidateBeforeCall(apiId, file, ifMatch, ifUnmodifiedSince, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisApiIdWsdlPutAsync(String apiId, File file, String ifMatch, String ifUnmodifiedSince, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisApiIdWsdlPutValidateBeforeCall(apiId, file, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call apisChangeLifecyclePostCall(String action, String apiId, String lifecycleChecklist, String ifMatch, String ifUnmodifiedSince, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/change-lifecycle";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (action != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "action", action));
        }
        if (lifecycleChecklist != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "lifecycleChecklist", lifecycleChecklist));
        }
        if (apiId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apiId", apiId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (ifUnmodifiedSince != null) {
            localVarHeaderParams.put("If-Unmodified-Since", this.apiClient.parameterToString(ifUnmodifiedSince));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisChangeLifecyclePostValidateBeforeCall(String action, String apiId, String lifecycleChecklist, String ifMatch, String ifUnmodifiedSince, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (action == null) {
            throw new ApiException("Missing the required parameter 'action' when calling apisChangeLifecyclePost(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisChangeLifecyclePost(Async)");
        }
        Call call = this.apisChangeLifecyclePostCall(action, apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        return call;
    }

    public WorkflowResponse apisChangeLifecyclePost(String action, String apiId, String lifecycleChecklist, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        ApiResponse<WorkflowResponse> resp = this.apisChangeLifecyclePostWithHttpInfo(action, apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince);
        return resp.getData();
    }

    public ApiResponse<WorkflowResponse> apisChangeLifecyclePostWithHttpInfo(String action, String apiId, String lifecycleChecklist, String ifMatch, String ifUnmodifiedSince) throws ApiException {
        Call call = this.apisChangeLifecyclePostValidateBeforeCall(action, apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince, null, null);
        Type localVarReturnType = new TypeToken<WorkflowResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call apisChangeLifecyclePostAsync(String action, String apiId, String lifecycleChecklist, String ifMatch, String ifUnmodifiedSince, final ApiCallback<WorkflowResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisChangeLifecyclePostValidateBeforeCall(action, apiId, lifecycleChecklist, ifMatch, ifUnmodifiedSince, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<WorkflowResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call apisCopyApiPostCall(String newVersion, String apiId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/copy-api";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (newVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "newVersion", newVersion));
        }
        if (apiId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apiId", apiId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call apisCopyApiPostValidateBeforeCall(String newVersion, String apiId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (newVersion == null) {
            throw new ApiException("Missing the required parameter 'newVersion' when calling apisCopyApiPost(Async)");
        }
        if (apiId == null) {
            throw new ApiException("Missing the required parameter 'apiId' when calling apisCopyApiPost(Async)");
        }
        Call call = this.apisCopyApiPostCall(newVersion, apiId, progressListener, progressRequestListener);
        return call;
    }

    public void apisCopyApiPost(String newVersion, String apiId) throws ApiException {
        this.apisCopyApiPostWithHttpInfo(newVersion, apiId);
    }

    public ApiResponse<Void> apisCopyApiPostWithHttpInfo(String newVersion, String apiId) throws ApiException {
        Call call = this.apisCopyApiPostValidateBeforeCall(newVersion, apiId, null, null);
        return this.apiClient.execute(call);
    }

    public Call apisCopyApiPostAsync(String newVersion, String apiId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.apisCopyApiPostValidateBeforeCall(newVersion, apiId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

