/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.publisher.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiCallback;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiClient;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiException;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ApiResponse;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.Configuration;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.Pair;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ProgressRequestBody;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.ProgressResponseBody;

public class ExportConfigurationApi {
    private ApiClient apiClient;

    public ExportConfigurationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExportConfigurationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call exportApisGetCall(String query, Integer limit, Integer offset, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/export/apis";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (query != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/zip"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"OAuth2Security"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call exportApisGetValidateBeforeCall(String query, Integer limit, Integer offset, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling exportApisGet(Async)");
        }
        Call call = this.exportApisGetCall(query, limit, offset, progressListener, progressRequestListener);
        return call;
    }

    public File exportApisGet(String query, Integer limit, Integer offset) throws ApiException {
        ApiResponse<File> resp = this.exportApisGetWithHttpInfo(query, limit, offset);
        return resp.getData();
    }

    public ApiResponse<File> exportApisGetWithHttpInfo(String query, Integer limit, Integer offset) throws ApiException {
        Call call = this.exportApisGetValidateBeforeCall(query, limit, offset, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call exportApisGetAsync(String query, Integer limit, Integer offset, final ApiCallback<File> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.exportApisGetValidateBeforeCall(query, limit, offset, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

