/*
 * WSO2 API Manager - Publisher API
 * This specifies a **RESTful API** for WSO2 **API Manager** - Publisher.  Please see [full swagger definition](https://raw.githubusercontent.com/wso2/carbon-apimgt/v6.0.4/components/apimgt/org.wso2.carbon.apimgt.rest.api.publisher/src/main/resources/publisher-api.yaml) of the API which is written using [swagger 2.0](http://swagger.io/) specification. 
 *
 * OpenAPI spec version: v1.0
 * Contact: architecture@wso2.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.wso2.carbon.apimgt.rest.integration.tests.publisher.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.wso2.carbon.apimgt.rest.integration.tests.publisher.model.EndPointEndpointSecurity;

/**
 * EndPoint
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-03-27T17:28:03.315+05:30")
public class EndPoint {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("endpointConfig")
  private String endpointConfig = null;

  @JsonProperty("endpointSecurity")
  private EndPointEndpointSecurity endpointSecurity = null;

  @JsonProperty("maxTps")
  private Long maxTps = null;

  @JsonProperty("type")
  private String type = null;

  public EndPoint id(String id) {
    this.id = id;
    return this;
  }

   /**
   * UUID of the Endpoint entry 
   * @return id
  **/
  @ApiModelProperty(example = "01234567-0123-0123-0123-012345678901", value = "UUID of the Endpoint entry ")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public EndPoint name(String name) {
    this.name = name;
    return this;
  }

   /**
   * name of the Endpoint entry 
   * @return name
  **/
  @ApiModelProperty(example = "Endpoint 1", value = "name of the Endpoint entry ")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public EndPoint endpointConfig(String endpointConfig) {
    this.endpointConfig = endpointConfig;
    return this;
  }

   /**
   * Endpoint Configuration
   * @return endpointConfig
  **/
  @ApiModelProperty(example = "{url: http://localhost:8280, timeout: 1000}", value = "Endpoint Configuration")
  public String getEndpointConfig() {
    return endpointConfig;
  }

  public void setEndpointConfig(String endpointConfig) {
    this.endpointConfig = endpointConfig;
  }

  public EndPoint endpointSecurity(EndPointEndpointSecurity endpointSecurity) {
    this.endpointSecurity = endpointSecurity;
    return this;
  }

   /**
   * Get endpointSecurity
   * @return endpointSecurity
  **/
  @ApiModelProperty(value = "")
  public EndPointEndpointSecurity getEndpointSecurity() {
    return endpointSecurity;
  }

  public void setEndpointSecurity(EndPointEndpointSecurity endpointSecurity) {
    this.endpointSecurity = endpointSecurity;
  }

  public EndPoint maxTps(Long maxTps) {
    this.maxTps = maxTps;
    return this;
  }

   /**
   * Endpoint max tps
   * @return maxTps
  **/
  @ApiModelProperty(example = "1000", value = "Endpoint max tps")
  public Long getMaxTps() {
    return maxTps;
  }

  public void setMaxTps(Long maxTps) {
    this.maxTps = maxTps;
  }

  public EndPoint type(String type) {
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @ApiModelProperty(example = "http", value = "")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EndPoint endPoint = (EndPoint) o;
    return Objects.equals(this.id, endPoint.id) &&
        Objects.equals(this.name, endPoint.name) &&
        Objects.equals(this.endpointConfig, endPoint.endpointConfig) &&
        Objects.equals(this.endpointSecurity, endPoint.endpointSecurity) &&
        Objects.equals(this.maxTps, endPoint.maxTps) &&
        Objects.equals(this.type, endPoint.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, endpointConfig, endpointSecurity, maxTps, type);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EndPoint {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    endpointConfig: ").append(toIndentedString(endpointConfig)).append("\n");
    sb.append("    endpointSecurity: ").append(toIndentedString(endpointSecurity)).append("\n");
    sb.append("    maxTps: ").append(toIndentedString(maxTps)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

