/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.store.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.apimgt.rest.integration.tests.store.ApiClient;
import org.wso2.carbon.apimgt.rest.integration.tests.store.EncodingUtils;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.Application;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.ApplicationKeyGenerateRequest;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.ApplicationKeyMappingRequest;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.ApplicationKeys;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.ApplicationKeysList;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.ApplicationToken;
import org.wso2.carbon.apimgt.rest.integration.tests.store.model.ApplicationTokenGenerateRequest;

public interface ApplicationIndividualApi
extends ApiClient.Api {
    @RequestLine(value="DELETE /applications/{applicationId}")
    @Headers(value={"Accept: application/json", "If-Match: {ifMatch}", "If-Unmodified-Since: {ifUnmodifiedSince}"})
    public void applicationsApplicationIdDelete(@Param(value="applicationId") String var1, @Param(value="ifMatch") String var2, @Param(value="ifUnmodifiedSince") String var3);

    @RequestLine(value="POST /applications/{applicationId}/generate-keys")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApplicationKeys applicationsApplicationIdGenerateKeysPost(@Param(value="applicationId") String var1, ApplicationKeyGenerateRequest var2);

    @RequestLine(value="POST /applications/{applicationId}/generate-token")
    @Headers(value={"Content-Type: application/json", "Accept: application/json", "If-Match: {ifMatch}", "If-Unmodified-Since: {ifUnmodifiedSince}"})
    public ApplicationToken applicationsApplicationIdGenerateTokenPost(@Param(value="applicationId") String var1, ApplicationTokenGenerateRequest var2, @Param(value="ifMatch") String var3, @Param(value="ifUnmodifiedSince") String var4);

    @RequestLine(value="GET /applications/{applicationId}")
    @Headers(value={"Accept: application/json", "If-None-Match: {ifNoneMatch}", "If-Modified-Since: {ifModifiedSince}"})
    public Application applicationsApplicationIdGet(@Param(value="applicationId") String var1, @Param(value="ifNoneMatch") String var2, @Param(value="ifModifiedSince") String var3);

    @RequestLine(value="GET /applications/{applicationId}/keys")
    @Headers(value={"Accept: application/json"})
    public ApplicationKeysList applicationsApplicationIdKeysGet(@Param(value="applicationId") String var1);

    @RequestLine(value="GET /applications/{applicationId}/keys/{keyType}")
    @Headers(value={"Accept: application/json"})
    public ApplicationKeys applicationsApplicationIdKeysKeyTypeGet(@Param(value="applicationId") String var1, @Param(value="keyType") String var2);

    @RequestLine(value="PUT /applications/{applicationId}/keys/{keyType}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApplicationKeys applicationsApplicationIdKeysKeyTypePut(@Param(value="applicationId") String var1, @Param(value="keyType") String var2, ApplicationKeys var3);

    @RequestLine(value="POST /applications/{applicationId}/map-keys")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApplicationKeys applicationsApplicationIdMapKeysPost(@Param(value="applicationId") String var1, ApplicationKeyMappingRequest var2);

    @RequestLine(value="PUT /applications/{applicationId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json", "If-Match: {ifMatch}", "If-Unmodified-Since: {ifUnmodifiedSince}"})
    public Application applicationsApplicationIdPut(@Param(value="applicationId") String var1, Application var2, @Param(value="ifMatch") String var3, @Param(value="ifUnmodifiedSince") String var4);

    @RequestLine(value="POST /applications")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Application applicationsPost(Application var1);

    @RequestLine(value="GET /export/applications?appId={appId}")
    @Headers(value={"Accept: application/zip"})
    public File exportApplicationsGet(@Param(value="appId") String var1);

    @RequestLine(value="GET /export/applications?appId={appId}")
    @Headers(value={"Accept: application/zip"})
    public File exportApplicationsGet(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="POST /import/applications")
    @Headers(value={"Content-Type: multipart/form-data", "Accept: application/json"})
    public Application importApplicationsPost(@Param(value="file") File var1);

    @RequestLine(value="PUT /import/applications")
    @Headers(value={"Content-Type: multipart/form-data", "Accept: application/json"})
    public Application importApplicationsPut(@Param(value="file") File var1);

    public static class ExportApplicationsGetQueryParams
    extends HashMap<String, Object> {
        public ExportApplicationsGetQueryParams appId(String value) {
            this.put("appId", EncodingUtils.encode(value));
            return this;
        }
    }
}

