/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.rest.integration.tests.util;

import feign.Response;
import feign.gson.GsonDecoder;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.apimgt.core.auth.DCRMServiceStubFactory;
import org.wso2.carbon.apimgt.core.auth.OAuth2ServiceStubs;
import org.wso2.carbon.apimgt.core.auth.dto.DCRClientInfo;
import org.wso2.carbon.apimgt.core.auth.dto.OAuth2TokenInfo;
import org.wso2.carbon.apimgt.core.exception.APIManagementException;
import org.wso2.carbon.apimgt.core.exception.ExceptionCodes;
import org.wso2.carbon.apimgt.core.exception.KeyManagementException;
import org.wso2.carbon.apimgt.rest.integration.tests.exceptions.AMIntegrationTestException;
import org.wso2.carbon.apimgt.rest.integration.tests.util.TokenInfo;

public class TestUtil {
    private static Logger logger = LoggerFactory.getLogger(TestUtil.class);
    public static TokenInfo accessTokenInfo;
    public static String clientId;
    private static String clientSecret;
    public static final String TOKEN_ENDPOINT_URL;
    public static final String DYNAMIC_CLIENT_REGISTRATION_ENDPOINT;
    public static final String username = "admin";
    public static final String password = "admin";
    public static final String scopes = "apim:api_view,apim:api_create, apim:api_update, apim:api_delete, apim:apidef_update, apim:api_publish,apim:subscription_view, apim:subscription_block,apim:dedicated_gateway,apim:external_services_discover";
    public static final String OAUTH2_SECURITY = "OAuth2Security";

    public static TokenInfo getToken(String username, String password) throws AMIntegrationTestException {
        try {
            if (accessTokenInfo != null) {
                if (accessTokenInfo.getExpiryEpochTime() <= System.currentTimeMillis()) {
                    TestUtil.generateToken(username, password, scopes);
                }
            } else {
                TestUtil.generateToken(username, password, scopes);
            }
            return accessTokenInfo;
        }
        catch (APIManagementException e) {
            throw new AMIntegrationTestException("Couldn't generate Token", e);
        }
    }

    private static void generateToken(String username, String password, String scopes) throws APIManagementException {
        OAuth2ServiceStubs.TokenServiceStub tokenServiceStub;
        Response response;
        if (StringUtils.isEmpty((CharSequence)clientId) | StringUtils.isEmpty((CharSequence)clientSecret)) {
            TestUtil.generateClient();
        }
        if ((response = (tokenServiceStub = TestUtil.getOauth2Client()).generatePasswordGrantAccessToken(username, password, scopes, -1L, clientId, clientSecret)).status() == 200) {
            logger.debug("A new access token is successfully generated.");
            try {
                OAuth2TokenInfo oAuth2TokenInfo = (OAuth2TokenInfo)new GsonDecoder().decode(response, OAuth2TokenInfo.class);
                accessTokenInfo = new TokenInfo(oAuth2TokenInfo.getAccessToken(), System.currentTimeMillis() + oAuth2TokenInfo.getExpiresIn());
            }
            catch (IOException e) {
                throw new KeyManagementException("Error occurred while parsing token response", (Throwable)e, ExceptionCodes.ACCESS_TOKEN_GENERATION_FAILED);
            }
        }
    }

    public static DCRClientInfo generateClient() throws APIManagementException {
        DCRClientInfo dcrClientInfo = new DCRClientInfo();
        dcrClientInfo.setClientName("apim-integration-test");
        dcrClientInfo.setGrantTypes(Arrays.asList("password", "client_credentials"));
        try {
            Response response = DCRMServiceStubFactory.getDCRMServiceStub((String)DYNAMIC_CLIENT_REGISTRATION_ENDPOINT, (String)"admin", (String)"admin", (String)"wso2carbon").registerApplication(dcrClientInfo);
            DCRClientInfo dcrClientInfoResponse = (DCRClientInfo)new GsonDecoder().decode(response, DCRClientInfo.class);
            clientId = dcrClientInfoResponse.getClientId();
            clientSecret = dcrClientInfoResponse.getClientSecret();
            return dcrClientInfoResponse;
        }
        catch (IOException | APIManagementException e) {
            logger.error("Couldn't create client", e);
            throw new APIManagementException("Couldn't create client", e);
        }
    }

    private static OAuth2ServiceStubs.TokenServiceStub getOauth2Client() throws APIManagementException {
        return new OAuth2ServiceStubs(TOKEN_ENDPOINT_URL, "", "", "wso2carbon", "admin", "admin").getTokenServiceStub();
    }

    public static String getIpAddressOfContainer() {
        String ip = "localhost";
        String dockerHost = System.getenv("SERVER_HOST");
        if (!StringUtils.isEmpty((CharSequence)dockerHost)) {
            return dockerHost;
        }
        return ip;
    }

    static {
        TOKEN_ENDPOINT_URL = "https://" + TestUtil.getIpAddressOfContainer() + ":9443/api/auth/oauth2/v1.0/token";
        DYNAMIC_CLIENT_REGISTRATION_ENDPOINT = "https://" + TestUtil.getIpAddressOfContainer() + ":9443/api/identity/oauth2/dcr/v1.0/register";
    }
}

