/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.jwt.generator;

import com.nimbusds.jwt.JWTClaimsSet;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractMGWJWTGenerator {
    private static final Logger logger = LogManager.getLogger(AbstractMGWJWTGenerator.class);
    private static final String NONE = "NONE";
    private static final String SHA256_WITH_RSA = "SHA256withRSA";
    private String dialectURI;
    private String signatureAlgorithm;
    private String keyStorePath;
    private String keyStorePassword;
    private String certificateAlias;
    private String privateKeyAlias;
    private int jwtExpiryTime;
    private ArrayList<String> restrictedClaims;
    private boolean cacheEnabled;
    private int cacheExpiry;
    private String tokenIssuer;
    private String[] tokenAudience;
    private Map<String, Object> apiDetails;
    private List<String> defaultRestrictedClaims;

    public AbstractMGWJWTGenerator(String dialectURI, String signatureAlgorithm, String keyStorePath, String keyStorePassword, String certificateAlias, String privateKeyAlias, int jwtExpiryTime, String[] restrictedClaims, boolean cacheEnabled, int cacheExpiry, String tokenIssuer, String[] tokenAudience) {
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.certificateAlias = certificateAlias;
        this.privateKeyAlias = privateKeyAlias;
        this.jwtExpiryTime = jwtExpiryTime;
        this.dialectURI = dialectURI;
        this.signatureAlgorithm = signatureAlgorithm;
        this.cacheEnabled = cacheEnabled;
        this.cacheExpiry = cacheExpiry;
        this.tokenIssuer = tokenIssuer;
        this.tokenAudience = tokenAudience;
        this.restrictedClaims = new ArrayList<String>(Arrays.asList(restrictedClaims));
        this.defaultRestrictedClaims = new ArrayList<String>(Arrays.asList("iss", "sub", "aud", "exp", "nbf", "iat", "jti", "application", "tierInfo", "subscribedAPIs", "keytype"));
        this.restrictedClaims.addAll(this.defaultRestrictedClaims);
    }

    public String getPrivateKeyAlias() {
        return this.privateKeyAlias;
    }

    public void setPrivateKeyAlias(String privateKeyAlias) {
        this.privateKeyAlias = privateKeyAlias;
    }

    public List<String> getDefaultRestrictedClaims() {
        return this.defaultRestrictedClaims;
    }

    public void setDefaultRestrictedClaims(List<String> defaultRestrictedClaims) {
        this.defaultRestrictedClaims = defaultRestrictedClaims;
    }

    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    public void setCertificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
    }

    public Map<String, Object> getApiDetails() {
        return this.apiDetails;
    }

    public void setApiDetails(Map<String, Object> apiDetails) {
        this.apiDetails = apiDetails;
    }

    public String[] getTokenAudience() {
        return this.tokenAudience;
    }

    public void setTokenAudience(String[] tokenAudience) {
        this.tokenAudience = tokenAudience;
    }

    public String getTokenIssuer() {
        return this.tokenIssuer;
    }

    public void setTokenIssuer(String tokenIssuer) {
        this.tokenIssuer = tokenIssuer;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public int getCacheExpiry() {
        return this.cacheExpiry;
    }

    public void setCacheExpiry(int cacheExpiry) {
        this.cacheExpiry = cacheExpiry;
    }

    public ArrayList<String> getRestrictedClaims() {
        return this.restrictedClaims;
    }

    public void setRestrictedClaims(ArrayList<String> restrictedClaims) {
        this.restrictedClaims = restrictedClaims;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getDialectURI() {
        return this.dialectURI;
    }

    public void setDialectURI(String dialectURI) {
        this.dialectURI = dialectURI;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public int getJwtExpiryTime() {
        return this.jwtExpiryTime;
    }

    public void setJwtExpiryTime(int jwtExpiryTime) {
        this.jwtExpiryTime = jwtExpiryTime;
    }

    public String generateToken(Map<String, Object> jwtInfo) throws Exception {
        String jwtHeader = this.buildHeader();
        String jwtBody = this.buildBody(jwtInfo);
        String base64UrlEncodedHeader = "";
        if (jwtHeader != null) {
            base64UrlEncodedHeader = this.encode(jwtHeader.getBytes(Charset.defaultCharset()));
        }
        String base64UrlEncodedBody = "";
        if (jwtBody != null) {
            base64UrlEncodedBody = this.encode(jwtBody.getBytes());
        }
        if (SHA256_WITH_RSA.equals(this.signatureAlgorithm)) {
            String assertion = base64UrlEncodedHeader + '.' + base64UrlEncodedBody;
            byte[] signedAssertion = this.signJWT(assertion);
            String base64UrlEncodedAssertion = this.encode(signedAssertion);
            return base64UrlEncodedHeader + '.' + base64UrlEncodedBody + '.' + base64UrlEncodedAssertion;
        }
        return base64UrlEncodedHeader + '.' + base64UrlEncodedBody + '.';
    }

    public String buildHeader() throws Exception {
        String jwtHeader = null;
        if (NONE.equals(this.signatureAlgorithm)) {
            StringBuilder jwtHeaderBuilder = new StringBuilder();
            jwtHeaderBuilder.append("{\"typ\":\"JWT\",");
            jwtHeaderBuilder.append("\"alg\":\"");
            jwtHeaderBuilder.append("none");
            jwtHeaderBuilder.append('\"');
            jwtHeaderBuilder.append('}');
            jwtHeader = jwtHeaderBuilder.toString();
        } else if (SHA256_WITH_RSA.equals(this.signatureAlgorithm)) {
            jwtHeader = this.addCertToHeader();
        }
        return jwtHeader;
    }

    public byte[] signJWT(String assertion) throws Exception {
        FileInputStream is = new FileInputStream(this.keyStorePath);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(is, this.keyStorePassword.toCharArray());
        Key key = keystore.getKey(this.privateKeyAlias, this.keyStorePassword.toCharArray());
        Key privateKey = null;
        if (key instanceof PrivateKey) {
            privateKey = key;
        }
        Signature signature = Signature.getInstance(this.signatureAlgorithm);
        signature.initSign((PrivateKey)privateKey);
        byte[] dataInBytes = assertion.getBytes(Charset.defaultCharset());
        signature.update(dataInBytes);
        is.close();
        return signature.sign();
    }

    public long getTTL() {
        if (this.cacheEnabled) {
            return this.cacheExpiry;
        }
        return this.jwtExpiryTime;
    }

    public String addCertToHeader() throws Exception {
        FileInputStream is = new FileInputStream(this.keyStorePath);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(is, this.keyStorePassword.toCharArray());
        Certificate publicCert = keystore.getCertificate(this.certificateAlias);
        MessageDigest digestValue = MessageDigest.getInstance("SHA-1");
        byte[] der = publicCert.getEncoded();
        digestValue.update(der);
        byte[] digestInBytes = digestValue.digest();
        String publicCertThumbprint = this.hexify(digestInBytes);
        String base64UrlEncodedThumbPrint = Base64.getUrlEncoder().encodeToString(publicCertThumbprint.getBytes("UTF-8"));
        StringBuilder jwtHeader = new StringBuilder();
        jwtHeader.append("{\"typ\":\"JWT\",");
        jwtHeader.append("\"alg\":\"");
        jwtHeader.append("RS256");
        jwtHeader.append("\",");
        jwtHeader.append("\"x5t\":\"");
        jwtHeader.append(base64UrlEncodedThumbPrint);
        jwtHeader.append('\"');
        jwtHeader.append('}');
        is.close();
        return jwtHeader.toString();
    }

    public String buildBody(Map<String, Object> jwtInfo) {
        JWTClaimsSet.Builder jwtClaimSetBuilder = new JWTClaimsSet.Builder();
        Map<String, Object> claims = this.populateStandardClaims(jwtInfo);
        Map<String, Object> customClaims = this.populateCustomClaims(jwtInfo, this.restrictedClaims);
        for (Map.Entry<String, Object> claimEntry : customClaims.entrySet()) {
            if (!claims.containsKey(claimEntry.getKey())) {
                claims.put(claimEntry.getKey(), claimEntry.getValue());
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Claim key " + claimEntry.getKey() + " already exist");
        }
        for (Map.Entry<String, Object> claimEntry : claims.entrySet()) {
            jwtClaimSetBuilder.claim(claimEntry.getKey(), claimEntry.getValue());
        }
        JWTClaimsSet jwtClaimsSet = jwtClaimSetBuilder.build();
        return jwtClaimsSet.toJSONObject().toString();
    }

    public String encode(byte[] stringToBeEncoded) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(stringToBeEncoded);
    }

    public String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            buf.append(hexDigits[(aByte & 0xF0) >> 4]);
            buf.append(hexDigits[aByte & 0xF]);
        }
        return buf.toString();
    }

    public JSONArray arrayToJSONArray(Object[] objectArray) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll(Arrays.asList(objectArray));
        return jsonArray;
    }

    public abstract Map<String, Object> populateStandardClaims(Map<String, Object> var1);

    public abstract Map<String, Object> populateCustomClaims(Map<String, Object> var1, ArrayList<String> var2);
}

