/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.jwt.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.jwt.generator.AbstractMGWClaimRetriever;
import org.wso2.micro.gateway.jwt.generator.AbstractMGWJWTGenerator;
import org.wso2.micro.gateway.jwt.generator.ClaimDTO;

public class MGWClaimRetrieverImpl
extends AbstractMGWClaimRetriever {
    private static final Logger logger = LogManager.getLogger(AbstractMGWJWTGenerator.class);
    private SSLSocketFactory sslSocketFactory;
    private String username;
    private String password;
    private String serverUrl;

    public MGWClaimRetrieverImpl(String trustStorePath, String trustStoreLocation, Map<String, String> configurationMap) {
        super(trustStorePath, trustStoreLocation, configurationMap);
        this.username = configurationMap.get("username");
        this.password = configurationMap.get("password");
        this.serverUrl = configurationMap.get("serverUrl");
        this.sslSocketFactory = this.createSSLSocketFactory();
    }

    @Override
    public List<ClaimDTO> retrieveClaims(Map<String, Object> authContext) {
        try {
            HttpsURLConnection urlConn = null;
            String userInfoEndpoint = this.serverUrl + "/keymanager-operations/user-info/claims/generate";
            URL url = new URL(userInfoEndpoint);
            urlConn = (HttpsURLConnection)url.openConnection();
            urlConn.setSSLSocketFactory(this.sslSocketFactory);
            urlConn.setHostnameVerifier((s, sslSession) -> true);
            urlConn.setDoOutput(true);
            urlConn.setRequestMethod("POST");
            String credential = Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes());
            urlConn.setRequestProperty("Authorization", "Basic " + credential);
            urlConn.setRequestProperty("Content-Type", "application/json");
            String jsonInputString = "{\"username\": \"" + this.removeTenantFromUserName(authContext.get("username").toString()) + "\"}";
            try (OutputStream os = urlConn.getOutputStream();){
                byte[] input = jsonInputString.getBytes("utf-8");
                os.write(input, 0, input.length);
            }
            int responseCode = urlConn.getResponseCode();
            if (responseCode == 200) {
                String responseStr = MGWClaimRetrieverImpl.getResponseString(urlConn.getInputStream());
                ObjectMapper mapper = new ObjectMapper();
                return (List)((Map)mapper.readValue(responseStr, Map.class)).get("list");
            }
            logger.error("Claim Retrieval request is failed with the response code : " + responseCode);
        }
        catch (IOException e) {
            logger.error("Error while retrieving user claims from remote endpoint", (Throwable)e);
        }
        return null;
    }

    public static String getResponseString(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String str;
            StringBuilder content = new StringBuilder();
            while ((str = buffer.readLine()) != null) {
                content.append(str);
            }
            String string = content.toString();
            return string;
        }
    }

    private SSLSocketFactory createSSLSocketFactory() {
        SSLContext ctx = this.createSSLContext();
        if (ctx != null) {
            return ctx.getSocketFactory();
        }
        return null;
    }

    private SSLContext createSSLContext() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            FileInputStream fileInputStream = new FileInputStream(this.getTrustStorePath());
            keyStore.load(fileInputStream, this.getTrustStorePassword() != null ? this.getTrustStorePassword().toCharArray() : null);
            trustManagerFactory.init(keyStore);
            ctx.init(null, trustManagerFactory.getTrustManagers(), null);
            return ctx;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            logger.error("Error while creating the SSL Socket Factory for claim retriever Implementation", (Throwable)e);
            return null;
        }
    }

    private String removeTenantFromUserName(String username) {
        int lastIndexOfAt = username.lastIndexOf("@");
        return username.substring(0, lastIndexOfAt);
    }
}

