/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.gateway.jwt.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.wso2.micro.gateway.jwt.generator.AbstractMGWJWTGenerator;

public class MGWJWTGeneratorImpl
extends AbstractMGWJWTGenerator {
    private static final Logger logger = LogManager.getLogger(MGWJWTGeneratorImpl.class);
    private static final String AUTH_APPLICATION_USER_LEVEL_TOKEN = "Application_User";

    public MGWJWTGeneratorImpl(String dialectURI, String signatureAlgorithm, String trustStorePath, String trustStorePassword, String certificateAlias, String privateKeyAlias, int jwtExpiryTime, String[] restrictedClaims, boolean jwtCacheEnabled, int jwtCacheExpiry, String tokenIssuer, String[] tokenAudience) {
        super(dialectURI, signatureAlgorithm, trustStorePath, trustStorePassword, certificateAlias, privateKeyAlias, jwtExpiryTime, restrictedClaims, jwtCacheEnabled, jwtCacheExpiry, tokenIssuer, tokenAudience);
    }

    @Override
    public Map<String, Object> populateStandardClaims(Map<String, Object> jwtInfo) {
        long currentTime = System.currentTimeMillis();
        long expireIn = currentTime + this.getTTL();
        String dialect = this.getDialectURI();
        HashMap<String, Object> claims = new HashMap<String, Object>();
        HashMap customClaims = (HashMap)jwtInfo.get("customClaims");
        claims.put("iss", this.getTokenIssuer());
        claims.put("jti", UUID.randomUUID().toString());
        claims.put("iat", (int)(currentTime / 1000L));
        claims.put("exp", (int)(expireIn / 1000L));
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)jwtInfo.get("sub")))) {
            claims.put("sub", jwtInfo.get("sub"));
            claims.put(dialect + "/enduser", jwtInfo.get("sub"));
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)customClaims.get("scopes")))) {
            claims.put("scopes", customClaims.get("scopes"));
        }
        if (customClaims.get("application") != null) {
            if (StringUtils.isNotEmpty((CharSequence)((HashMap)customClaims.get("application")).get("id").toString())) {
                claims.put(dialect + "/applicationid", ((HashMap)customClaims.get("application")).get("id").toString());
            }
            if (StringUtils.isNotEmpty((CharSequence)((HashMap)customClaims.get("application")).get("uuid").toString())) {
                claims.put(dialect + "/applicationUUId", ((HashMap)customClaims.get("application")).get("uuid").toString());
            }
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)((HashMap)customClaims.get("application")).get("owner")))) {
                claims.put(dialect + "/subscriber", ((HashMap)customClaims.get("application")).get("owner"));
            }
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)((HashMap)customClaims.get("application")).get("name")))) {
                claims.put(dialect + "/applicationname", ((HashMap)customClaims.get("application")).get("name"));
            }
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)((HashMap)customClaims.get("application")).get("tier")))) {
                claims.put(dialect + "/applicationtier", ((HashMap)customClaims.get("application")).get("tier"));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getApiDetails().get("apiName")))) {
            claims.put(dialect + "/apiname", this.getApiDetails().get("apiName"));
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getApiDetails().get("subscriberTenantDomain")))) {
            claims.put(dialect + "/enduserTenantDomain", this.getApiDetails().get("subscriberTenantDomain"));
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getApiDetails().get("apiContext")))) {
            claims.put(dialect + "/apicontext", this.getApiDetails().get("apiContext"));
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getApiDetails().get("apiVersion")))) {
            claims.put(dialect + "/version", this.getApiDetails().get("apiVersion"));
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getApiDetails().get("apiTier")))) {
            claims.put(dialect + "/tier", this.getApiDetails().get("apiTier"));
        }
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)customClaims.get("keytype")))) {
            claims.put(dialect + "/keytype", customClaims.get("keytype"));
        } else {
            claims.put(dialect + "/keytype", "PRODUCTION");
        }
        claims.put(dialect + "/usertype", AUTH_APPLICATION_USER_LEVEL_TOKEN);
        return claims;
    }

    @Override
    public Map<String, Object> populateCustomClaims(Map<String, Object> jwtInfo, ArrayList<String> restrictedClaims) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        for (String key : jwtInfo.keySet()) {
            if (key.equals("customClaims")) {
                Map customClaims = (Map)jwtInfo.get(key);
                for (String subKey : customClaims.keySet()) {
                    if (restrictedClaims.contains(subKey)) continue;
                    claims.put(subKey, customClaims.get(subKey));
                }
                continue;
            }
            if (restrictedClaims.contains(key)) continue;
            claims.put(key, jwtInfo.get(key));
        }
        return claims;
    }
}

