/*
 * Decompiled with CFR 0.152.
 */
package org.wso2am.micro.gw.mockbackend;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import io.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.json.JSONObject;
import org.wso2am.micro.gw.mockbackend.MockSandboxServer;

public class MockBackEndServer
extends Thread {
    private static final Logger logger = Logger.getLogger(MockBackEndServer.class.getName());
    private HttpServer httpServer;
    private String backEndServerUrl;
    private int backEndServerPort;
    private static boolean retryDone = false;
    private boolean secured = false;
    private boolean mtlsEnabled = false;

    public static void main(String[] args) {
        MockBackEndServer mockBackEndServer = new MockBackEndServer(2383);
        MockSandboxServer mockSandboxServer = new MockSandboxServer(2390);
        mockBackEndServer.start();
        mockSandboxServer.start();
        if (args.length > 0 && args[0].equals("-tls-enabled")) {
            MockBackEndServer securedMockBackEndServer = new MockBackEndServer(2381, true, false);
            MockBackEndServer mtlsMockBackEndServer = new MockBackEndServer(2382, true, true);
            securedMockBackEndServer.start();
            mtlsMockBackEndServer.start();
        }
    }

    public MockBackEndServer(int port) {
        this.backEndServerPort = port;
    }

    public MockBackEndServer(int port, boolean isSecured, boolean mtlsEnabled) {
        this.secured = isSecured;
        this.backEndServerPort = port;
        this.mtlsEnabled = mtlsEnabled;
    }

    @Override
    public void run() {
        if (this.backEndServerPort < 0) {
            throw new RuntimeException("Server port is not defined");
        }
        try {
            if (this.secured) {
                this.httpServer = HttpsServer.create(new InetSocketAddress(this.backEndServerPort), 0);
                ((HttpsServer)this.httpServer).setHttpsConfigurator(new HttpsConfigurator(this.getSslContext()){

                    @Override
                    public void configure(HttpsParameters params) {
                        try {
                            SSLContext sslContext = SSLContext.getDefault();
                            SSLEngine engine = sslContext.createSSLEngine();
                            params.setNeedClientAuth(MockBackEndServer.this.mtlsEnabled);
                            params.setCipherSuites(engine.getEnabledCipherSuites());
                            params.setProtocols(engine.getEnabledProtocols());
                            SSLParameters defaultSSLParameters = sslContext.getDefaultSSLParameters();
                            params.setSSLParameters(defaultSSLParameters);
                        }
                        catch (Exception ex) {
                            logger.severe("Failed to create HTTPS port");
                        }
                    }
                });
            } else {
                this.httpServer = HttpServer.create(new InetSocketAddress(this.backEndServerPort), 0);
            }
            String context = "/v2";
            this.httpServer.createContext(context + "/pet/findByStatus", exchange -> {
                byte[] response = "{\"id\":111111148, \"category\":{ \"id\":0, \"name\":\"ABCD\" }, \"name\":\"doggieUpdated\", \"photoUrls\":[ \"SampleImage1.png\" ], \"tags\":[ { \"id\":0, \"name\":\"TestTag1\" } ], \"status\":\"pending\"}".getBytes();
                exchange.getResponseHeaders().set("content-type", "application/json");
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.createContext(context + "/pet/", exchange -> {
                byte[] response = "{\"id\":2, \"category\":{\"id\":1, \"name\":\"John Doe\"}, \"name\":\"shre\", \"photoUrls\":[\"ArrayItem1\"], \"tags\":[{\"id\":1, \"name\":\"TfNSW\"}], \"status\":\"hello\"}".getBytes();
                exchange.getResponseHeaders().set("content-type", "application/json");
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.createContext(context + "/pet/findByTags", exchange -> {
                byte[] response = "{\"id\":2, \"category\":{\"id\":1, \"name\":\"John Doe\"}, \"name\":\"shre\", \"photoUrls\":[\"ArrayItem1\"], \"tags\":[{\"id\":1, \"name\":\"TfNSW\"}], \"status\":\"hello\"}".getBytes();
                exchange.getResponseHeaders().set("content-type", "application/json");
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.createContext(context + "/pets/findByTags", exchange -> {
                byte[] response = "{\"id\":2, \"category\":{\"id\":1, \"name\":\"John Doe\"}, \"name\":\"shre\", \"photoUrls\":[\"ArrayItem1\"], \"tags\":[{\"id\":1, \"name\":\"TfNSW\"}], \"status\":\"hello\"}".getBytes();
                exchange.getResponseHeaders().set("content-type", "application/json");
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.createContext(context + "/store/inventory", exchange -> {
                byte[] response = "{ \"AVAILABLE\": 1,  \"string\": 2,  \"pending\": 2,  \"available\": 233539,  \"PENDING\": 1}".getBytes();
                exchange.getResponseHeaders().set("content-type", "application/json");
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.createContext(context + "/pet/3", exchange -> {
                byte[] response = "{\"id\":3, \"category\":{\"id\":1, \"name\":\"John Doe\"}, \"name\":\"shre\", \"photoUrls\":[\"ArrayItem1\"], \"tags\":[{\"id\":1, \"name\":\"TfNSW\"}], \"status\":\"hello\"}".getBytes();
                exchange.getResponseHeaders().set("content-type", "application/json");
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.createContext(context + "/store/order/1", exchange -> {
                byte[] response;
                if (exchange.getRequestHeaders().containsKey("Authorization") && exchange.getRequestHeaders().get("Authorization").toString().contains("Basic YWRtaW46aGVsbG8=")) {
                    response = "{ \"AVAILABLE\": 1,  \"string\": 2,  \"pending\": 2,  \"available\": 233539,  \"PENDING\": 1}".getBytes();
                    exchange.getResponseHeaders().set("content-type", "application/json");
                    exchange.sendResponseHeaders(200, response.length);
                } else {
                    response = "{\"fault\":\"Authorization credentials are not provided.\"}".getBytes();
                    exchange.getResponseHeaders().set("content-type", "application/json");
                    exchange.sendResponseHeaders(401, response.length);
                }
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.createContext(context + "/user/john", exchange -> {
                byte[] response;
                if (exchange.getRequestHeaders().containsKey("Authorization") && exchange.getRequestHeaders().get("Authorization").toString().contains("Basic YWRtaW46aGVsbG8=")) {
                    response = "{ \"name\": \"john\" }".getBytes();
                    exchange.getResponseHeaders().set("content-type", "application/json");
                    exchange.sendResponseHeaders(200, response.length);
                } else {
                    response = "{\"fault\":\"Forbidden.\"}".getBytes();
                    exchange.getResponseHeaders().set("content-type", "application/json");
                    exchange.sendResponseHeaders(403, response.length);
                }
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.createContext(context + "/jwtheader", exchange -> {
                byte[] response = exchange.getRequestHeaders().containsKey("X-JWT-Assertion") ? "\"{\"header\":\"available\"}\"".getBytes() : "\"{\"header\":\"not available\"}\"".getBytes();
                exchange.getResponseHeaders().set(HttpHeaderNames.CONTENT_TYPE.toString(), "application/json");
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.createContext(context + "/jwttoken", exchange -> {
                byte[] response;
                if (exchange.getRequestHeaders().containsKey("X-JWT-Assertion")) {
                    String token = exchange.getRequestHeaders().get("X-JWT-Assertion").toString();
                    token = token.substring(1, token.length() - 1);
                    JSONObject responseJSON = new JSONObject();
                    responseJSON.put("token", (Object)token);
                    response = responseJSON.toString().getBytes();
                } else {
                    response = "\"{\"header\":\"not available\"}\"".getBytes();
                }
                exchange.getResponseHeaders().set(HttpHeaderNames.CONTENT_TYPE.toString(), "application/json");
                exchange.sendResponseHeaders(200, response.length);
                exchange.getResponseBody().write(response);
                exchange.close();
            });
            this.httpServer.start();
            this.backEndServerUrl = "http://localhost:" + this.backEndServerPort;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error occurred while setting up mock server", ex);
        }
    }

    public void stopIt() {
        this.httpServer.stop(0);
    }

    private SSLContext getSslContext() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        char[] password = "wso2carbon".toCharArray();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        InputStream keyStoreIS = Thread.currentThread().getContextClassLoader().getResourceAsStream("wso2carbon.jks");
        keyStore.load(keyStoreIS, password);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, password);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        KeyStore trustStore = KeyStore.getInstance("JKS");
        InputStream trustStoreIS = Thread.currentThread().getContextClassLoader().getResourceAsStream("client-truststore.jks");
        trustStore.load(trustStoreIS, password);
        tmf.init(trustStore);
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }
}

