/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;

@Parameters(commandNames={"build"}, commandDescription="micro gateway build information")
public class BuildCmd
implements GatewayLauncherCmd {
    private static PrintStream outStream = System.err;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(names={"-n", "--project"}, hidden=true)
    private String projectName;
    @Parameter(names={"--help", "-h", "?"}, hidden=true, description="for more information")
    private boolean helpFlag;
    @Parameter(arity=1)
    private List<String> argList;
    private JCommander parentCmdParser;

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = this.getCommandUsageInfo("build");
            outStream.println(commandUsageInfo);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.projectName)) {
            outStream.println("Label can't be empty. You need to specify -n <project name>");
            return;
        }
        try {
            String projectRoot = GatewayCmdUtils.getStoredWorkspaceLocation();
            GatewayCmdUtils.createLabelGWDistribution(projectRoot, this.projectName);
        }
        catch (IOException e) {
            outStream.println("Error while creating micro gateway distribution for project " + this.projectName + ". Reason: " + e.getMessage());
            Runtime.getRuntime().exit(1);
        }
        Runtime.getRuntime().exit(0);
    }

    @Override
    public String getName() {
        return "build";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
        this.parentCmdParser = parentCmdParser;
    }
}

