/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.MissingCommandException;
import com.beust.jcommander.ParameterException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.apimgt.gateway.cli.cmd.BuildCmd;
import org.wso2.apimgt.gateway.cli.cmd.DefaultCmd;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.cmd.HelpCmd;
import org.wso2.apimgt.gateway.cli.cmd.ResetCmd;
import org.wso2.apimgt.gateway.cli.cmd.RunCmd;
import org.wso2.apimgt.gateway.cli.cmd.SetupCmd;
import org.wso2.apimgt.gateway.cli.exception.CLIRuntimeException;
import org.wso2.apimgt.gateway.cli.exception.CliLauncherException;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;

public class Main {
    private static final String JC_UNKNOWN_OPTION_PREFIX = "Unknown option:";
    private static final String JC_EXPECTED_A_VALUE_AFTER_PARAMETER_PREFIX = "Expected a value after parameter";
    public static final String MICRO_GW = "micro-gw";
    private static PrintStream outStream = System.err;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) {
        try {
            Optional<GatewayLauncherCmd> optionalInvokedCmd = Main.getInvokedCmd(args);
            optionalInvokedCmd.ifPresent(GatewayLauncherCmd::execute);
        }
        catch (CliLauncherException e) {
            outStream.println(e.getMessages());
            Runtime.getRuntime().exit(1);
        }
        catch (CLIRuntimeException e) {
            outStream.println(e.getMessage());
            Runtime.getRuntime().exit(1);
        }
    }

    private static Optional<GatewayLauncherCmd> getInvokedCmd(String ... args) {
        try {
            DefaultCmd defaultCmd = new DefaultCmd();
            JCommander cmdParser = new JCommander((Object)defaultCmd);
            defaultCmd.setParentCmdParser(cmdParser);
            HelpCmd helpCmd = new HelpCmd();
            cmdParser.addCommand("help", (Object)helpCmd);
            helpCmd.setParentCmdParser(cmdParser);
            SetupCmd setupCmd = new SetupCmd();
            cmdParser.addCommand("setup", (Object)setupCmd);
            setupCmd.setParentCmdParser(cmdParser);
            BuildCmd buildCmd = new BuildCmd();
            cmdParser.addCommand("build", (Object)buildCmd);
            buildCmd.setParentCmdParser(cmdParser);
            RunCmd runCmd = new RunCmd();
            cmdParser.addCommand("run", (Object)runCmd);
            runCmd.setParentCmdParser(cmdParser);
            ResetCmd resetCmd = new ResetCmd();
            cmdParser.addCommand("reset", (Object)resetCmd);
            resetCmd.setParentCmdParser(cmdParser);
            cmdParser.setProgramName(MICRO_GW);
            cmdParser.parse(args);
            String parsedCmdName = cmdParser.getParsedCommand();
            if (parsedCmdName == null) {
                return Optional.of(defaultCmd);
            }
            Map commanderMap = cmdParser.getCommands();
            return Optional.of((GatewayLauncherCmd)((JCommander)commanderMap.get(parsedCmdName)).getObjects().get(0));
        }
        catch (MissingCommandException e) {
            String errorMsg = "Unknown command '" + e.getUnknownCommand() + "'";
            throw GatewayCmdUtils.createUsageException(errorMsg);
        }
        catch (ParameterException e) {
            String msg = e.getMessage();
            if (msg == null) {
                throw GatewayCmdUtils.createUsageException("Internal error occurred");
            }
            if (msg.startsWith(JC_UNKNOWN_OPTION_PREFIX)) {
                String flag = msg.substring(JC_UNKNOWN_OPTION_PREFIX.length());
                throw GatewayCmdUtils.createUsageException("Unknown flag '" + flag.trim() + "'");
            }
            if (msg.startsWith(JC_EXPECTED_A_VALUE_AFTER_PARAMETER_PREFIX)) {
                String flag = msg.substring(JC_EXPECTED_A_VALUE_AFTER_PARAMETER_PREFIX.length());
                throw GatewayCmdUtils.createUsageException("Flag '" + flag.trim() + "' needs an argument");
            }
            throw GatewayCmdUtils.createUsageException(GatewayCmdUtils.makeFirstLetterLowerCase(msg));
        }
    }
}

