/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.apimgt.gateway.cli.cmd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.packerina.init.InitHandler;
import org.wso2.apimgt.gateway.cli.cmd.GatewayLauncherCmd;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerationContext;
import org.wso2.apimgt.gateway.cli.codegen.CodeGenerator;
import org.wso2.apimgt.gateway.cli.codegen.ThrottlePolicyGenerator;
import org.wso2.apimgt.gateway.cli.config.TOMLConfigParser;
import org.wso2.apimgt.gateway.cli.exception.BallerinaServiceGenException;
import org.wso2.apimgt.gateway.cli.exception.CliLauncherException;
import org.wso2.apimgt.gateway.cli.exception.ConfigParserException;
import org.wso2.apimgt.gateway.cli.exception.HashingException;
import org.wso2.apimgt.gateway.cli.hashing.HashUtils;
import org.wso2.apimgt.gateway.cli.model.config.Client;
import org.wso2.apimgt.gateway.cli.model.config.Config;
import org.wso2.apimgt.gateway.cli.model.config.ContainerConfig;
import org.wso2.apimgt.gateway.cli.model.config.Token;
import org.wso2.apimgt.gateway.cli.model.config.TokenBuilder;
import org.wso2.apimgt.gateway.cli.model.rest.ext.ExtendedAPI;
import org.wso2.apimgt.gateway.cli.model.rest.policy.ApplicationThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.model.rest.policy.SubscriptionThrottlePolicyDTO;
import org.wso2.apimgt.gateway.cli.oauth.OAuthServiceImpl;
import org.wso2.apimgt.gateway.cli.rest.RESTAPIServiceImpl;
import org.wso2.apimgt.gateway.cli.utils.GatewayCmdUtils;

@Parameters(commandNames={"setup"}, commandDescription="setup information")
public class SetupCmd
implements GatewayLauncherCmd {
    private static PrintStream outStream = System.err;
    @Parameter(names={"--java.debug"}, hidden=true)
    private String javaDebugPort;
    @Parameter(names={"-u", "--username"}, hidden=true)
    private String username;
    @Parameter(names={"-p", "--password"}, hidden=true)
    private String password;
    @Parameter(names={"-l", "--label"}, hidden=true)
    private String label;
    @Parameter(names={"--reset"}, hidden=true)
    private boolean reset;
    @Parameter(names={"--path"}, hidden=true)
    private String workspace;
    @Parameter(names={"--server-url"}, hidden=true)
    private String baseUrl;
    @Parameter(names={"-t", "--truststore"}, hidden=true)
    private String trustStoreLocation;
    @Parameter(names={"-s", "--truststore-pass"}, hidden=true)
    private String trustStorePassword;
    @Parameter(names={"-n", "--project"}, hidden=true)
    private String projectName;
    @Parameter(names={"-c", "--config"}, hidden=true)
    private String configPath;
    private String publisherEndpoint;
    private String adminEndpoint;
    private String registrationEndpoint;
    private String tokenEndpoint;
    private String clientID;
    private String clientSecret;

    @Override
    public void execute() {
        File trustStoreFile;
        String configuredTrustStorePass;
        String encryptedPass;
        String configuredTrustStore;
        if (StringUtils.isEmpty((CharSequence)this.label)) {
            outStream.println("Label can't be empty. You need to specify -l <label name>");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.projectName)) {
            this.projectName = this.label;
        }
        if (StringUtils.isEmpty((CharSequence)this.configPath)) {
            this.configPath = GatewayCmdUtils.getMainConfigLocation();
        }
        SetupCmd.init(this.workspace, this.projectName, this.configPath);
        Config config = GatewayCmdUtils.getConfig();
        boolean isOverwriteRequired = false;
        String configuredUser = config.getToken().getUsername();
        if (StringUtils.isEmpty((CharSequence)configuredUser)) {
            if (StringUtils.isEmpty((CharSequence)this.username)) {
                isOverwriteRequired = true;
                this.username = this.promptForTextInput("Enter Username: ");
                if (this.username.trim().isEmpty()) {
                    throw GatewayCmdUtils.createUsageException("Micro gateway setup failed: empty username.");
                }
            }
        } else {
            this.username = configuredUser;
        }
        if (StringUtils.isEmpty((CharSequence)this.password) && (this.password = this.promptForPasswordInput("Enter Password for " + this.username + ": ")).trim().isEmpty() && StringUtils.isEmpty((CharSequence)this.password)) {
            this.password = this.promptForPasswordInput("Password can't be empty; enter password for " + this.username + ": ");
            if (this.password.trim().isEmpty()) {
                throw GatewayCmdUtils.createUsageException("Micro gateway setup failed: empty password.");
            }
        }
        this.publisherEndpoint = config.getToken().getPublisherEndpoint();
        this.adminEndpoint = config.getToken().getAdminEndpoint();
        this.registrationEndpoint = config.getToken().getRegistrationEndpoint();
        this.tokenEndpoint = config.getToken().getTokenEndpoint();
        if (StringUtils.isEmpty((CharSequence)this.publisherEndpoint) || StringUtils.isEmpty((CharSequence)this.adminEndpoint) || StringUtils.isEmpty((CharSequence)this.registrationEndpoint) || StringUtils.isEmpty((CharSequence)this.tokenEndpoint)) {
            if (StringUtils.isEmpty((CharSequence)this.baseUrl)) {
                isOverwriteRequired = true;
                this.baseUrl = this.promptForTextInput("Enter APIM base URL [https://localhost:9443/]: ");
                if (this.baseUrl.trim().isEmpty()) {
                    this.baseUrl = "https://localhost:9443/";
                    this.populateHosts(this.baseUrl);
                }
            } else {
                this.populateHosts(this.baseUrl);
            }
        }
        if (StringUtils.isEmpty((CharSequence)(configuredTrustStore = config.getToken().getTrustStoreLocation()))) {
            if (StringUtils.isEmpty((CharSequence)this.trustStoreLocation)) {
                isOverwriteRequired = true;
                this.trustStoreLocation = this.promptForTextInput("Enter Trust store location: [lib/platform/bre/security/ballerinaTruststore.p12]");
                if (this.trustStoreLocation.trim().isEmpty()) {
                    this.trustStoreLocation = "lib/platform/bre/security/ballerinaTruststore.p12";
                }
            }
        } else {
            this.trustStoreLocation = configuredTrustStore;
        }
        if (StringUtils.isEmpty((CharSequence)(encryptedPass = config.getToken().getTrustStorePassword()))) {
            configuredTrustStorePass = null;
        } else {
            try {
                configuredTrustStorePass = GatewayCmdUtils.decrypt(encryptedPass, new String(this.password));
            }
            catch (CliLauncherException e) {
                configuredTrustStorePass = null;
            }
        }
        if (StringUtils.isEmpty(configuredTrustStorePass)) {
            if (StringUtils.isEmpty((CharSequence)this.trustStorePassword)) {
                isOverwriteRequired = true;
                this.trustStorePassword = this.promptForTextInput("Enter Trust store password: [ use default? ]");
                if (this.trustStorePassword.trim().isEmpty()) {
                    this.trustStorePassword = "ballerina";
                }
            }
        } else {
            this.trustStorePassword = configuredTrustStorePass;
        }
        if (!(trustStoreFile = new File(this.trustStoreLocation)).isAbsolute()) {
            this.trustStoreLocation = GatewayCmdUtils.getCLIHome() + File.separator + this.trustStoreLocation;
        }
        if (!(trustStoreFile = new File(this.trustStoreLocation)).exists()) {
            System.err.println("Error while loading trust store location: " + this.trustStoreLocation);
            Runtime.getRuntime().exit(1);
        }
        System.setProperty("javax.net.ssl.keyStoreType", "pkcs12");
        System.setProperty("javax.net.ssl.trustStore", this.trustStoreLocation);
        System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
        OAuthServiceImpl manager = new OAuthServiceImpl();
        if (config != null) {
            this.clientID = config.getToken().getClientId();
            String encryptedSecret = config.getToken().getClientSecret();
            if (!StringUtils.isEmpty((CharSequence)this.clientID.trim()) && !StringUtils.isEmpty((CharSequence)encryptedSecret.trim())) {
                try {
                    this.clientSecret = GatewayCmdUtils.decrypt(encryptedSecret, new String(this.password));
                }
                catch (CliLauncherException e) {
                    this.clientSecret = null;
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)this.clientID) || StringUtils.isEmpty((CharSequence)this.clientSecret)) {
            String[] clientInfo = manager.generateClientIdAndSecret(this.registrationEndpoint, this.username, this.password.toCharArray());
            this.clientID = clientInfo[0];
            this.clientSecret = clientInfo[1];
        }
        String accessToken = manager.generateAccessToken(this.tokenEndpoint, this.username, this.password.toCharArray(), this.clientID, this.clientSecret);
        RESTAPIServiceImpl service = new RESTAPIServiceImpl(this.publisherEndpoint, this.adminEndpoint);
        List<ExtendedAPI> apis = service.getAPIs(this.label, accessToken);
        List<ApplicationThrottlePolicyDTO> applicationPolicies = service.getApplicationPolicies(accessToken);
        List<SubscriptionThrottlePolicyDTO> subscriptionPolicies = service.getSubscriptionPolicies(accessToken);
        ThrottlePolicyGenerator policyGenerator = new ThrottlePolicyGenerator();
        CodeGenerator codeGenerator = new CodeGenerator();
        boolean changesDetected = false;
        try {
            policyGenerator.generate(GatewayCmdUtils.getLabelSrcDirectoryPath(this.workspace, this.projectName) + File.separator + "policies", applicationPolicies, subscriptionPolicies);
            codeGenerator.generate(this.workspace, this.projectName, apis, true);
            InitHandler.initialize((Path)Paths.get(GatewayCmdUtils.getLabelDirectoryPath(this.workspace, this.projectName), new String[0]), null, new ArrayList(), null);
            try {
                changesDetected = HashUtils.detectChanges(apis, subscriptionPolicies, applicationPolicies);
            }
            catch (HashingException e) {
                outStream.println("Error while checking for changes of resources. Skipping no-change detection..");
                Runtime.getRuntime().exit(1);
            }
        }
        catch (IOException | BallerinaServiceGenException e) {
            outStream.println("Error while generating ballerina source");
            e.printStackTrace();
            Runtime.getRuntime().exit(1);
        }
        if (isOverwriteRequired) {
            Config newConfig = new Config();
            Client client = new Client();
            client.setHttpRequestTimeout(1000000);
            newConfig.setClient(client);
            String encryptedSecret = GatewayCmdUtils.encrypt(this.clientSecret, new String(this.password));
            String encryptedTrustStorePass = GatewayCmdUtils.encrypt(this.trustStorePassword, new String(this.password));
            Token token = new TokenBuilder().setPublisherEndpoint(this.publisherEndpoint).setAdminEndpoint(this.adminEndpoint).setRegistrationEndpoint(this.registrationEndpoint).setTokenEndpoint(this.tokenEndpoint).setUsername(this.username).setClientId(this.clientID).setClientSecret(encryptedSecret).setTrustStoreLocation(this.trustStoreLocation).setTrustStorePassword(encryptedTrustStorePass).build();
            newConfig.setToken(token);
            newConfig.setCorsConfiguration(GatewayCmdUtils.getDefaultCorsConfig());
            GatewayCmdUtils.saveConfig(newConfig, this.configPath);
        }
        if (!changesDetected) {
            outStream.println("No changes from server.");
            Runtime.getRuntime().exit(34);
        }
    }

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public void setParentCmdParser(JCommander parentCmdParser) {
    }

    private String promptForTextInput(String msg) {
        outStream.println(msg);
        return System.console().readLine();
    }

    private String promptForPasswordInput(String msg) {
        outStream.println(msg);
        return new String(System.console().readPassword());
    }

    private void populateHosts(String host) {
        try {
            this.publisherEndpoint = new URL(new URL(host), "/api/am/publisher/v0.13").toString();
            this.adminEndpoint = new URL(new URL(host), "/api/am/admin/v0.13").toString();
            this.registrationEndpoint = new URL(new URL(host), "/client-registration/v0.13/register").toString();
            this.tokenEndpoint = new URL(new URL(host), "/oauth2/token").toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL is provided");
        }
    }

    private static void init(String overrideProjectRootPath, String label, String configPath) {
        try {
            String projectRoot;
            if (StringUtils.isBlank((CharSequence)overrideProjectRootPath)) {
                String storedProjectRoot = GatewayCmdUtils.getStoredWorkspaceLocation();
                if (StringUtils.isBlank((CharSequence)storedProjectRoot)) {
                    outStream.println("Stored workspace path not available. You need to specify --path <path to generate resources>");
                    Runtime.getRuntime().exit(1);
                }
                projectRoot = storedProjectRoot;
            } else {
                projectRoot = overrideProjectRootPath;
                GatewayCmdUtils.storeWorkspaceLocation(projectRoot);
                GatewayCmdUtils.createMainProjectStructure(projectRoot);
                GatewayCmdUtils.createLabelProjectStructure(projectRoot, label);
                GatewayCmdUtils.createLabelConfig(projectRoot, label);
            }
            GatewayCmdUtils.createLabelProjectStructure(projectRoot, label);
            Path configurationFile = Paths.get(configPath, new String[0]);
            if (Files.exists(configurationFile, new LinkOption[0])) {
                Config config = TOMLConfigParser.parse(configPath, Config.class);
                GatewayCmdUtils.setConfig(config);
            } else {
                outStream.println("Config: " + configPath + " Not found.");
                Runtime.getRuntime().exit(1);
            }
            String labelConfigPath = GatewayCmdUtils.getLabelConfigLocation(projectRoot, label);
            ContainerConfig containerConfig = TOMLConfigParser.parse(labelConfigPath, ContainerConfig.class);
            GatewayCmdUtils.setContainerConfig(containerConfig);
            CodeGenerationContext codeGenerationContext = new CodeGenerationContext();
            codeGenerationContext.setLabel(label);
            GatewayCmdUtils.setCodeGenerationContext(codeGenerationContext);
        }
        catch (ConfigParserException e) {
            outStream.println("Error while parsing the config" + (e.getCause() != null ? ": " + e.getCause().getMessage() : ""));
            Runtime.getRuntime().exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            outStream.println("Error while processing files:" + e.getMessage());
            Runtime.getRuntime().exit(1);
        }
    }
}

